/* server functions auto-generated by pidl */
#include "autoconf/librpc/gen_ndr/ndr_wkssvc.h"

NTSTATUS dcerpc_server_wkssvc_init(void);

/* wkssvc - dcerpc server boilerplate generated by pidl */


static NTSTATUS wkssvc__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_WKSSVC_BIND
	return DCESRV_INTERFACE_WKSSVC_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void wkssvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WKSSVC_UNBIND
	DCESRV_INTERFACE_WKSSVC_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS wkssvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_wkssvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_wkssvc.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_wkssvc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_wkssvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_wkssvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct wkssvc_NetWkstaGetInfo *r2 = (struct wkssvc_NetWkstaGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaGetInfo will reply async\n"));
		}
		break;
	}
	case 1: {
		struct wkssvc_NetWkstaSetInfo *r2 = (struct wkssvc_NetWkstaSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaSetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaSetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaSetInfo will reply async\n"));
		}
		break;
	}
	case 2: {
		struct wkssvc_NetWkstaEnumUsers *r2 = (struct wkssvc_NetWkstaEnumUsers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaEnumUsers, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaEnumUsers(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaEnumUsers will reply async\n"));
		}
		break;
	}
	case 3: {
		struct wkssvc_NetrWkstaUserGetInfo *r2 = (struct wkssvc_NetrWkstaUserGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrWkstaUserGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaUserGetInfo will reply async\n"));
		}
		break;
	}
	case 4: {
		struct wkssvc_NetrWkstaUserSetInfo *r2 = (struct wkssvc_NetrWkstaUserSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserSetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrWkstaUserSetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaUserSetInfo will reply async\n"));
		}
		break;
	}
	case 5: {
		struct wkssvc_NetWkstaTransportEnum *r2 = (struct wkssvc_NetWkstaTransportEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaTransportEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaTransportEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaTransportEnum will reply async\n"));
		}
		break;
	}
	case 6: {
		struct wkssvc_NetrWkstaTransportAdd *r2 = (struct wkssvc_NetrWkstaTransportAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportAdd, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrWkstaTransportAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaTransportAdd will reply async\n"));
		}
		break;
	}
	case 7: {
		struct wkssvc_NetrWkstaTransportDel *r2 = (struct wkssvc_NetrWkstaTransportDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrWkstaTransportDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaTransportDel will reply async\n"));
		}
		break;
	}
	case 8: {
		struct wkssvc_NetrUseAdd *r2 = (struct wkssvc_NetrUseAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseAdd, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUseAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseAdd will reply async\n"));
		}
		break;
	}
	case 9: {
		struct wkssvc_NetrUseGetInfo *r2 = (struct wkssvc_NetrUseGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUseGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseGetInfo will reply async\n"));
		}
		break;
	}
	case 10: {
		struct wkssvc_NetrUseDel *r2 = (struct wkssvc_NetrUseDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUseDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseDel will reply async\n"));
		}
		break;
	}
	case 11: {
		struct wkssvc_NetrUseEnum *r2 = (struct wkssvc_NetrUseEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUseEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseEnum will reply async\n"));
		}
		break;
	}
	case 12: {
		struct wkssvc_NetrMessageBufferSend *r2 = (struct wkssvc_NetrMessageBufferSend *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrMessageBufferSend, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrMessageBufferSend(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrMessageBufferSend will reply async\n"));
		}
		break;
	}
	case 13: {
		struct wkssvc_NetrWorkstationStatisticsGet *r2 = (struct wkssvc_NetrWorkstationStatisticsGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWorkstationStatisticsGet, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrWorkstationStatisticsGet(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWorkstationStatisticsGet will reply async\n"));
		}
		break;
	}
	case 14: {
		struct wkssvc_NetrLogonDomainNameAdd *r2 = (struct wkssvc_NetrLogonDomainNameAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameAdd, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrLogonDomainNameAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrLogonDomainNameAdd will reply async\n"));
		}
		break;
	}
	case 15: {
		struct wkssvc_NetrLogonDomainNameDel *r2 = (struct wkssvc_NetrLogonDomainNameDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrLogonDomainNameDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrLogonDomainNameDel will reply async\n"));
		}
		break;
	}
	case 16: {
		struct wkssvc_NetrJoinDomain *r2 = (struct wkssvc_NetrJoinDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrJoinDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain will reply async\n"));
		}
		break;
	}
	case 17: {
		struct wkssvc_NetrUnjoinDomain *r2 = (struct wkssvc_NetrUnjoinDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUnjoinDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain will reply async\n"));
		}
		break;
	}
	case 18: {
		struct wkssvc_NetrRenameMachineInDomain *r2 = (struct wkssvc_NetrRenameMachineInDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrRenameMachineInDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain will reply async\n"));
		}
		break;
	}
	case 19: {
		struct wkssvc_NetrValidateName *r2 = (struct wkssvc_NetrValidateName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrValidateName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrValidateName will reply async\n"));
		}
		break;
	}
	case 20: {
		struct wkssvc_NetrGetJoinInformation *r2 = (struct wkssvc_NetrGetJoinInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinInformation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrGetJoinInformation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinInformation will reply async\n"));
		}
		break;
	}
	case 21: {
		struct wkssvc_NetrGetJoinableOus *r2 = (struct wkssvc_NetrGetJoinableOus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrGetJoinableOus(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinableOus will reply async\n"));
		}
		break;
	}
	case 22: {
		struct wkssvc_NetrJoinDomain2 *r2 = (struct wkssvc_NetrJoinDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrJoinDomain2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain2 will reply async\n"));
		}
		break;
	}
	case 23: {
		struct wkssvc_NetrUnjoinDomain2 *r2 = (struct wkssvc_NetrUnjoinDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUnjoinDomain2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain2 will reply async\n"));
		}
		break;
	}
	case 24: {
		struct wkssvc_NetrRenameMachineInDomain2 *r2 = (struct wkssvc_NetrRenameMachineInDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrRenameMachineInDomain2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain2 will reply async\n"));
		}
		break;
	}
	case 25: {
		struct wkssvc_NetrValidateName2 *r2 = (struct wkssvc_NetrValidateName2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrValidateName2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrValidateName2 will reply async\n"));
		}
		break;
	}
	case 26: {
		struct wkssvc_NetrGetJoinableOus2 *r2 = (struct wkssvc_NetrGetJoinableOus2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrGetJoinableOus2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinableOus2 will reply async\n"));
		}
		break;
	}
	case 27: {
		struct wkssvc_NetrAddAlternateComputerName *r2 = (struct wkssvc_NetrAddAlternateComputerName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrAddAlternateComputerName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrAddAlternateComputerName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrAddAlternateComputerName will reply async\n"));
		}
		break;
	}
	case 28: {
		struct wkssvc_NetrRemoveAlternateComputerName *r2 = (struct wkssvc_NetrRemoveAlternateComputerName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRemoveAlternateComputerName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrRemoveAlternateComputerName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRemoveAlternateComputerName will reply async\n"));
		}
		break;
	}
	case 29: {
		struct wkssvc_NetrSetPrimaryComputername *r2 = (struct wkssvc_NetrSetPrimaryComputername *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrSetPrimaryComputername, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrSetPrimaryComputername(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrSetPrimaryComputername will reply async\n"));
		}
		break;
	}
	case 30: {
		struct wkssvc_NetrEnumerateComputerNames *r2 = (struct wkssvc_NetrEnumerateComputerNames *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrEnumerateComputerNames, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrEnumerateComputerNames(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrEnumerateComputerNames will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_wkssvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct wkssvc_NetWkstaGetInfo *r2 = (struct wkssvc_NetWkstaGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct wkssvc_NetWkstaSetInfo *r2 = (struct wkssvc_NetWkstaSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct wkssvc_NetWkstaEnumUsers *r2 = (struct wkssvc_NetWkstaEnumUsers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaEnumUsers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaEnumUsers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaEnumUsers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct wkssvc_NetrWkstaUserGetInfo *r2 = (struct wkssvc_NetrWkstaUserGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaUserGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrWkstaUserGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct wkssvc_NetrWkstaUserSetInfo *r2 = (struct wkssvc_NetrWkstaUserSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaUserSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrWkstaUserSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct wkssvc_NetWkstaTransportEnum *r2 = (struct wkssvc_NetWkstaTransportEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaTransportEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaTransportEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaTransportEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct wkssvc_NetrWkstaTransportAdd *r2 = (struct wkssvc_NetrWkstaTransportAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaTransportAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrWkstaTransportAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct wkssvc_NetrWkstaTransportDel *r2 = (struct wkssvc_NetrWkstaTransportDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaTransportDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrWkstaTransportDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct wkssvc_NetrUseAdd *r2 = (struct wkssvc_NetrUseAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUseAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct wkssvc_NetrUseGetInfo *r2 = (struct wkssvc_NetrUseGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUseGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct wkssvc_NetrUseDel *r2 = (struct wkssvc_NetrUseDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUseDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct wkssvc_NetrUseEnum *r2 = (struct wkssvc_NetrUseEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUseEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct wkssvc_NetrMessageBufferSend *r2 = (struct wkssvc_NetrMessageBufferSend *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrMessageBufferSend replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrMessageBufferSend, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrMessageBufferSend\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct wkssvc_NetrWorkstationStatisticsGet *r2 = (struct wkssvc_NetrWorkstationStatisticsGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWorkstationStatisticsGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWorkstationStatisticsGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrWorkstationStatisticsGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct wkssvc_NetrLogonDomainNameAdd *r2 = (struct wkssvc_NetrLogonDomainNameAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrLogonDomainNameAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrLogonDomainNameAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct wkssvc_NetrLogonDomainNameDel *r2 = (struct wkssvc_NetrLogonDomainNameDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrLogonDomainNameDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrLogonDomainNameDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct wkssvc_NetrJoinDomain *r2 = (struct wkssvc_NetrJoinDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrJoinDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct wkssvc_NetrUnjoinDomain *r2 = (struct wkssvc_NetrUnjoinDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUnjoinDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct wkssvc_NetrRenameMachineInDomain *r2 = (struct wkssvc_NetrRenameMachineInDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrRenameMachineInDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct wkssvc_NetrValidateName *r2 = (struct wkssvc_NetrValidateName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrValidateName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrValidateName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct wkssvc_NetrGetJoinInformation *r2 = (struct wkssvc_NetrGetJoinInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrGetJoinInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct wkssvc_NetrGetJoinableOus *r2 = (struct wkssvc_NetrGetJoinableOus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinableOus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrGetJoinableOus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct wkssvc_NetrJoinDomain2 *r2 = (struct wkssvc_NetrJoinDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrJoinDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct wkssvc_NetrUnjoinDomain2 *r2 = (struct wkssvc_NetrUnjoinDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUnjoinDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct wkssvc_NetrRenameMachineInDomain2 *r2 = (struct wkssvc_NetrRenameMachineInDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrRenameMachineInDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct wkssvc_NetrValidateName2 *r2 = (struct wkssvc_NetrValidateName2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrValidateName2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrValidateName2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct wkssvc_NetrGetJoinableOus2 *r2 = (struct wkssvc_NetrGetJoinableOus2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinableOus2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrGetJoinableOus2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct wkssvc_NetrAddAlternateComputerName *r2 = (struct wkssvc_NetrAddAlternateComputerName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrAddAlternateComputerName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrAddAlternateComputerName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrAddAlternateComputerName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct wkssvc_NetrRemoveAlternateComputerName *r2 = (struct wkssvc_NetrRemoveAlternateComputerName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRemoveAlternateComputerName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRemoveAlternateComputerName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrRemoveAlternateComputerName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct wkssvc_NetrSetPrimaryComputername *r2 = (struct wkssvc_NetrSetPrimaryComputername *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrSetPrimaryComputername replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrSetPrimaryComputername, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrSetPrimaryComputername\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct wkssvc_NetrEnumerateComputerNames *r2 = (struct wkssvc_NetrEnumerateComputerNames *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrEnumerateComputerNames replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrEnumerateComputerNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrEnumerateComputerNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_wkssvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_wkssvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_wkssvc_interface = {
	.name		= "wkssvc",
	.syntax_id  = {{0x6bffd098,0xa112,0x3610,{0x98,0x33},{0x46,0xc3,0xf8,0x7e,0x34,0x5a}},1.0},
	.bind		= wkssvc__op_bind,
	.unbind		= wkssvc__op_unbind,
	.ndr_pull	= wkssvc__op_ndr_pull,
	.dispatch	= wkssvc__op_dispatch,
	.reply		= wkssvc__op_reply,
	.ndr_push	= wkssvc__op_ndr_push
};


static NTSTATUS wkssvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_wkssvc.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_wkssvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_wkssvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("wkssvc_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool wkssvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_wkssvc_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_wkssvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_wkssvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool wkssvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_wkssvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_wkssvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_wkssvc_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "wkssvc";

	/* fill in all the operations */
	ep_server.init_server = wkssvc__op_init_server;

	ep_server.interface_by_uuid = wkssvc__op_interface_by_uuid;
	ep_server.interface_by_name = wkssvc__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'wkssvc' endpoint server!\n"));
		return ret;
	}

	return ret;
}

