require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_IRQ_H)) {
    eval 'sub _LINUX_IRQ_H () {1;}' unless defined(&_LINUX_IRQ_H);
    require 'linux/smp.ph';
    unless(defined(&CONFIG_S390)) {
	require 'linux/linkage.ph';
	require 'linux/cache.ph';
	require 'linux/spinlock.ph';
	require 'linux/cpumask.ph';
	require 'linux/irqreturn.ph';
	require 'asm/irq.ph';
	require 'asm/ptrace.ph';
	eval 'sub IRQ_TYPE_NONE () {0x;}' unless defined(&IRQ_TYPE_NONE);
	eval 'sub IRQ_TYPE_EDGE_RISING () {0x1;}' unless defined(&IRQ_TYPE_EDGE_RISING);
	eval 'sub IRQ_TYPE_EDGE_FALLING () {0x2;}' unless defined(&IRQ_TYPE_EDGE_FALLING);
	eval 'sub IRQ_TYPE_EDGE_BOTH () {( &IRQ_TYPE_EDGE_FALLING |  &IRQ_TYPE_EDGE_RISING);}' unless defined(&IRQ_TYPE_EDGE_BOTH);
	eval 'sub IRQ_TYPE_LEVEL_HIGH () {0x4;}' unless defined(&IRQ_TYPE_LEVEL_HIGH);
	eval 'sub IRQ_TYPE_LEVEL_LOW () {0x8;}' unless defined(&IRQ_TYPE_LEVEL_LOW);
	eval 'sub IRQ_TYPE_SENSE_MASK () {0xf;}' unless defined(&IRQ_TYPE_SENSE_MASK);
	eval 'sub IRQ_TYPE_PROBE () {0x10;}' unless defined(&IRQ_TYPE_PROBE);
	eval 'sub IRQ_INPROGRESS () {0x10000;}' unless defined(&IRQ_INPROGRESS);
	eval 'sub IRQ_DISABLED () {0x20000;}' unless defined(&IRQ_DISABLED);
	eval 'sub IRQ_PENDING () {0x40000;}' unless defined(&IRQ_PENDING);
	eval 'sub IRQ_REPLAY () {0x80000;}' unless defined(&IRQ_REPLAY);
	eval 'sub IRQ_AUTODETECT () {0x100000;}' unless defined(&IRQ_AUTODETECT);
	eval 'sub IRQ_WAITING () {0x200000;}' unless defined(&IRQ_WAITING);
	eval 'sub IRQ_LEVEL () {0x400000;}' unless defined(&IRQ_LEVEL);
	eval 'sub IRQ_MASKED () {0x800000;}' unless defined(&IRQ_MASKED);
	eval 'sub IRQ_PER_CPU () {0x1000000;}' unless defined(&IRQ_PER_CPU);
	if(defined(&CONFIG_IRQ_PER_CPU)) {
	    eval 'sub CHECK_IRQ_PER_CPU {
	        my($var) = @_;
    		eval q((($var) &  &IRQ_PER_CPU));
	    }' unless defined(&CHECK_IRQ_PER_CPU);
	} else {
	    eval 'sub CHECK_IRQ_PER_CPU {
	        my($var) = @_;
    		eval q(0);
	    }' unless defined(&CHECK_IRQ_PER_CPU);
	}
	eval 'sub IRQ_NOPROBE () {0x2000000;}' unless defined(&IRQ_NOPROBE);
	eval 'sub IRQ_NOREQUEST () {0x4000000;}' unless defined(&IRQ_NOREQUEST);
	eval 'sub IRQ_NOAUTOEN () {0x8000000;}' unless defined(&IRQ_NOAUTOEN);
	eval 'sub IRQ_DELAYED_DISABLE () {0x10000000;}' unless defined(&IRQ_DELAYED_DISABLE);
	eval 'sub IRQ_WAKEUP () {0x20000000;}' unless defined(&IRQ_WAKEUP);
	if(defined(&CONFIG_IRQ_RELEASE_METHOD)) {
	}
	if(defined(&CONFIG_SMP)) {
	}
	if(defined( &CONFIG_GENERIC_PENDING_IRQ) || defined( &CONFIG_IRQBALANCE)) {
	}
	if(defined(&CONFIG_PROC_FS)) {
	}
	eval 'sub hw_interrupt_type () { &irq_chip;}' unless defined(&hw_interrupt_type);
	eval 'sub no_irq_type () { &no_irq_chip;}' unless defined(&no_irq_type);
	require 'asm/hw_irq.ph';
	if(defined(&CONFIG_GENERIC_HARDIRQS)) {
	    unless(defined(&handle_dynamic_tick)) {
		eval 'sub handle_dynamic_tick {
		    my($a) = @_;
    		    eval q( &do { }  &while (0));
		}' unless defined(&handle_dynamic_tick);
	    }
	    if(defined(&CONFIG_SMP)) {
		eval 'sub set_native_irq_info {
		    my($irq,$mask) = @_;
    		    eval q({  ($irq_desc[$irq]->{affinity}) = $mask; });
		}' unless defined(&set_native_irq_info);
	    } else {
		eval 'sub set_native_irq_info {
		    my($irq,$mask) = @_;
    		    eval q({ });
		}' unless defined(&set_native_irq_info);
	    }
	    if(defined(&CONFIG_SMP)) {
		if(defined( &CONFIG_GENERIC_PENDING_IRQ) || defined( &CONFIG_IRQBALANCE)) {
		    if(defined(&CONFIG_PCI_MSI)) {
			eval 'sub set_irq_info {
			    my($irq,$mask) = @_;
    			    eval q({ });
			}' unless defined(&set_irq_info);
		    } else {
			eval 'sub move_irq {
			    my($irq) = @_;
    			    eval q({  &move_native_irq($irq); });
			}' unless defined(&move_irq);
			eval 'sub set_irq_info {
			    my($irq,$mask) = @_;
    			    eval q({  &set_native_irq_info($irq, $mask); });
			}' unless defined(&set_irq_info);
		    }
		} else {
		    eval 'sub move_irq {
		        my($irq) = @_;
    			eval q({ });
		    }' unless defined(&move_irq);
		    eval 'sub move_native_irq {
		        my($irq) = @_;
    			eval q({ });
		    }' unless defined(&move_native_irq);
		    eval 'sub set_pending_irq {
		        my($irq,$mask) = @_;
    			eval q({ });
		    }' unless defined(&set_pending_irq);
		    eval 'sub set_irq_info {
		        my($irq,$mask) = @_;
    			eval q({  &set_native_irq_info($irq, $mask); });
		    }' unless defined(&set_irq_info);
		}
	    } else {
		eval 'sub move_irq {
		    my($x) = @_;
    		    eval q();
		}' unless defined(&move_irq);
		eval 'sub move_native_irq {
		    my($x) = @_;
    		    eval q();
		}' unless defined(&move_native_irq);
	    }
	    if(defined(&CONFIG_IRQBALANCE)) {
	    } else {
		eval 'sub set_balance_irq_affinity {
		    my($irq,$mask) = @_;
    		    eval q({ });
		}' unless defined(&set_balance_irq_affinity);
	    }
	    if(defined(&CONFIG_AUTO_IRQ_AFFINITY)) {
	    } else {
		eval 'sub select_smp_affinity {
		    my($irq) = @_;
    		    eval q({ 1; });
		}' unless defined(&select_smp_affinity);
	    }
	    eval 'sub get_irq_chip {
	        my($irq) = @_;
    		eval q(( ($irq_desc[$irq]->{chip})));
	    }' unless defined(&get_irq_chip);
	    eval 'sub get_irq_chip_data {
	        my($irq) = @_;
    		eval q(( ($irq_desc[$irq]->{chip_data})));
	    }' unless defined(&get_irq_chip_data);
	    eval 'sub get_irq_data {
	        my($irq) = @_;
    		eval q(( ($irq_desc[$irq]->{handler_data})));
	    }' unless defined(&get_irq_data);
	}
    }
}
1;
