# /etc/cshrc
#
# csh configuration for all shell invocations.

# By default, we want this to get set.
# Even for non-interactive, non-login shells.
if ($uid > 99 && "`id -gn`" == "`id -un`") then
    umask 002
else
    umask 022
endif

if ($?prompt) then
  if ($?tcsh) then
    set promptchars='$#'
    set prompt=\[$user'@%m %c]%# ' 
  else
    set prompt=\[$user@`hostname -s`\]\$\ 
  endif
endif

if ( $?tcsh ) then
	bindkey "^[[3~" delete-char
endif

bindkey "^R" i-search-back
set echo_style = both
set histdup = erase
set savehist = (1024 merge)
if ($?TERM) then
  switch($TERM) 
    case xterm*:
      alias precmd 'echo -n "\033]0;${USER}@${HOSTNAME}:${PWD}"; echo -n "\007"'
      breaksw
    case screen:
      alias precmd 'echo -n "\033_${USER}@${HOSTNAME}:${PWD}"; echo -n "\033\\"'
      breaksw
    default:
      breaksw
  endsw
endif

setenv MAIL "/var/spool/mail/$USER"
limit coredumpsize 0
