require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_HUGETLB_H)) {
    eval 'sub _LINUX_HUGETLB_H () {1;}' unless defined(&_LINUX_HUGETLB_H);
    if(defined(&CONFIG_HUGETLB_PAGE)) {
	require 'linux/mempolicy.ph';
	require 'asm/tlbflush.ph';
	eval 'sub is_vm_hugetlb_page {
	    my($vma) = @_;
    	    eval q({  ($vma->{vm_flags}) &  &VM_HUGETLB; });
	}' unless defined(&is_vm_hugetlb_page);
	unless(defined(&ARCH_HAS_HUGEPAGE_ONLY_RANGE)) {
	    eval 'sub is_hugepage_only_range {
	        my($mm, $addr, $len) = @_;
    		eval q(0);
	    }' unless defined(&is_hugepage_only_range);
	}
	unless(defined(&ARCH_HAS_HUGETLB_FREE_PGD_RANGE)) {
	    eval 'sub hugetlb_free_pgd_range () { &free_pgd_range;}' unless defined(&hugetlb_free_pgd_range);
	} else {
	}
	unless(defined(&ARCH_HAS_PREPARE_HUGEPAGE_RANGE)) {
	} else {
	}
	unless(defined(&ARCH_HAS_SETCLEAR_HUGE_PTE)) {
	    eval 'sub set_huge_pte_at {
	        my($mm, $addr, $ptep, $pte) = @_;
    		eval q( &set_pte_at($mm, $addr, $ptep, $pte));
	    }' unless defined(&set_huge_pte_at);
	    eval 'sub huge_ptep_get_and_clear {
	        my($mm, $addr, $ptep) = @_;
    		eval q( &ptep_get_and_clear($mm, $addr, $ptep));
	    }' unless defined(&huge_ptep_get_and_clear);
	} else {
	}
	unless(defined(&ARCH_HAS_HUGETLB_PREFAULT_HOOK)) {
	    eval 'sub hugetlb_prefault_arch_hook {
	        my($mm) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&hugetlb_prefault_arch_hook);
	} else {
	}
    } else {
	eval 'sub is_vm_hugetlb_page {
	    my($vma) = @_;
    	    eval q({ 0; });
	}' unless defined(&is_vm_hugetlb_page);
	eval 'sub hugetlb_total_pages {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&hugetlb_total_pages);
	eval 'sub follow_hugetlb_page {
	    my($m,$v,$p,$vs,$a,$b,$i) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&follow_hugetlb_page);
	eval 'sub follow_huge_addr {
	    my($mm, $addr, $write) = @_;
    	    eval q( &ERR_PTR(- &EINVAL));
	}' unless defined(&follow_huge_addr);
	eval 'sub copy_hugetlb_page_range {
	    my($src, $dst, $vma) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&copy_hugetlb_page_range);
	eval 'sub hugetlb_prefault {
	    my($mapping, $vma) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&hugetlb_prefault);
	eval 'sub unmap_hugepage_range {
	    my($vma, $start, $end) = @_;
    	    eval q( &BUG());
	}' unless defined(&unmap_hugepage_range);
	eval 'sub hugetlb_report_meminfo {
	    my($buf) = @_;
    	    eval q(0);
	}' unless defined(&hugetlb_report_meminfo);
	eval 'sub hugetlb_report_node_meminfo {
	    my($n, $buf) = @_;
    	    eval q(0);
	}' unless defined(&hugetlb_report_node_meminfo);
	eval 'sub follow_huge_pmd {
	    my($mm, $addr, $pmd, $write) = @_;
    	    eval q( &NULL);
	}' unless defined(&follow_huge_pmd);
	eval 'sub prepare_hugepage_range {
	    my($addr, $len) = @_;
    	    eval q((- &EINVAL));
	}' unless defined(&prepare_hugepage_range);
	eval 'sub pmd_huge {
	    my($x) = @_;
    	    eval q(0);
	}' unless defined(&pmd_huge);
	eval 'sub is_hugepage_only_range {
	    my($mm, $addr, $len) = @_;
    	    eval q(0);
	}' unless defined(&is_hugepage_only_range);
	eval 'sub hugetlb_free_pgd_range {
	    my($tlb, $addr, $end, $floor, $ceiling) = @_;
    	    eval q(({ &BUG(); 0; }));
	}' unless defined(&hugetlb_free_pgd_range);
	eval 'sub hugetlb_fault {
	    my($mm, $vma, $addr, $write) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&hugetlb_fault);
	eval 'sub hugetlb_change_protection {
	    my($vma, $address, $end, $newprot) = @_;
    	    eval q();
	}' unless defined(&hugetlb_change_protection);
	unless(defined(&HPAGE_MASK)) {
	    eval 'sub HPAGE_MASK () { &PAGE_MASK;}' unless defined(&HPAGE_MASK);
	    eval 'sub HPAGE_SIZE () { &PAGE_SIZE;}' unless defined(&HPAGE_SIZE);
	}
    }
    if(defined(&CONFIG_HUGETLBFS)) {
	eval 'sub hugetlbfs_inode_info {
	    eval q(* &HUGETLBFS_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct hugetlbfs_inode_info\',  &vfs_inode); });
	}' unless defined(&hugetlbfs_inode_info);
	eval 'sub hugetlbfs_sb_info {
	    eval q(* &HUGETLBFS_SB(\'struct super_block\' * &sb) {  ($sb->{s_fs_info}); });
	}' unless defined(&hugetlbfs_sb_info);
	eval 'sub is_file_hugepages {
	    my($file) = @_;
    	    eval q({  ($file->{f_op}) ==  &hugetlbfs_file_operations; });
	}' unless defined(&is_file_hugepages);
	eval 'sub set_file_hugepages {
	    my($file) = @_;
    	    eval q({  ($file->{f_op}) =  &hugetlbfs_file_operations; });
	}' unless defined(&set_file_hugepages);
    } else {
	eval 'sub is_file_hugepages {
	    my($file) = @_;
    	    eval q(0);
	}' unless defined(&is_file_hugepages);
	eval 'sub set_file_hugepages {
	    my($file) = @_;
    	    eval q( &BUG());
	}' unless defined(&set_file_hugepages);
	eval 'sub hugetlb_zero_setup {
	    my($size) = @_;
    	    eval q( &ERR_PTR(- &ENOSYS));
	}' unless defined(&hugetlb_zero_setup);
    }
}
1;
