require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IDE_H)) {
    eval 'sub _IDE_H () {1;}' unless defined(&_IDE_H);
    require 'linux/config.ph';
    require 'linux/init.ph';
    require 'linux/ioport.ph';
    require 'linux/hdreg.ph';
    require 'linux/hdsmart.ph';
    require 'linux/blkdev.ph';
    require 'linux/proc_fs.ph';
    require 'linux/interrupt.ph';
    require 'linux/bitops.ph';
    require 'linux/bio.ph';
    require 'linux/device.ph';
    require 'linux/pci.ph';
    require 'linux/completion.ph';
    require 'asm/byteorder.ph';
    require 'asm/system.ph';
    require 'asm/io.ph';
    require 'asm/semaphore.ph';
    eval 'sub INITIAL_MULT_COUNT () {0;}' unless defined(&INITIAL_MULT_COUNT);
    unless(defined(&SUPPORT_SLOW_DATA_PORTS)) {
	eval 'sub SUPPORT_SLOW_DATA_PORTS () {1;}' unless defined(&SUPPORT_SLOW_DATA_PORTS);
    }
    unless(defined(&SUPPORT_VLB_SYNC)) {
	eval 'sub SUPPORT_VLB_SYNC () {1;}' unless defined(&SUPPORT_VLB_SYNC);
    }
    unless(defined(&OK_TO_RESET_CONTROLLER)) {
	eval 'sub OK_TO_RESET_CONTROLLER () {1;}' unless defined(&OK_TO_RESET_CONTROLLER);
    }
    unless(defined(&DISABLE_IRQ_NOSYNC)) {
	eval 'sub DISABLE_IRQ_NOSYNC () {0;}' unless defined(&DISABLE_IRQ_NOSYNC);
    }
    eval 'sub IDE_NO_IRQ () {(-1);}' unless defined(&IDE_NO_IRQ);
    eval 'sub ERROR_MAX () {8;}' unless defined(&ERROR_MAX);
    eval 'sub ERROR_RESET () {3;}' unless defined(&ERROR_RESET);
    eval 'sub ERROR_RECAL () {1;}' unless defined(&ERROR_RECAL);
    eval 'sub IDE_TUNE_NOAUTO () {2;}' unless defined(&IDE_TUNE_NOAUTO);
    eval 'sub IDE_TUNE_AUTO () {1;}' unless defined(&IDE_TUNE_AUTO);
    eval 'sub IDE_TUNE_DEFAULT () {0;}' unless defined(&IDE_TUNE_DEFAULT);
    eval 'sub DMA_PIO_RETRY () {1;}' unless defined(&DMA_PIO_RETRY);
    eval 'sub HWIF {
        my($drive) = @_;
	    eval q((( &ide_hwif_t *)(($drive)-> &hwif)));
    }' unless defined(&HWIF);
    eval 'sub HWGROUP {
        my($drive) = @_;
	    eval q((( &ide_hwgroup_t *)( &HWIF($drive)-> &hwgroup)));
    }' unless defined(&HWGROUP);
    eval 'sub IDE_NR_PORTS () {(10);}' unless defined(&IDE_NR_PORTS);
    eval 'sub IDE_DATA_OFFSET () {(0);}' unless defined(&IDE_DATA_OFFSET);
    eval 'sub IDE_ERROR_OFFSET () {(1);}' unless defined(&IDE_ERROR_OFFSET);
    eval 'sub IDE_NSECTOR_OFFSET () {(2);}' unless defined(&IDE_NSECTOR_OFFSET);
    eval 'sub IDE_SECTOR_OFFSET () {(3);}' unless defined(&IDE_SECTOR_OFFSET);
    eval 'sub IDE_LCYL_OFFSET () {(4);}' unless defined(&IDE_LCYL_OFFSET);
    eval 'sub IDE_HCYL_OFFSET () {(5);}' unless defined(&IDE_HCYL_OFFSET);
    eval 'sub IDE_SELECT_OFFSET () {(6);}' unless defined(&IDE_SELECT_OFFSET);
    eval 'sub IDE_STATUS_OFFSET () {(7);}' unless defined(&IDE_STATUS_OFFSET);
    eval 'sub IDE_CONTROL_OFFSET () {(8);}' unless defined(&IDE_CONTROL_OFFSET);
    eval 'sub IDE_IRQ_OFFSET () {(9);}' unless defined(&IDE_IRQ_OFFSET);
    eval 'sub IDE_FEATURE_OFFSET () { &IDE_ERROR_OFFSET;}' unless defined(&IDE_FEATURE_OFFSET);
    eval 'sub IDE_COMMAND_OFFSET () { &IDE_STATUS_OFFSET;}' unless defined(&IDE_COMMAND_OFFSET);
    eval 'sub IDE_CONTROL_OFFSET_HOB () {(7);}' unless defined(&IDE_CONTROL_OFFSET_HOB);
    eval 'sub IDE_DATA_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_DATA_OFFSET]);}' unless defined(&IDE_DATA_REG);
    eval 'sub IDE_ERROR_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_ERROR_OFFSET]);}' unless defined(&IDE_ERROR_REG);
    eval 'sub IDE_NSECTOR_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_NSECTOR_OFFSET]);}' unless defined(&IDE_NSECTOR_REG);
    eval 'sub IDE_SECTOR_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_SECTOR_OFFSET]);}' unless defined(&IDE_SECTOR_REG);
    eval 'sub IDE_LCYL_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_LCYL_OFFSET]);}' unless defined(&IDE_LCYL_REG);
    eval 'sub IDE_HCYL_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_HCYL_OFFSET]);}' unless defined(&IDE_HCYL_REG);
    eval 'sub IDE_SELECT_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_SELECT_OFFSET]);}' unless defined(&IDE_SELECT_REG);
    eval 'sub IDE_STATUS_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_STATUS_OFFSET]);}' unless defined(&IDE_STATUS_REG);
    eval 'sub IDE_CONTROL_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_CONTROL_OFFSET]);}' unless defined(&IDE_CONTROL_REG);
    eval 'sub IDE_IRQ_REG () {( &HWIF( &drive)-> $io_ports[ &IDE_IRQ_OFFSET]);}' unless defined(&IDE_IRQ_REG);
    eval 'sub IDE_FEATURE_REG () { &IDE_ERROR_REG;}' unless defined(&IDE_FEATURE_REG);
    eval 'sub IDE_COMMAND_REG () { &IDE_STATUS_REG;}' unless defined(&IDE_COMMAND_REG);
    eval 'sub IDE_ALTSTATUS_REG () { &IDE_CONTROL_REG;}' unless defined(&IDE_ALTSTATUS_REG);
    eval 'sub IDE_IREASON_REG () { &IDE_NSECTOR_REG;}' unless defined(&IDE_IREASON_REG);
    eval 'sub IDE_BCOUNTL_REG () { &IDE_LCYL_REG;}' unless defined(&IDE_BCOUNTL_REG);
    eval 'sub IDE_BCOUNTH_REG () { &IDE_HCYL_REG;}' unless defined(&IDE_BCOUNTH_REG);
    eval 'sub OK_STAT {
        my($stat,$good,$bad) = @_;
	    eval q(((($stat)(($good)|($bad)))==($good)));
    }' unless defined(&OK_STAT);
    eval 'sub BAD_R_STAT () {( &BUSY_STAT |  &ERR_STAT);}' unless defined(&BAD_R_STAT);
    eval 'sub BAD_W_STAT () {( &BAD_R_STAT |  &WRERR_STAT);}' unless defined(&BAD_W_STAT);
    eval 'sub BAD_STAT () {( &BAD_R_STAT |  &DRQ_STAT);}' unless defined(&BAD_STAT);
    eval 'sub DRIVE_READY () {( &READY_STAT |  &SEEK_STAT);}' unless defined(&DRIVE_READY);
    eval 'sub DATA_READY () {( &DRQ_STAT);}' unless defined(&DATA_READY);
    eval 'sub BAD_CRC () {( &ABRT_ERR |  &ICRC_ERR);}' unless defined(&BAD_CRC);
    eval 'sub SATA_NR_PORTS () {(3);}' unless defined(&SATA_NR_PORTS);
    eval 'sub SATA_STATUS_OFFSET () {(0);}' unless defined(&SATA_STATUS_OFFSET);
    eval 'sub SATA_STATUS_REG () {( &HWIF( &drive)-> $sata_scr[ &SATA_STATUS_OFFSET]);}' unless defined(&SATA_STATUS_REG);
    eval 'sub SATA_ERROR_OFFSET () {(1);}' unless defined(&SATA_ERROR_OFFSET);
    eval 'sub SATA_ERROR_REG () {( &HWIF( &drive)-> $sata_scr[ &SATA_ERROR_OFFSET]);}' unless defined(&SATA_ERROR_REG);
    eval 'sub SATA_CONTROL_OFFSET () {(2);}' unless defined(&SATA_CONTROL_OFFSET);
    eval 'sub SATA_CONTROL_REG () {( &HWIF( &drive)-> $sata_scr[ &SATA_CONTROL_OFFSET]);}' unless defined(&SATA_CONTROL_REG);
    eval 'sub SATA_MISC_OFFSET () {(0);}' unless defined(&SATA_MISC_OFFSET);
    eval 'sub SATA_MISC_REG () {( &HWIF( &drive)-> $sata_misc[ &SATA_MISC_OFFSET]);}' unless defined(&SATA_MISC_REG);
    eval 'sub SATA_PHY_OFFSET () {(1);}' unless defined(&SATA_PHY_OFFSET);
    eval 'sub SATA_PHY_REG () {( &HWIF( &drive)-> $sata_misc[ &SATA_PHY_OFFSET]);}' unless defined(&SATA_PHY_REG);
    eval 'sub SATA_IEN_OFFSET () {(2);}' unless defined(&SATA_IEN_OFFSET);
    eval 'sub SATA_IEN_REG () {( &HWIF( &drive)-> $sata_misc[ &SATA_IEN_OFFSET]);}' unless defined(&SATA_IEN_REG);
    eval 'sub PRD_BYTES () {8;}' unless defined(&PRD_BYTES);
    eval 'sub PRD_ENTRIES () {256;}' unless defined(&PRD_ENTRIES);
    eval 'sub PARTN_BITS () {6;}' unless defined(&PARTN_BITS);
    eval 'sub MAX_DRIVES () {2;}' unless defined(&MAX_DRIVES);
    eval 'sub SECTOR_SIZE () {512;}' unless defined(&SECTOR_SIZE);
    eval 'sub SECTOR_WORDS () {( &SECTOR_SIZE / 4);}' unless defined(&SECTOR_WORDS);
    eval 'sub IDE_LARGE_SEEK {
        my($b1,$b2,$t) = @_;
	    eval q(((($b1) > ($b2) + ($t)) || (($b2) > ($b1) + ($t))));
    }' unless defined(&IDE_LARGE_SEEK);
    eval 'sub WAIT_DRQ () {( &HZ/10);}' unless defined(&WAIT_DRQ);
    eval 'sub WAIT_READY () {(5* &HZ);}' unless defined(&WAIT_READY);
    eval 'sub WAIT_PIDENTIFY () {(10* &HZ);}' unless defined(&WAIT_PIDENTIFY);
    eval 'sub WAIT_WORSTCASE () {(30* &HZ);}' unless defined(&WAIT_WORSTCASE);
    eval 'sub WAIT_CMD () {(10* &HZ);}' unless defined(&WAIT_CMD);
    eval 'sub WAIT_MIN_SLEEP () {(2* &HZ/100);}' unless defined(&WAIT_MIN_SLEEP);
    unless(defined(&NO_DMA)) {
	eval 'sub NO_DMA () {255;}' unless defined(&NO_DMA);
    }
    eval("sub ide_unknown () { 0; }") unless defined(&ide_unknown);
    eval("sub ide_generic () { 1; }") unless defined(&ide_generic);
    eval("sub ide_pci () { 2; }") unless defined(&ide_pci);
    eval("sub ide_cmd640 () { 3; }") unless defined(&ide_cmd640);
    eval("sub ide_dtc2278 () { 4; }") unless defined(&ide_dtc2278);
    eval("sub ide_ali14xx () { 5; }") unless defined(&ide_ali14xx);
    eval("sub ide_qd65xx () { 6; }") unless defined(&ide_qd65xx);
    eval("sub ide_umc8672 () { 7; }") unless defined(&ide_umc8672);
    eval("sub ide_ht6560b () { 8; }") unless defined(&ide_ht6560b);
    eval("sub ide_rz1000 () { 9; }") unless defined(&ide_rz1000);
    eval("sub ide_trm290 () { 10; }") unless defined(&ide_trm290);
    eval("sub ide_cmd646 () { 11; }") unless defined(&ide_cmd646);
    eval("sub ide_cy82c693 () { 12; }") unless defined(&ide_cy82c693);
    eval("sub ide_4drives () { 13; }") unless defined(&ide_4drives);
    eval("sub ide_pmac () { 14; }") unless defined(&ide_pmac);
    eval("sub ide_etrax100 () { 15; }") unless defined(&ide_etrax100);
    eval("sub ide_acorn () { 16; }") unless defined(&ide_acorn);
    eval("sub ide_au1xxx () { 17; }") unless defined(&ide_au1xxx);
    eval("sub ide_forced () { 18; }") unless defined(&ide_forced);
    if(0) {
    }
    eval 'sub ide_std_init_ports {
        my($hw,$io_addr,$ctl_addr) = @_;
	    eval q({ my $i;  &for ( $i =  &IDE_DATA_OFFSET;  $i <=  &IDE_STATUS_OFFSET;  $i++)  ($hw->{io_ports[$i]}) = $io_addr++;  ($hw->{io_ports[&IDE_CONTROL_OFFSET]}) = $ctl_addr; });
    }' unless defined(&ide_std_init_ports);
    require 'asm/ide.ph';
    unless(defined(&MAX_HWIFS)) {
	eval 'sub MAX_HWIFS () { &CONFIG_IDE_MAX_HWIFS;}' unless defined(&MAX_HWIFS);
    }
    unless(defined(&IDE_ARCH_OBSOLETE_DEFAULTS)) {
	eval 'sub ide_default_io_base {
	    my($index) = @_;
    	    eval q((0));
	}' unless defined(&ide_default_io_base);
	eval 'sub ide_default_irq {
	    my($base) = @_;
    	    eval q((0));
	}' unless defined(&ide_default_irq);
	eval 'sub ide_init_default_irq {
	    my($base) = @_;
    	    eval q((0));
	}' unless defined(&ide_init_default_irq);
    }
    if(defined(&IDE_ARCH_OBSOLETE_INIT)) {
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub ide_init_hwif_ports {
	    my($hw,$io_addr,$ctl_addr,$irq) = @_;
    	    eval q({  &if (!$ctl_addr)  &ide_std_init_ports($hw, $io_addr,  &ide_default_io_ctl($io_addr));  &else  &ide_std_init_ports($hw, $io_addr, $ctl_addr);  &if ($irq) *$irq = 0;  ($hw->{io_ports[&IDE_IRQ_OFFSET]}) = 0; });
	}' unless defined(&ide_init_hwif_ports);
    } else {
	eval 'sub ide_init_hwif_ports {
	    my($hw,$io_addr,$ctl_addr,$irq) = @_;
    	    eval q({  &if ($io_addr || $ctl_addr)  &printk( &KERN_WARNING \\"%s: must not be called\\\\n\\",  &__FUNCTION__); });
	}' unless defined(&ide_init_hwif_ports);
    }
    unless(defined(&IDE_ARCH_ACK_INTR)) {
	eval 'sub ide_ack_intr {
	    my($hwif) = @_;
    	    eval q((1));
	}' unless defined(&ide_ack_intr);
    }
    unless(defined(&IDE_ARCH_LOCK)) {
	eval 'sub ide_release_lock () {
	    eval q( &do {}  &while (0));
	}' unless defined(&ide_release_lock);
	eval 'sub ide_get_lock {
	    my($hdlr, $data) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&ide_get_lock);
    }
    eval 'sub ide_scsi () {0x21;}' unless defined(&ide_scsi);
    eval 'sub ide_disk () {0x20;}' unless defined(&ide_disk);
    eval 'sub ide_optical () {0x7;}' unless defined(&ide_optical);
    eval 'sub ide_cdrom () {0x5;}' unless defined(&ide_cdrom);
    eval 'sub ide_tape () {0x1;}' unless defined(&ide_tape);
    eval 'sub ide_floppy () {0x;}' unless defined(&ide_floppy);
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Please fix <asm/byteorder.h>");
    }
    eval("sub ide_stopped () { 0; }") unless defined(&ide_stopped);
    eval("sub ide_started () { 1; }") unless defined(&ide_started);
    eval 'sub to_ide_device {
        my($dev) = @_;
	    eval q( &container_of($dev,  &ide_drive_t,  &gendev));
    }' unless defined(&to_ide_device);
    eval 'sub IDE_CHIPSET_PCI_MASK () {((1<< &ide_pci)|(1<< &ide_cmd646)|(1<< &ide_ali14xx));}' unless defined(&IDE_CHIPSET_PCI_MASK);
    eval 'sub IDE_CHIPSET_IS_PCI {
        my($c) = @_;
	    eval q((( &IDE_CHIPSET_PCI_MASK >> ($c)) & 1));
    }' unless defined(&IDE_CHIPSET_IS_PCI);
    if(0) {
    } else {
    }
    eval 'sub TYPE_INT () {0;}' unless defined(&TYPE_INT);
    eval 'sub TYPE_INTA () {1;}' unless defined(&TYPE_INTA);
    eval 'sub TYPE_BYTE () {2;}' unless defined(&TYPE_BYTE);
    eval 'sub TYPE_SHORT () {3;}' unless defined(&TYPE_SHORT);
    eval 'sub SETTING_READ () {(1<< 0);}' unless defined(&SETTING_READ);
    eval 'sub SETTING_WRITE () {(1<< 1);}' unless defined(&SETTING_WRITE);
    eval 'sub SETTING_RW () {( &SETTING_READ |  &SETTING_WRITE);}' unless defined(&SETTING_RW);
    if(defined(&CONFIG_PROC_FS)) {
	if(defined(&CONFIG_BLK_DEV_IDEPCI)) {
	}
	eval 'sub PROC_IDE_READ_RETURN {
	    my($page,$start,$off,$count,$eof,$len) = @_;
    	    eval q({ $len -= $off;  &if ($len < $count) { *$eof = 1;  &if ($len <= 0)  &return 0; }  &else $len = $count; *$start = $page + $off;  &return $len; });
	}' unless defined(&PROC_IDE_READ_RETURN);
    } else {
	eval 'sub PROC_IDE_READ_RETURN {
	    my($page,$start,$off,$count,$eof,$len) = @_;
    	    eval q( &return 0;);
	}' unless defined(&PROC_IDE_READ_RETURN);
    }
    eval("sub ide_pm_state_completed () { -1; }") unless defined(&ide_pm_state_completed);
    eval("sub ide_pm_state_start_suspend () { 0; }") unless defined(&ide_pm_state_start_suspend);
    eval("sub ide_pm_state_start_resume () { 1000; }") unless defined(&ide_pm_state_start_resume);
    eval 'sub to_ide_driver {
        my($drv) = @_;
	    eval q( &container_of($drv,  &ide_driver_t,  &gen_driver));
    }' unless defined(&to_ide_driver);
    unless(defined(&_IDE_C)) {
    }
    eval("sub ide_wait () { 0; }") unless defined(&ide_wait);
    eval("sub ide_preempt () { 1; }") unless defined(&ide_preempt);
    eval("sub ide_head_wait () { 2; }") unless defined(&ide_head_wait);
    eval("sub ide_end () { 3; }") unless defined(&ide_end);
    eval 'sub ide_pci_register_driver {
        my($d) = @_;
	    eval q( &__ide_pci_register_driver($d,  &THIS_MODULE));
    }' unless defined(&ide_pci_register_driver);
    eval 'sub ON_BOARD () {1;}' unless defined(&ON_BOARD);
    eval 'sub NEVER_BOARD () {0;}' unless defined(&NEVER_BOARD);
    if(defined(&CONFIG_BLK_DEV_OFFBOARD)) {
	eval 'sub OFF_BOARD () { &ON_BOARD;}' unless defined(&OFF_BOARD);
    } else {
	eval 'sub OFF_BOARD () { &NEVER_BOARD;}' unless defined(&OFF_BOARD);
    }
    eval 'sub NODMA () {0;}' unless defined(&NODMA);
    eval 'sub NOAUTODMA () {1;}' unless defined(&NOAUTODMA);
    eval 'sub AUTODMA () {2;}' unless defined(&AUTODMA);
    eval("sub IDEPCI_FLAG_ISA_PORTS () { (1<<0); }") unless defined(&IDEPCI_FLAG_ISA_PORTS);
    eval 'sub BAD_DMA_DRIVE () {0;}' unless defined(&BAD_DMA_DRIVE);
    eval 'sub GOOD_DMA_DRIVE () {1;}' unless defined(&GOOD_DMA_DRIVE);
    if(defined(&CONFIG_BLK_DEV_IDEDMA)) {
	if(defined(&CONFIG_BLK_DEV_IDEDMA_PCI)) {
	}
    } else {
    }
    eval 'sub void {
        eval q(* &ide_get_hwifdata ( &ide_hwif_t *  &hwif) {  ($hwif->{hwif_data}); });
    }' unless defined(&void);
    eval 'sub ide_set_hwifdata {
        my($hwif,$data) = @_;
	    eval q({  ($hwif->{hwif_data}) = $data; });
    }' unless defined(&ide_set_hwifdata);
    eval 'sub local_irq_set {
        my($flags) = @_;
	    eval q( &do {  &local_save_flags(($flags));  &local_irq_enable(); }  &while (0));
    }' unless defined(&local_irq_set);
    eval 'sub ide_id_has_flush_cache {
        my($id) = @_;
	    eval q((($id)-> &cfs_enable_2 & 0x3000));
    }' unless defined(&ide_id_has_flush_cache);
    eval 'sub ide_id_has_flush_cache_ext {
        my($id) = @_;
	    eval q(((($id)-> &cfs_enable_2 & 0x2400) == 0x2400));
    }' unless defined(&ide_id_has_flush_cache_ext);
    eval 'sub hwif_to_node {
        my($hwif) = @_;
	    eval q({ \'struct pci_dev\' * &dev =  ($hwif->{pci_dev});  &dev ?  &pcibus_to_node( ($dev->{bus})) : -1; });
    }' unless defined(&hwif_to_node);
}
1;
