require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_BIO_H)) {
    eval 'sub __LINUX_BIO_H () {1;}' unless defined(&__LINUX_BIO_H);
    require 'linux/highmem.ph';
    require 'linux/mempool.ph';
    require 'linux/ioprio.ph';
    require 'asm/io.ph';
    if(defined( &BIO_VMERGE_MAX_SIZE)  && defined( &BIO_VMERGE_BOUNDARY)) {
	eval 'sub BIOVEC_VIRT_START_SIZE {
	    my($x) = @_;
    	    eval q(( &bvec_to_phys($x) & ( &BIO_VMERGE_BOUNDARY - 1)));
	}' unless defined(&BIOVEC_VIRT_START_SIZE);
	eval 'sub BIOVEC_VIRT_OVERSIZE {
	    my($x) = @_;
    	    eval q((($x) >  &BIO_VMERGE_MAX_SIZE));
	}' unless defined(&BIOVEC_VIRT_OVERSIZE);
    } else {
	eval 'sub BIOVEC_VIRT_START_SIZE {
	    my($x) = @_;
    	    eval q(0);
	}' unless defined(&BIOVEC_VIRT_START_SIZE);
	eval 'sub BIOVEC_VIRT_OVERSIZE {
	    my($x) = @_;
    	    eval q(0);
	}' unless defined(&BIOVEC_VIRT_OVERSIZE);
    }
    unless(defined(&BIO_VMERGE_BOUNDARY)) {
	eval 'sub BIO_VMERGE_BOUNDARY () {0;}' unless defined(&BIO_VMERGE_BOUNDARY);
    }
    eval 'sub BIO_DEBUG () {1;}' unless defined(&BIO_DEBUG);
    if(defined(&BIO_DEBUG)) {
	eval 'sub BIO_BUG_ON () { &BUG_ON;}' unless defined(&BIO_BUG_ON);
    } else {
	eval 'sub BIO_BUG_ON () {1;}' unless defined(&BIO_BUG_ON);
    }
    eval 'sub BIO_MAX_PAGES () {(256);}' unless defined(&BIO_MAX_PAGES);
    eval 'sub BIO_MAX_SIZE () {( &BIO_MAX_PAGES <<  &PAGE_CACHE_SHIFT);}' unless defined(&BIO_MAX_SIZE);
    eval 'sub BIO_MAX_SECTORS () {( &BIO_MAX_SIZE >> 9);}' unless defined(&BIO_MAX_SECTORS);
    eval 'sub BIO_UPTODATE () {0;}' unless defined(&BIO_UPTODATE);
    eval 'sub BIO_RW_BLOCK () {1;}' unless defined(&BIO_RW_BLOCK);
    eval 'sub BIO_EOF () {2;}' unless defined(&BIO_EOF);
    eval 'sub BIO_SEG_VALID () {3;}' unless defined(&BIO_SEG_VALID);
    eval 'sub BIO_CLONED () {4;}' unless defined(&BIO_CLONED);
    eval 'sub BIO_BOUNCED () {5;}' unless defined(&BIO_BOUNCED);
    eval 'sub BIO_USER_MAPPED () {6;}' unless defined(&BIO_USER_MAPPED);
    eval 'sub BIO_EOPNOTSUPP () {7;}' unless defined(&BIO_EOPNOTSUPP);
    eval 'sub bio_flagged {
        my($bio, $flag) = @_;
	    eval q((($bio)-> &bi_flags & (1<< ($flag))));
    }' unless defined(&bio_flagged);
    eval 'sub BIO_POOL_BITS () {(4);}' unless defined(&BIO_POOL_BITS);
    eval 'sub BIO_POOL_OFFSET () {( &BITS_PER_LONG -  &BIO_POOL_BITS);}' unless defined(&BIO_POOL_OFFSET);
    eval 'sub BIO_POOL_MASK () {(1 <<  &BIO_POOL_OFFSET);}' unless defined(&BIO_POOL_MASK);
    eval 'sub BIO_POOL_IDX {
        my($bio) = @_;
	    eval q((($bio)-> &bi_flags >>  &BIO_POOL_OFFSET));
    }' unless defined(&BIO_POOL_IDX);
    eval 'sub BIO_RW () {0;}' unless defined(&BIO_RW);
    eval 'sub BIO_RW_AHEAD () {1;}' unless defined(&BIO_RW_AHEAD);
    eval 'sub BIO_RW_BARRIER () {2;}' unless defined(&BIO_RW_BARRIER);
    eval 'sub BIO_RW_FAILFAST () {3;}' unless defined(&BIO_RW_FAILFAST);
    eval 'sub BIO_RW_SYNC () {4;}' unless defined(&BIO_RW_SYNC);
    eval 'sub BIO_PRIO_SHIFT () {(8* $sizeof{\'unsigned long\'} -  &IOPRIO_BITS);}' unless defined(&BIO_PRIO_SHIFT);
    eval 'sub bio_prio {
        my($bio) = @_;
	    eval q((($bio)-> &bi_rw >>  &BIO_PRIO_SHIFT));
    }' unless defined(&bio_prio);
    eval 'sub bio_prio_valid {
        my($bio) = @_;
	    eval q( &ioprio_valid( &bio_prio($bio)));
    }' unless defined(&bio_prio_valid);
    eval 'sub bio_set_prio {
        my($bio, $prio) = @_;
	    eval q( &do {  &WARN_ON($prio >= (1<<  &IOPRIO_BITS)); ($bio)-> &bi_rw &= ((1 <<  &BIO_PRIO_SHIFT) - 1); ($bio)-> &bi_rw |= ( ($prio) <<  &BIO_PRIO_SHIFT); }  &while (0));
    }' unless defined(&bio_set_prio);
    eval 'sub bio_iovec_idx {
        my($bio, $idx) = @_;
	    eval q(((($bio)-> $bi_io_vec[($idx)])));
    }' unless defined(&bio_iovec_idx);
    eval 'sub bio_iovec {
        my($bio) = @_;
	    eval q( &bio_iovec_idx(($bio), ($bio)-> &bi_idx));
    }' unless defined(&bio_iovec);
    eval 'sub bio_page {
        my($bio) = @_;
	    eval q( &bio_iovec(($bio))-> &bv_page);
    }' unless defined(&bio_page);
    eval 'sub bio_offset {
        my($bio) = @_;
	    eval q( &bio_iovec(($bio))-> &bv_offset);
    }' unless defined(&bio_offset);
    eval 'sub bio_segments {
        my($bio) = @_;
	    eval q((($bio)-> &bi_vcnt - ($bio)-> &bi_idx));
    }' unless defined(&bio_segments);
    eval 'sub bio_sectors {
        my($bio) = @_;
	    eval q((($bio)-> &bi_size >> 9));
    }' unless defined(&bio_sectors);
    eval 'sub bio_cur_sectors {
        my($bio) = @_;
	    eval q(( &bio_iovec($bio)-> &bv_len >> 9));
    }' unless defined(&bio_cur_sectors);
    eval 'sub bio_data {
        my($bio) = @_;
	    eval q(( &page_address( &bio_page(($bio))) +  &bio_offset(($bio))));
    }' unless defined(&bio_data);
    eval 'sub bio_barrier {
        my($bio) = @_;
	    eval q((($bio)-> &bi_rw & (1<<  &BIO_RW_BARRIER)));
    }' unless defined(&bio_barrier);
    eval 'sub bio_sync {
        my($bio) = @_;
	    eval q((($bio)-> &bi_rw & (1<<  &BIO_RW_SYNC)));
    }' unless defined(&bio_sync);
    eval 'sub bio_failfast {
        my($bio) = @_;
	    eval q((($bio)-> &bi_rw & (1<<  &BIO_RW_FAILFAST)));
    }' unless defined(&bio_failfast);
    eval 'sub bio_rw_ahead {
        my($bio) = @_;
	    eval q((($bio)-> &bi_rw & (1<<  &BIO_RW_AHEAD)));
    }' unless defined(&bio_rw_ahead);
    eval 'sub bio_to_phys {
        my($bio) = @_;
	    eval q(( &page_to_phys( &bio_page(($bio))) +   &bio_offset(($bio))));
    }' unless defined(&bio_to_phys);
    eval 'sub bvec_to_phys {
        my($bv) = @_;
	    eval q(( &page_to_phys(($bv)-> &bv_page) +  ($bv)-> &bv_offset));
    }' unless defined(&bvec_to_phys);
    eval 'sub __bio_kmap_atomic {
        my($bio, $idx, $kmtype) = @_;
	    eval q(( &kmap_atomic( &bio_iovec_idx(($bio), ($idx))-> &bv_page, $kmtype) +  &bio_iovec_idx(($bio), ($idx))-> &bv_offset));
    }' unless defined(&__bio_kmap_atomic);
    eval 'sub __bio_kunmap_atomic {
        my($addr, $kmtype) = @_;
	    eval q( &kunmap_atomic($addr, $kmtype));
    }' unless defined(&__bio_kunmap_atomic);
    eval 'sub __BVEC_END {
        my($bio) = @_;
	    eval q( &bio_iovec_idx(($bio), ($bio)-> &bi_vcnt - 1));
    }' unless defined(&__BVEC_END);
    eval 'sub __BVEC_START {
        my($bio) = @_;
	    eval q( &bio_iovec_idx(($bio), ($bio)-> &bi_idx));
    }' unless defined(&__BVEC_START);
    unless(defined(&BIOVEC_PHYS_MERGEABLE)) {
	eval 'sub BIOVEC_PHYS_MERGEABLE {
	    my($vec1, $vec2) = @_;
    	    eval q((( &bvec_to_phys(($vec1)) + ($vec1)-> &bv_len) ==  &bvec_to_phys(($vec2))));
	}' unless defined(&BIOVEC_PHYS_MERGEABLE);
    }
    eval 'sub BIOVEC_VIRT_MERGEABLE {
        my($vec1, $vec2) = @_;
	    eval q((((( &bvec_to_phys(($vec1)) + ($vec1)-> &bv_len) |  &bvec_to_phys(($vec2))) & ( &BIO_VMERGE_BOUNDARY - 1)) == 0));
    }' unless defined(&BIOVEC_VIRT_MERGEABLE);
    eval 'sub __BIO_SEG_BOUNDARY {
        my($addr1, $addr2, $mask) = @_;
	    eval q(((($addr1) | ($mask)) == ((($addr2) - 1) | ($mask))));
    }' unless defined(&__BIO_SEG_BOUNDARY);
    eval 'sub BIOVEC_SEG_BOUNDARY {
        my($q, $b1, $b2) = @_;
	    eval q( &__BIO_SEG_BOUNDARY( &bvec_to_phys(($b1)),  &bvec_to_phys(($b2)) + ($b2)-> &bv_len, ($q)-> &seg_boundary_mask));
    }' unless defined(&BIOVEC_SEG_BOUNDARY);
    eval 'sub BIO_SEG_BOUNDARY {
        my($q, $b1, $b2) = @_;
	    eval q( &BIOVEC_SEG_BOUNDARY(($q),  &__BVEC_END(($b1)),  &__BVEC_START(($b2))));
    }' unless defined(&BIO_SEG_BOUNDARY);
    eval 'sub bio_io_error {
        my($bio, $bytes) = @_;
	    eval q( &bio_endio(($bio), ($bytes), - &EIO));
    }' unless defined(&bio_io_error);
    eval 'sub __bio_for_each_segment {
        my($bvl, $bio, $i, $start_idx) = @_;
	    eval q( &for ($bvl =  &bio_iovec_idx(($bio), ($start_idx)), $i = ($start_idx); $i < ($bio)-> &bi_vcnt; $bvl++, $i++));
    }' unless defined(&__bio_for_each_segment);
    eval 'sub bio_for_each_segment {
        my($bvl, $bio, $i) = @_;
	    eval q( &__bio_for_each_segment($bvl, $bio, $i, ($bio)-> &bi_idx));
    }' unless defined(&bio_for_each_segment);
    eval 'sub bio_get {
        my($bio) = @_;
	    eval q( &atomic_inc(($bio)-> &bi_cnt));
    }' unless defined(&bio_get);
    if(defined(&CONFIG_HIGHMEM)) {
	eval 'sub bvec_kunmap_irq {
	    my($buffer,$flags) = @_;
    	    eval q({ my $ptr =  $buffer &  &PAGE_MASK;  &kunmap_atomic(( &void *)  $ptr,  &KM_BIO_SRC_IRQ);  &local_irq_restore(*$flags); });
	}' unless defined(&bvec_kunmap_irq);
    } else {
	eval 'sub bvec_kmap_irq {
	    my($bvec, $flags) = @_;
    	    eval q(( &page_address(($bvec)-> &bv_page) + ($bvec)-> &bv_offset));
	}' unless defined(&bvec_kmap_irq);
	eval 'sub bvec_kunmap_irq {
	    my($buf, $flags) = @_;
    	    eval q( &do { *($flags) = 0; }  &while (0));
	}' unless defined(&bvec_kunmap_irq);
    }
    eval 'sub char {
        eval q(* &__bio_kmap_irq(\'struct bio\' * &bio, my $idx, \'unsigned long\' * &flags) {  &bvec_kmap_irq( &bio_iovec_idx( &bio,  $idx),  &flags); });
    }' unless defined(&char);
    eval 'sub __bio_kunmap_irq {
        my($buf, $flags) = @_;
	    eval q( &bvec_kunmap_irq($buf, $flags));
    }' unless defined(&__bio_kunmap_irq);
    eval 'sub bio_kmap_irq {
        my($bio, $flags) = @_;
	    eval q( &__bio_kmap_irq(($bio), ($bio)-> &bi_idx, ($flags)));
    }' unless defined(&bio_kmap_irq);
    eval 'sub bio_kunmap_irq {
        my($buf,$flags) = @_;
	    eval q( &__bio_kunmap_irq($buf, $flags));
    }' unless defined(&bio_kunmap_irq);
}
1;
