require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_BUFFER_HEAD_H)) {
    eval 'sub _LINUX_BUFFER_HEAD_H () {1;}' unless defined(&_LINUX_BUFFER_HEAD_H);
    require 'linux/types.ph';
    require 'linux/fs.ph';
    require 'linux/linkage.ph';
    require 'linux/pagemap.ph';
    require 'linux/wait.ph';
    require 'asm/atomic.ph';
    eval("sub BH_Uptodate () { 0; }") unless defined(&BH_Uptodate);
    eval("sub BH_Dirty () { 1; }") unless defined(&BH_Dirty);
    eval("sub BH_Lock () { 2; }") unless defined(&BH_Lock);
    eval("sub BH_Req () { 3; }") unless defined(&BH_Req);
    eval("sub BH_Uptodate_Lock () { 4; }") unless defined(&BH_Uptodate_Lock);
    eval("sub BH_Mapped () { 5; }") unless defined(&BH_Mapped);
    eval("sub BH_New () { 6; }") unless defined(&BH_New);
    eval("sub BH_Async_Read () { 7; }") unless defined(&BH_Async_Read);
    eval("sub BH_Async_Write () { 8; }") unless defined(&BH_Async_Write);
    eval("sub BH_Delay () { 9; }") unless defined(&BH_Delay);
    eval("sub BH_Boundary () { 10; }") unless defined(&BH_Boundary);
    eval("sub BH_Write_EIO () { 11; }") unless defined(&BH_Write_EIO);
    eval("sub BH_Ordered () { 12; }") unless defined(&BH_Ordered);
    eval("sub BH_Eopnotsupp () { 13; }") unless defined(&BH_Eopnotsupp);
    eval("sub BH_PrivateStart () { 14; }") unless defined(&BH_PrivateStart);
    eval 'sub MAX_BUF_PER_PAGE () {( &PAGE_CACHE_SIZE / 512);}' unless defined(&MAX_BUF_PER_PAGE);
    if(defined(&__KERNEL__)) {
	eval 'sub BUFFER_FNS {
	    my($bit, $name) = @_;
    	    eval q( &static  &__inline__  &void  &set_buffer_$name(\'struct buffer_head\' * &bh) {  &set_bit( &BH_$bit, ( &bh)-> &b_state); }  &static  &__inline__  &void  &clear_buffer_$name(\'struct buffer_head\' * &bh) {  &clear_bit( &BH_$bit, ( &bh)-> &b_state); }  &static  &__inline__ \'int\'  &buffer_$name( &const \'struct buffer_head\' * &bh) {  &return  &test_bit( &BH_$bit, ( &bh)-> &b_state); });
	}' unless defined(&BUFFER_FNS);
	eval 'sub TAS_BUFFER_FNS {
	    my($bit, $name) = @_;
    	    eval q( &static  &__inline__ \'int\'  &test_set_buffer_$name(\'struct buffer_head\' * &bh) {  &return  &test_and_set_bit( &BH_$bit, ( &bh)-> &b_state); }  &static  &__inline__ \'int\'  &test_clear_buffer_$name(\'struct buffer_head\' * &bh) {  &return  &test_and_clear_bit( &BH_$bit, ( &bh)-> &b_state); });
	}' unless defined(&TAS_BUFFER_FNS);
	eval 'sub bh_offset {
	    my($bh) = @_;
    	    eval q((($bh)-> &b_data & ~ &PAGE_MASK));
	}' unless defined(&bh_offset);
	eval 'sub touch_buffer {
	    my($bh) = @_;
    	    eval q( &mark_page_accessed( ($bh->{b_page})));
	}' unless defined(&touch_buffer);
	eval 'sub page_buffers {
	    my($page) = @_;
    	    eval q(({  &BUG_ON(! &PagePrivate($page)); ( &page_private($page)); }));
	}' unless defined(&page_buffers);
	eval 'sub page_has_buffers {
	    my($page) = @_;
    	    eval q( &PagePrivate($page));
	}' unless defined(&page_has_buffers);
	eval 'sub get_bh {
	    my($bh) = @_;
    	    eval q({  &atomic_inc( ($bh->{b_count})); });
	}' unless defined(&get_bh);
	eval 'sub put_bh {
	    my($bh) = @_;
    	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($bh->{b_count})); });
	}' unless defined(&put_bh);
	eval 'sub brelse {
	    my($bh) = @_;
    	    eval q({  &if ($bh)  &__brelse($bh); });
	}' unless defined(&brelse);
	eval 'sub bforget {
	    my($bh) = @_;
    	    eval q({  &if ($bh)  &__bforget($bh); });
	}' unless defined(&bforget);
	eval 'sub sb_bread {
	    my($sb,$block) = @_;
    	    eval q({  &__bread( ($sb->{s_bdev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_bread);
	eval 'sub sb_breadahead {
	    my($sb,$block) = @_;
    	    eval q({  &__breadahead( ($sb->{s_bdev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_breadahead);
	eval 'sub sb_getblk {
	    my($sb,$block) = @_;
    	    eval q({  &__getblk( ($sb->{s_bdev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_getblk);
	eval 'sub sb_find_get_block {
	    my($sb,$block) = @_;
    	    eval q({  &__find_get_block( ($sb->{s_bdev}), $block,  ($sb->{s_blocksize})); });
	}' unless defined(&sb_find_get_block);
	eval 'sub map_bh {
	    my($bh,$sb,$block) = @_;
    	    eval q({  &set_buffer_mapped($bh);  ($bh->{b_bdev}) =  ($sb->{s_bdev});  ($bh->{b_blocknr}) = $block;  ($bh->{b_size}) =  ($sb->{s_blocksize}); });
	}' unless defined(&map_bh);
    }
    eval 'sub lock_buffer {
        my($bh) = @_;
	    eval q({  &might_sleep();  &if ( &test_set_buffer_locked($bh))  &__lock_buffer($bh); });
    }' unless defined(&lock_buffer);
}
1;
