require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_DCACHE_H)) {
    eval 'sub __LINUX_DCACHE_H () {1;}' unless defined(&__LINUX_DCACHE_H);
    if(defined(&__KERNEL__)) {
	require 'asm/atomic.ph';
	require 'linux/list.ph';
	require 'linux/spinlock.ph';
	require 'linux/cache.ph';
	require 'linux/rcupdate.ph';
	eval 'sub IS_ROOT {
	    my($x) = @_;
    	    eval q((($x) == ($x)-> &d_parent));
	}' unless defined(&IS_ROOT);
	eval 'sub init_name_hash () {
	    eval q(0);
	}' unless defined(&init_name_hash);
	eval 'sub DNAME_INLINE_LEN_MIN () {36;}' unless defined(&DNAME_INLINE_LEN_MIN);
	if(defined(&CONFIG_PROFILING)) {
	}
	eval 'sub DCACHE_AUTOFS_PENDING () {0x1;}' unless defined(&DCACHE_AUTOFS_PENDING);
	eval 'sub DCACHE_NFSFS_RENAMED () {0x2;}' unless defined(&DCACHE_NFSFS_RENAMED);
	eval 'sub DCACHE_DISCONNECTED () {0x4;}' unless defined(&DCACHE_DISCONNECTED);
	eval 'sub DCACHE_REFERENCED () {0x8;}' unless defined(&DCACHE_REFERENCED);
	eval 'sub DCACHE_UNHASHED () {0x10;}' unless defined(&DCACHE_UNHASHED);
	eval 'sub DCACHE_INOTIFY_PARENT_WATCHED () {0x20;}' unless defined(&DCACHE_INOTIFY_PARENT_WATCHED);
	eval 'sub d_drop {
	    my($dentry) = @_;
    	    eval q({  &spin_lock( &dcache_lock);  &spin_lock( ($dentry->{d_lock}));  &__d_drop($dentry);  &spin_unlock( ($dentry->{d_lock}));  &spin_unlock( &dcache_lock); });
	}' unless defined(&d_drop);
	eval 'sub dname_external {
	    my($dentry) = @_;
    	    eval q({  ($dentry->{d_name}->{name}) !=  ($dentry->{d_iname}); });
	}' unless defined(&dname_external);
	eval 'sub dentry {
	    eval q(* &dget_parent(\'struct dentry\' * &dentry) { \'struct dentry\' * &ret;  &spin_lock( ($dentry->{d_lock}));  &ret =  &dget( ($dentry->{d_parent}));  &spin_unlock( ($dentry->{d_lock}));  &ret; });
	}' unless defined(&dentry);
	eval 'sub d_mountpoint {
	    my($dentry) = @_;
    	    eval q({  ($dentry->{d_mounted}); });
	}' unless defined(&d_mountpoint);
    }
}
1;
