require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_IOPORT_H)) {
    eval 'sub _LINUX_IOPORT_H () {1;}' unless defined(&_LINUX_IOPORT_H);
    require 'linux/compiler.ph';
    eval 'sub IORESOURCE_BITS () {0xff;}' unless defined(&IORESOURCE_BITS);
    eval 'sub IORESOURCE_IO () {0x100;}' unless defined(&IORESOURCE_IO);
    eval 'sub IORESOURCE_MEM () {0x200;}' unless defined(&IORESOURCE_MEM);
    eval 'sub IORESOURCE_IRQ () {0x400;}' unless defined(&IORESOURCE_IRQ);
    eval 'sub IORESOURCE_DMA () {0x800;}' unless defined(&IORESOURCE_DMA);
    eval 'sub IORESOURCE_PREFETCH () {0x1000;}' unless defined(&IORESOURCE_PREFETCH);
    eval 'sub IORESOURCE_READONLY () {0x2000;}' unless defined(&IORESOURCE_READONLY);
    eval 'sub IORESOURCE_CACHEABLE () {0x4000;}' unless defined(&IORESOURCE_CACHEABLE);
    eval 'sub IORESOURCE_RANGELENGTH () {0x8000;}' unless defined(&IORESOURCE_RANGELENGTH);
    eval 'sub IORESOURCE_SHADOWABLE () {0x10000;}' unless defined(&IORESOURCE_SHADOWABLE);
    eval 'sub IORESOURCE_BUS_HAS_VGA () {0x80000;}' unless defined(&IORESOURCE_BUS_HAS_VGA);
    eval 'sub IORESOURCE_DISABLED () {0x10000000;}' unless defined(&IORESOURCE_DISABLED);
    eval 'sub IORESOURCE_UNSET () {0x20000000;}' unless defined(&IORESOURCE_UNSET);
    eval 'sub IORESOURCE_AUTO () {0x40000000;}' unless defined(&IORESOURCE_AUTO);
    eval 'sub IORESOURCE_BUSY () {0x80000000;}' unless defined(&IORESOURCE_BUSY);
    eval 'sub IORESOURCE_IRQ_HIGHEDGE () {(1<<0);}' unless defined(&IORESOURCE_IRQ_HIGHEDGE);
    eval 'sub IORESOURCE_IRQ_LOWEDGE () {(1<<1);}' unless defined(&IORESOURCE_IRQ_LOWEDGE);
    eval 'sub IORESOURCE_IRQ_HIGHLEVEL () {(1<<2);}' unless defined(&IORESOURCE_IRQ_HIGHLEVEL);
    eval 'sub IORESOURCE_IRQ_LOWLEVEL () {(1<<3);}' unless defined(&IORESOURCE_IRQ_LOWLEVEL);
    eval 'sub IORESOURCE_DMA_TYPE_MASK () {(3<<0);}' unless defined(&IORESOURCE_DMA_TYPE_MASK);
    eval 'sub IORESOURCE_DMA_8BIT () {(0<<0);}' unless defined(&IORESOURCE_DMA_8BIT);
    eval 'sub IORESOURCE_DMA_8AND16BIT () {(1<<0);}' unless defined(&IORESOURCE_DMA_8AND16BIT);
    eval 'sub IORESOURCE_DMA_16BIT () {(2<<0);}' unless defined(&IORESOURCE_DMA_16BIT);
    eval 'sub IORESOURCE_DMA_MASTER () {(1<<2);}' unless defined(&IORESOURCE_DMA_MASTER);
    eval 'sub IORESOURCE_DMA_BYTE () {(1<<3);}' unless defined(&IORESOURCE_DMA_BYTE);
    eval 'sub IORESOURCE_DMA_WORD () {(1<<4);}' unless defined(&IORESOURCE_DMA_WORD);
    eval 'sub IORESOURCE_DMA_SPEED_MASK () {(3<<6);}' unless defined(&IORESOURCE_DMA_SPEED_MASK);
    eval 'sub IORESOURCE_DMA_COMPATIBLE () {(0<<6);}' unless defined(&IORESOURCE_DMA_COMPATIBLE);
    eval 'sub IORESOURCE_DMA_TYPEA () {(1<<6);}' unless defined(&IORESOURCE_DMA_TYPEA);
    eval 'sub IORESOURCE_DMA_TYPEB () {(2<<6);}' unless defined(&IORESOURCE_DMA_TYPEB);
    eval 'sub IORESOURCE_DMA_TYPEF () {(3<<6);}' unless defined(&IORESOURCE_DMA_TYPEF);
    eval 'sub IORESOURCE_MEM_WRITEABLE () {(1<<0);}' unless defined(&IORESOURCE_MEM_WRITEABLE);
    eval 'sub IORESOURCE_MEM_CACHEABLE () {(1<<1);}' unless defined(&IORESOURCE_MEM_CACHEABLE);
    eval 'sub IORESOURCE_MEM_RANGELENGTH () {(1<<2);}' unless defined(&IORESOURCE_MEM_RANGELENGTH);
    eval 'sub IORESOURCE_MEM_TYPE_MASK () {(3<<3);}' unless defined(&IORESOURCE_MEM_TYPE_MASK);
    eval 'sub IORESOURCE_MEM_8BIT () {(0<<3);}' unless defined(&IORESOURCE_MEM_8BIT);
    eval 'sub IORESOURCE_MEM_16BIT () {(1<<3);}' unless defined(&IORESOURCE_MEM_16BIT);
    eval 'sub IORESOURCE_MEM_8AND16BIT () {(2<<3);}' unless defined(&IORESOURCE_MEM_8AND16BIT);
    eval 'sub IORESOURCE_MEM_32BIT () {(3<<3);}' unless defined(&IORESOURCE_MEM_32BIT);
    eval 'sub IORESOURCE_MEM_SHADOWABLE () {(1<<5);}' unless defined(&IORESOURCE_MEM_SHADOWABLE);
    eval 'sub IORESOURCE_MEM_EXPANSIONROM () {(1<<6);}' unless defined(&IORESOURCE_MEM_EXPANSIONROM);
    eval 'sub IORESOURCE_ROM_ENABLE () {(1<<0);}' unless defined(&IORESOURCE_ROM_ENABLE);
    eval 'sub IORESOURCE_ROM_SHADOW () {(1<<1);}' unless defined(&IORESOURCE_ROM_SHADOW);
    eval 'sub IORESOURCE_ROM_COPY () {(1<<2);}' unless defined(&IORESOURCE_ROM_COPY);
    eval 'sub request_region {
        my($start,$n,$name) = @_;
	    eval q( &__request_region( &ioport_resource, ($start), ($n), ($name)));
    }' unless defined(&request_region);
    eval 'sub request_mem_region {
        my($start,$n,$name) = @_;
	    eval q( &__request_region( &iomem_resource, ($start), ($n), ($name)));
    }' unless defined(&request_mem_region);
    eval 'sub rename_region {
        my($region, $newname) = @_;
	    eval q( &do { ($region)-> &name = ($newname); }  &while (0));
    }' unless defined(&rename_region);
    eval 'sub release_region {
        my($start,$n) = @_;
	    eval q( &__release_region( &ioport_resource, ($start), ($n)));
    }' unless defined(&release_region);
    eval 'sub check_mem_region {
        my($start,$n) = @_;
	    eval q( &__check_region( &iomem_resource, ($start), ($n)));
    }' unless defined(&check_mem_region);
    eval 'sub release_mem_region {
        my($start,$n) = @_;
	    eval q( &__release_region( &iomem_resource, ($start), ($n)));
    }' unless defined(&release_mem_region);
    eval 'sub check_region {
        my($s,$n) = @_;
	    eval q({  &__check_region( &ioport_resource, $s, $n); });
    }' unless defined(&check_region);
}
1;
