require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__MTD_CFI_H__)) {
    eval 'sub __MTD_CFI_H__ () {1;}' unless defined(&__MTD_CFI_H__);
    require 'linux/config.ph';
    require 'linux/delay.ph';
    require 'linux/types.ph';
    require 'linux/interrupt.ph';
    require 'linux/mtd/flashchip.ph';
    require 'linux/mtd/map.ph';
    require 'linux/mtd/cfi_endian.ph';
    if(defined(&CONFIG_MTD_CFI_I1)) {
	eval 'sub cfi_interleave {
	    my($cfi) = @_;
    	    eval q(1);
	}' unless defined(&cfi_interleave);
	eval 'sub cfi_interleave_is_1 {
	    my($cfi) = @_;
    	    eval q(( &cfi_interleave($cfi) == 1));
	}' unless defined(&cfi_interleave_is_1);
    } else {
	eval 'sub cfi_interleave_is_1 {
	    my($cfi) = @_;
    	    eval q((0));
	}' unless defined(&cfi_interleave_is_1);
    }
    if(defined(&CONFIG_MTD_CFI_I2)) {
	if(defined(&cfi_interleave)) {
	    undef(&cfi_interleave) if defined(&cfi_interleave);
	    eval 'sub cfi_interleave {
	        my($cfi) = @_;
    		eval q((($cfi)-> &interleave));
	    }' unless defined(&cfi_interleave);
	} else {
	    eval 'sub cfi_interleave {
	        my($cfi) = @_;
    		eval q(2);
	    }' unless defined(&cfi_interleave);
	}
	eval 'sub cfi_interleave_is_2 {
	    my($cfi) = @_;
    	    eval q(( &cfi_interleave($cfi) == 2));
	}' unless defined(&cfi_interleave_is_2);
    } else {
	eval 'sub cfi_interleave_is_2 {
	    my($cfi) = @_;
    	    eval q((0));
	}' unless defined(&cfi_interleave_is_2);
    }
    if(defined(&CONFIG_MTD_CFI_I4)) {
	if(defined(&cfi_interleave)) {
	    undef(&cfi_interleave) if defined(&cfi_interleave);
	    eval 'sub cfi_interleave {
	        my($cfi) = @_;
    		eval q((($cfi)-> &interleave));
	    }' unless defined(&cfi_interleave);
	} else {
	    eval 'sub cfi_interleave {
	        my($cfi) = @_;
    		eval q(4);
	    }' unless defined(&cfi_interleave);
	}
	eval 'sub cfi_interleave_is_4 {
	    my($cfi) = @_;
    	    eval q(( &cfi_interleave($cfi) == 4));
	}' unless defined(&cfi_interleave_is_4);
    } else {
	eval 'sub cfi_interleave_is_4 {
	    my($cfi) = @_;
    	    eval q((0));
	}' unless defined(&cfi_interleave_is_4);
    }
    if(defined(&CONFIG_MTD_CFI_I8)) {
	if(defined(&cfi_interleave)) {
	    undef(&cfi_interleave) if defined(&cfi_interleave);
	    eval 'sub cfi_interleave {
	        my($cfi) = @_;
    		eval q((($cfi)-> &interleave));
	    }' unless defined(&cfi_interleave);
	} else {
	    eval 'sub cfi_interleave {
	        my($cfi) = @_;
    		eval q(8);
	    }' unless defined(&cfi_interleave);
	}
	eval 'sub cfi_interleave_is_8 {
	    my($cfi) = @_;
    	    eval q(( &cfi_interleave($cfi) == 8));
	}' unless defined(&cfi_interleave_is_8);
    } else {
	eval 'sub cfi_interleave_is_8 {
	    my($cfi) = @_;
    	    eval q((0));
	}' unless defined(&cfi_interleave_is_8);
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub cfi_interleave_supported {
        my($i) = @_;
	    eval q({  &switch ($i) { 1;  &default: 0; } });
    }' unless defined(&cfi_interleave_supported);
    eval 'sub CFI_DEVICETYPE_X8 () {(8/ 8);}' unless defined(&CFI_DEVICETYPE_X8);
    eval 'sub CFI_DEVICETYPE_X16 () {(16/ 8);}' unless defined(&CFI_DEVICETYPE_X16);
    eval 'sub CFI_DEVICETYPE_X32 () {(32/ 8);}' unless defined(&CFI_DEVICETYPE_X32);
    eval 'sub CFI_DEVICETYPE_X64 () {(64/ 8);}' unless defined(&CFI_DEVICETYPE_X64);
    eval 'sub P_ID_NONE () {0x;}' unless defined(&P_ID_NONE);
    eval 'sub P_ID_INTEL_EXT () {0x1;}' unless defined(&P_ID_INTEL_EXT);
    eval 'sub P_ID_AMD_STD () {0x2;}' unless defined(&P_ID_AMD_STD);
    eval 'sub P_ID_INTEL_STD () {0x3;}' unless defined(&P_ID_INTEL_STD);
    eval 'sub P_ID_AMD_EXT () {0x4;}' unless defined(&P_ID_AMD_EXT);
    eval 'sub P_ID_WINBOND () {0x6;}' unless defined(&P_ID_WINBOND);
    eval 'sub P_ID_ST_ADV () {0x20;}' unless defined(&P_ID_ST_ADV);
    eval 'sub P_ID_MITSUBISHI_STD () {0x100;}' unless defined(&P_ID_MITSUBISHI_STD);
    eval 'sub P_ID_MITSUBISHI_EXT () {0x101;}' unless defined(&P_ID_MITSUBISHI_EXT);
    eval 'sub P_ID_SST_PAGE () {0x102;}' unless defined(&P_ID_SST_PAGE);
    eval 'sub P_ID_INTEL_PERFORMANCE () {0x200;}' unless defined(&P_ID_INTEL_PERFORMANCE);
    eval 'sub P_ID_INTEL_DATA () {0x210;}' unless defined(&P_ID_INTEL_DATA);
    eval 'sub P_ID_RESERVED () {0xffff;}' unless defined(&P_ID_RESERVED);
    eval 'sub CFI_MODE_CFI () {1;}' unless defined(&CFI_MODE_CFI);
    eval 'sub CFI_MODE_JEDEC () {0;}' unless defined(&CFI_MODE_JEDEC);
    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) >= 64) {
    }
    eval 'sub CMD {
        my($x) = @_;
	    eval q( &cfi_build_cmd(($x),  &map,  &cfi));
    }' unless defined(&CMD);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub cfi_merge_status {
        my($val,$map,$cfi) = @_;
	    eval q({ \'int\'  &wordwidth,  &words_per_bus,  &chip_mode,  &chips_per_word; my $onestat,  &res = 0; \'int\'  &i;  &if ( &map_bankwidth_is_large($map)) {  &wordwidth = $sizeof{my $long};  &words_per_bus = ( &map_bankwidth($map)) /  &wordwidth; }  &else {  &wordwidth =  &map_bankwidth($map);  &words_per_bus = 1; }  &chip_mode =  &map_bankwidth($map) /  &cfi_interleave($cfi);  &chips_per_word =  &wordwidth *  &cfi_interleave($cfi) /  &map_bankwidth($map);  $onestat =  ($val->{x[0]});  &for ( &i=1;  &i <  &words_per_bus;  &i++) {  $onestat |=  ($val->{x[&i]}); }  &res =  $onestat;  &switch( &chips_per_word) {  &default:  &BUG();  &case 4:  &res |= ( $onestat >> ( &chip_mode * 16));  &case 2:  &res |= ( $onestat >> ( &chip_mode * 8));  &case 1: ; }  &switch ( &chip_mode) {  &case 1:  &break;  &case 2:  &res =  &cfi16_to_cpu( &res);  &break;  &case 4:  &res =  &cfi32_to_cpu( &res);  &break;  &default:  &BUG(); }  &res; });
    }' unless defined(&cfi_merge_status);
    eval 'sub MERGESTATUS {
        my($x) = @_;
	    eval q( &cfi_merge_status(($x),  &map,  &cfi));
    }' unless defined(&MERGESTATUS);
    eval 'sub cfi_read_query {
        my($map,$addr) = @_;
	    eval q({  &map_word  &val =  &map_read($map, $addr);  &if ( &map_bankwidth_is_1($map)) {  ($val->{x[0]}); }  &else  &if ( &map_bankwidth_is_2($map)) {  &cfi16_to_cpu( ($val->{x[0]})); }  &else {  &cfi32_to_cpu( ($val->{x[0]})); } });
    }' unless defined(&cfi_read_query);
    eval 'sub cfi_read_query16 {
        my($map,$addr) = @_;
	    eval q({  &map_word  &val =  &map_read($map, $addr);  &if ( &map_bankwidth_is_1($map)) {  ($val->{x[0]}) & 0xff; }  &else  &if ( &map_bankwidth_is_2($map)) {  &cfi16_to_cpu( ($val->{x[0]})); }  &else {  &cfi32_to_cpu( ($val->{x[0]})); } });
    }' unless defined(&cfi_read_query16);
    eval 'sub cfi_udelay {
        my($us) = @_;
	    eval q({  &if ($us >= 1000) {  &msleep(($us+999)/1000); }  &else {  &udelay($us);  &cond_resched(); } });
    }' unless defined(&cfi_udelay);
    eval 'sub CFI_MFR_ANY () {0xffff;}' unless defined(&CFI_MFR_ANY);
    eval 'sub CFI_ID_ANY () {0xffff;}' unless defined(&CFI_ID_ANY);
    eval 'sub CFI_MFR_AMD () {0x1;}' unless defined(&CFI_MFR_AMD);
    eval 'sub CFI_MFR_ST () {0x20;}' unless defined(&CFI_MFR_ST);
}
1;
