require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_MTD_ONENAND_H)) {
    eval 'sub __LINUX_MTD_ONENAND_H () {1;}' unless defined(&__LINUX_MTD_ONENAND_H);
    require 'linux/spinlock.ph';
    require 'linux/mtd/onenand_regs.ph';
    require 'linux/mtd/bbm.ph';
    eval 'sub MAX_BUFFERRAM () {2;}' unless defined(&MAX_BUFFERRAM);
    eval("sub FL_READY () { 0; }") unless defined(&FL_READY);
    eval("sub FL_READING () { 1; }") unless defined(&FL_READING);
    eval("sub FL_WRITING () { 2; }") unless defined(&FL_WRITING);
    eval("sub FL_ERASING () { 3; }") unless defined(&FL_ERASING);
    eval("sub FL_SYNCING () { 4; }") unless defined(&FL_SYNCING);
    eval("sub FL_UNLOCKING () { 5; }") unless defined(&FL_UNLOCKING);
    eval("sub FL_LOCKING () { 6; }") unless defined(&FL_LOCKING);
    eval("sub FL_PM_SUSPENDED () { 7; }") unless defined(&FL_PM_SUSPENDED);
    eval 'sub ONENAND_CURRENT_BUFFERRAM {
        my($this) = @_;
	    eval q(( ($this->{bufferram_index})));
    }' unless defined(&ONENAND_CURRENT_BUFFERRAM);
    eval 'sub ONENAND_NEXT_BUFFERRAM {
        my($this) = @_;
	    eval q(( ($this->{bufferram_index}) ^ 1));
    }' unless defined(&ONENAND_NEXT_BUFFERRAM);
    eval 'sub ONENAND_SET_NEXT_BUFFERRAM {
        my($this) = @_;
	    eval q(( ($this->{bufferram_index}) ^= 1));
    }' unless defined(&ONENAND_SET_NEXT_BUFFERRAM);
    eval 'sub ONENAND_GET_SYS_CFG1 {
        my($this) = @_;
	    eval q(( ($this->{read_word})( ($this->{base}) +  &ONENAND_REG_SYS_CFG1)));
    }' unless defined(&ONENAND_GET_SYS_CFG1);
    eval 'sub ONENAND_SET_SYS_CFG1 {
        my($v, $this) = @_;
	    eval q(( ($this->{write_word})($v,  ($this->{base}) +  &ONENAND_REG_SYS_CFG1)));
    }' unless defined(&ONENAND_SET_SYS_CFG1);
    eval 'sub ONENAND_CONT_LOCK () {(0x1);}' unless defined(&ONENAND_CONT_LOCK);
    eval 'sub ONENAND_PAGEBUF_ALLOC () {(0x1000);}' unless defined(&ONENAND_PAGEBUF_ALLOC);
    eval 'sub ONENAND_MFR_SAMSUNG () {0xec;}' unless defined(&ONENAND_MFR_SAMSUNG);
}
1;
