require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NFSD_FH_H)) {
    eval 'sub _LINUX_NFSD_FH_H () {1;}' unless defined(&_LINUX_NFSD_FH_H);
    require 'asm/types.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/types.ph';
	require 'linux/string.ph';
	require 'linux/fs.ph';
    }
    require 'linux/nfsd/const.ph';
    require 'linux/nfsd/debug.ph';
    eval 'sub ofh_dcookie () { ($fh_base->{fh_old}->{fb_dcookie});}' unless defined(&ofh_dcookie);
    eval 'sub ofh_ino () { ($fh_base->{fh_old}->{fb_ino});}' unless defined(&ofh_ino);
    eval 'sub ofh_dirino () { ($fh_base->{fh_old}->{fb_dirino});}' unless defined(&ofh_dirino);
    eval 'sub ofh_dev () { ($fh_base->{fh_old}->{fb_dev});}' unless defined(&ofh_dev);
    eval 'sub ofh_xdev () { ($fh_base->{fh_old}->{fb_xdev});}' unless defined(&ofh_xdev);
    eval 'sub ofh_xino () { ($fh_base->{fh_old}->{fb_xino});}' unless defined(&ofh_xino);
    eval 'sub ofh_generation () { ($fh_base->{fh_old}->{fb_generation});}' unless defined(&ofh_generation);
    eval 'sub fh_version () { ($fh_base->{fh_new}->{fb_version});}' unless defined(&fh_version);
    eval 'sub fh_fsid_type () { ($fh_base->{fh_new}->{fb_fsid_type});}' unless defined(&fh_fsid_type);
    eval 'sub fh_auth_type () { ($fh_base->{fh_new}->{fb_auth_type});}' unless defined(&fh_auth_type);
    eval 'sub fh_fileid_type () { ($fh_base->{fh_new}->{fb_fileid_type});}' unless defined(&fh_fileid_type);
    eval 'sub fh_auth () { ($fh_base->{fh_new}->{fb_auth});}' unless defined(&fh_auth);
    eval 'sub fh_fsid () { ($fh_base->{fh_new}->{fb_auth});}' unless defined(&fh_fsid);
    if(defined(&__KERNEL__)) {
	eval 'sub ino_t_to_u32 {
	    my($ino) = @_;
    	    eval q({ ( &__u32) $ino; });
	}' unless defined(&ino_t_to_u32);
	eval 'sub u32_to_ino_t {
	    my($uino) = @_;
    	    eval q({ ( &ino_t) $uino; });
	}' unless defined(&u32_to_ino_t);
	if(defined(&CONFIG_NFSD_V3)) {
	}
	eval 'sub mk_fsid_v0 {
	    my($fsidv,$dev,$ino) = @_;
    	    eval q({ $fsidv->[0] =  &htonl(( &MAJOR($dev)<<16) |  &MINOR($dev)); $fsidv->[1] =  &ino_t_to_u32($ino); });
	}' unless defined(&mk_fsid_v0);
	eval 'sub mk_fsid_v1 {
	    my($fsidv,$fsid) = @_;
    	    eval q({ $fsidv->[0] = $fsid; });
	}' unless defined(&mk_fsid_v1);
	eval 'sub mk_fsid_v2 {
	    my($fsidv,$dev,$ino) = @_;
    	    eval q({ $fsidv->[0] =  &htonl( &MAJOR($dev)); $fsidv->[1] =  &htonl( &MINOR($dev)); $fsidv->[2] =  &ino_t_to_u32($ino); });
	}' unless defined(&mk_fsid_v2);
	eval 'sub mk_fsid_v3 {
	    my($fsidv,$dev,$ino) = @_;
    	    eval q({ $fsidv->[0] =  &new_encode_dev($dev); $fsidv->[1] =  &ino_t_to_u32($ino); });
	}' unless defined(&mk_fsid_v3);
	eval 'sub key_len {
	    my($type) = @_;
    	    eval q({  &switch($type) {  &case 0: 8;  &case 1: 4;  &case 2: 12;  &case 3: 8;  &default: 0; } });
	}' unless defined(&key_len);
	eval 'sub fh_copy {
	    my($dst,$src) = @_;
    	    eval q({  &if ( ($src->{fh_dentry}) ||  ($src->{fh_locked})) { \'struct dentry\' * &dentry =  ($src->{fh_dentry});  &printk( &KERN_ERR \\"fh_copy: copying %s/%s, already verified!\\\\n\\",  ($dentry->{d_parent}->{d_name}->{name}),  ($dentry->{d_name}->{name})); } *$dst = *$src; $dst; });
	}' unless defined(&fh_copy);
	eval 'sub fh_init {
	    my($fhp,$maxsize) = @_;
    	    eval q({  &memset($fhp, 0, $sizeof{$fhp});  ($fhp->{fh_maxsize}) = $maxsize; $fhp; });
	}' unless defined(&fh_init);
	if(defined(&CONFIG_NFSD_V3)) {
	} else {
	    eval 'sub fill_pre_wcc {
	        my($ignored) = @_;
    		eval q();
	    }' unless defined(&fill_pre_wcc);
	    eval 'sub fill_post_wcc {
	        my($notused) = @_;
    		eval q();
	    }' unless defined(&fill_post_wcc);
	}
    }
}
1;
