require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LINUX_RIO_H)) {
    eval 'sub LINUX_RIO_H () {1;}' unless defined(&LINUX_RIO_H);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/config.ph';
	require 'linux/ioport.ph';
	require 'linux/list.ph';
	require 'linux/errno.ph';
	require 'linux/device.ph';
	require 'linux/rio_regs.ph';
	eval 'sub RIO_ANY_DESTID () {0xff;}' unless defined(&RIO_ANY_DESTID);
	eval 'sub RIO_NO_HOPCOUNT () {-1;}' unless defined(&RIO_NO_HOPCOUNT);
	eval 'sub RIO_MAX_MPORT_RESOURCES () {16;}' unless defined(&RIO_MAX_MPORT_RESOURCES);
	eval 'sub RIO_MAX_DEV_RESOURCES () {16;}' unless defined(&RIO_MAX_DEV_RESOURCES);
	eval 'sub RIO_GLOBAL_TABLE () {0xff;}' unless defined(&RIO_GLOBAL_TABLE);
	eval 'sub RIO_INVALID_ROUTE () {0xff;}' unless defined(&RIO_INVALID_ROUTE);
	if(defined(&CONFIG_RAPIDIO_8_BIT_TRANSPORT)) {
	    eval 'sub RIO_MAX_ROUTE_ENTRIES () {(1<< 8);}' unless defined(&RIO_MAX_ROUTE_ENTRIES);
	} else {
	    eval 'sub RIO_MAX_ROUTE_ENTRIES () {(1<< 16);}' unless defined(&RIO_MAX_ROUTE_ENTRIES);
	}
	eval 'sub RIO_MAX_MBOX () {4;}' unless defined(&RIO_MAX_MBOX);
	eval 'sub RIO_MAX_MSG_SIZE () {0x1000;}' unless defined(&RIO_MAX_MSG_SIZE);
	eval 'sub RIO_SUCCESSFUL () {0x;}' unless defined(&RIO_SUCCESSFUL);
	eval 'sub RIO_BAD_SIZE () {0x81;}' unless defined(&RIO_BAD_SIZE);
	eval 'sub RIO_DOORBELL_RESOURCE () {0;}' unless defined(&RIO_DOORBELL_RESOURCE);
	eval 'sub RIO_INB_MBOX_RESOURCE () {1;}' unless defined(&RIO_INB_MBOX_RESOURCE);
	eval 'sub RIO_OUTB_MBOX_RESOURCE () {2;}' unless defined(&RIO_OUTB_MBOX_RESOURCE);
	eval 'sub rio_dev_g {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct rio_dev\',  &global_list));
	}' unless defined(&rio_dev_g);
	eval 'sub rio_dev_f {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct rio_dev\',  &net_list));
	}' unless defined(&rio_dev_f);
	eval 'sub to_rio_dev {
	    my($n) = @_;
    	    eval q( &container_of($n, \'struct rio_dev\',  &dev));
	}' unless defined(&to_rio_dev);
	eval 'sub RIO_RESOURCE_MEM () {0x100;}' unless defined(&RIO_RESOURCE_MEM);
	eval 'sub RIO_RESOURCE_DOORBELL () {0x200;}' unless defined(&RIO_RESOURCE_DOORBELL);
	eval 'sub RIO_RESOURCE_MAILBOX () {0x400;}' unless defined(&RIO_RESOURCE_MAILBOX);
	eval 'sub RIO_RESOURCE_CACHEABLE () {0x10000;}' unless defined(&RIO_RESOURCE_CACHEABLE);
	eval 'sub RIO_RESOURCE_PCI () {0x20000;}' unless defined(&RIO_RESOURCE_PCI);
	eval 'sub RIO_RESOURCE_BUSY () {0x80000000;}' unless defined(&RIO_RESOURCE_BUSY);
	eval 'sub to_rio_driver {
	    my($drv) = @_;
    	    eval q( &container_of($drv,\'struct rio_driver\',  &driver));
	}' unless defined(&to_rio_driver);
    }
}
1;
