require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPI_H)) {
    eval 'sub __LINUX_SPI_H () {1;}' unless defined(&__LINUX_SPI_H);
    eval 'sub SPI_CPHA () {0x1;}' unless defined(&SPI_CPHA);
    eval 'sub SPI_CPOL () {0x2;}' unless defined(&SPI_CPOL);
    eval 'sub SPI_MODE_0 () {(0|0);}' unless defined(&SPI_MODE_0);
    eval 'sub SPI_MODE_1 () {(0| &SPI_CPHA);}' unless defined(&SPI_MODE_1);
    eval 'sub SPI_MODE_2 () {( &SPI_CPOL|0);}' unless defined(&SPI_MODE_2);
    eval 'sub SPI_MODE_3 () {( &SPI_CPOL| &SPI_CPHA);}' unless defined(&SPI_MODE_3);
    eval 'sub SPI_CS_HIGH () {0x4;}' unless defined(&SPI_CS_HIGH);
    eval 'sub SPI_LSB_FIRST () {0x8;}' unless defined(&SPI_LSB_FIRST);
    eval 'sub spi_device {
        eval q(* &to_spi_device(\'struct device\' * &dev) {  &dev ?  &container_of( &dev, \'struct spi_device\',  &dev) :  &NULL; });
    }' unless defined(&spi_device);
    eval 'sub spi_dev_put {
        my($spi) = @_;
	    eval q({  &if ($spi)  &put_device( ($spi->{dev})); });
    }' unless defined(&spi_dev_put);
    eval 'sub spi_set_ctldata {
        my($spi,$state) = @_;
	    eval q({  ($spi->{controller_state}) = $state; });
    }' unless defined(&spi_set_ctldata);
    eval 'sub spi_driver {
        eval q(* &to_spi_driver(\'struct device_driver\' * &drv) {  &drv ?  &container_of( &drv, \'struct spi_driver\',  &driver) :  &NULL; });
    }' unless defined(&spi_driver);
    eval 'sub spi_unregister_driver {
        my($sdrv) = @_;
	    eval q({  &if (!$sdrv) ;  &driver_unregister( ($sdrv->{driver})); });
    }' unless defined(&spi_unregister_driver);
    eval 'sub void {
        eval q(* &spi_master_get_devdata(\'struct spi_master\' * &master) {  &class_get_devdata( ($master->{cdev})); });
    }' unless defined(&void);
    eval 'sub spi_master_set_devdata {
        my($master,$data) = @_;
	    eval q({  &class_set_devdata( ($master->{cdev}), $data); });
    }' unless defined(&spi_master_set_devdata);
    eval 'sub spi_master {
        eval q(* &spi_master_get(\'struct spi_master\' * &master) {  &if (! &master || ! &class_device_get( ($master->{cdev})))  &NULL;  &master; });
    }' unless defined(&spi_master);
    eval 'sub spi_master_put {
        my($master) = @_;
	    eval q({  &if ($master)  &class_device_put( ($master->{cdev})); });
    }' unless defined(&spi_master_put);
    eval 'sub spi_message_init {
        my($m) = @_;
	    eval q({  &memset($m, 0,  &sizeof *$m);  &INIT_LIST_HEAD( ($m->{transfers})); });
    }' unless defined(&spi_message_init);
    eval 'sub spi_message_add_tail {
        my($t,$m) = @_;
	    eval q({  &list_add_tail( ($t->{transfer_list}),  ($m->{transfers})); });
    }' unless defined(&spi_message_add_tail);
    eval 'sub spi_transfer_del {
        my($t) = @_;
	    eval q({  &list_del( ($t->{transfer_list})); });
    }' unless defined(&spi_transfer_del);
    eval 'sub spi_message_free {
        my($m) = @_;
	    eval q({  &kfree($m); });
    }' unless defined(&spi_message_free);
    if(defined(&CONFIG_SPI)) {
    } else {
    }
    eval 'sub spi_unregister_device {
        my($spi) = @_;
	    eval q({  &if ($spi)  &device_unregister( ($spi->{dev})); });
    }' unless defined(&spi_unregister_device);
}
1;
