require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TIPC_H_)) {
    eval 'sub _LINUX_TIPC_H_ () {1;}' unless defined(&_LINUX_TIPC_H_);
    require 'linux/types.ph';
    eval 'sub tipc_addr {
        my($zone,$cluster,$node) = @_;
	    eval q({ ($zone << 24) | ($cluster << 12) | $node; });
    }' unless defined(&tipc_addr);
    eval 'sub tipc_zone {
        my($addr) = @_;
	    eval q({ $addr >> 24; });
    }' unless defined(&tipc_zone);
    eval 'sub tipc_cluster {
        my($addr) = @_;
	    eval q({ ($addr >> 12) & 0xfff; });
    }' unless defined(&tipc_cluster);
    eval 'sub tipc_node {
        my($addr) = @_;
	    eval q({ $addr & 0xfff; });
    }' unless defined(&tipc_node);
    eval 'sub TIPC_CFG_SRV () {0;}' unless defined(&TIPC_CFG_SRV);
    eval 'sub TIPC_TOP_SRV () {1;}' unless defined(&TIPC_TOP_SRV);
    eval 'sub TIPC_RESERVED_TYPES () {64;}' unless defined(&TIPC_RESERVED_TYPES);
    eval 'sub TIPC_ZONE_SCOPE () {1;}' unless defined(&TIPC_ZONE_SCOPE);
    eval 'sub TIPC_CLUSTER_SCOPE () {2;}' unless defined(&TIPC_CLUSTER_SCOPE);
    eval 'sub TIPC_NODE_SCOPE () {3;}' unless defined(&TIPC_NODE_SCOPE);
    eval 'sub TIPC_MAX_USER_MSG_SIZE () {66000;}' unless defined(&TIPC_MAX_USER_MSG_SIZE);
    eval 'sub TIPC_LOW_IMPORTANCE () {0;}' unless defined(&TIPC_LOW_IMPORTANCE);
    eval 'sub TIPC_MEDIUM_IMPORTANCE () {1;}' unless defined(&TIPC_MEDIUM_IMPORTANCE);
    eval 'sub TIPC_HIGH_IMPORTANCE () {2;}' unless defined(&TIPC_HIGH_IMPORTANCE);
    eval 'sub TIPC_CRITICAL_IMPORTANCE () {3;}' unless defined(&TIPC_CRITICAL_IMPORTANCE);
    eval 'sub TIPC_OK () {0;}' unless defined(&TIPC_OK);
    eval 'sub TIPC_ERR_NO_NAME () {1;}' unless defined(&TIPC_ERR_NO_NAME);
    eval 'sub TIPC_ERR_NO_PORT () {2;}' unless defined(&TIPC_ERR_NO_PORT);
    eval 'sub TIPC_ERR_NO_NODE () {3;}' unless defined(&TIPC_ERR_NO_NODE);
    eval 'sub TIPC_ERR_OVERLOAD () {4;}' unless defined(&TIPC_ERR_OVERLOAD);
    eval 'sub TIPC_CONN_SHUTDOWN () {5;}' unless defined(&TIPC_CONN_SHUTDOWN);
    eval 'sub TIPC_SUB_PORTS () {0x1;}' unless defined(&TIPC_SUB_PORTS);
    eval 'sub TIPC_SUB_SERVICE () {0x2;}' unless defined(&TIPC_SUB_SERVICE);
    if(0) {
	eval 'sub TIPC_SUB_NO_BIND_EVTS () {0x4;}' unless defined(&TIPC_SUB_NO_BIND_EVTS);
	eval 'sub TIPC_SUB_NO_UNBIND_EVTS () {0x8;}' unless defined(&TIPC_SUB_NO_UNBIND_EVTS);
	eval 'sub TIPC_SUB_SINGLE_EVT () {0x10;}' unless defined(&TIPC_SUB_SINGLE_EVT);
    }
    eval 'sub TIPC_WAIT_FOREVER () {~0;}' unless defined(&TIPC_WAIT_FOREVER);
    eval 'sub TIPC_PUBLISHED () {1;}' unless defined(&TIPC_PUBLISHED);
    eval 'sub TIPC_WITHDRAWN () {2;}' unless defined(&TIPC_WITHDRAWN);
    eval 'sub TIPC_SUBSCR_TIMEOUT () {3;}' unless defined(&TIPC_SUBSCR_TIMEOUT);
    unless(defined(&AF_TIPC)) {
	eval 'sub AF_TIPC () {30;}' unless defined(&AF_TIPC);
    }
    unless(defined(&PF_TIPC)) {
	eval 'sub PF_TIPC () { &AF_TIPC;}' unless defined(&PF_TIPC);
    }
    unless(defined(&SOL_TIPC)) {
	eval 'sub SOL_TIPC () {271;}' unless defined(&SOL_TIPC);
    }
    eval 'sub TIPC_ADDR_NAMESEQ () {1;}' unless defined(&TIPC_ADDR_NAMESEQ);
    eval 'sub TIPC_ADDR_MCAST () {1;}' unless defined(&TIPC_ADDR_MCAST);
    eval 'sub TIPC_ADDR_NAME () {2;}' unless defined(&TIPC_ADDR_NAME);
    eval 'sub TIPC_ADDR_ID () {3;}' unless defined(&TIPC_ADDR_ID);
    eval 'sub TIPC_ERRINFO () {1;}' unless defined(&TIPC_ERRINFO);
    eval 'sub TIPC_RETDATA () {2;}' unless defined(&TIPC_RETDATA);
    eval 'sub TIPC_DESTNAME () {3;}' unless defined(&TIPC_DESTNAME);
    eval 'sub TIPC_IMPORTANCE () {127;}' unless defined(&TIPC_IMPORTANCE);
    eval 'sub TIPC_SRC_DROPPABLE () {128;}' unless defined(&TIPC_SRC_DROPPABLE);
    eval 'sub TIPC_DEST_DROPPABLE () {129;}' unless defined(&TIPC_DEST_DROPPABLE);
    eval 'sub TIPC_CONN_TIMEOUT () {130;}' unless defined(&TIPC_CONN_TIMEOUT);
}
1;
