require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_VIDEODEV_H)) {
    eval 'sub __LINUX_VIDEODEV_H () {1;}' unless defined(&__LINUX_VIDEODEV_H);
    require 'linux/types.ph';
    eval 'sub HAVE_V4L1 () {1;}' unless defined(&HAVE_V4L1);
    require 'linux/videodev2.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/mm.ph';
	eval 'sub to_video_device {
	    my($cd) = @_;
    	    eval q( &container_of($cd, \'struct video_device\',  &class_dev));
	}' unless defined(&to_video_device);
	eval 'sub video_device_create_file {
	    my($vfd,$attr) = @_;
    	    eval q({  &class_device_create_file( ($vfd->{class_dev}), $attr); });
	}' unless defined(&video_device_create_file);
	eval 'sub video_device_remove_file {
	    my($vfd,$attr) = @_;
    	    eval q({  &class_device_remove_file( ($vfd->{class_dev}), $attr); });
	}' unless defined(&video_device_remove_file);
	if((defined(&OBSOLETE_OWNER) ? &OBSOLETE_OWNER : 0) ) {
	    eval 'sub video_set_drvdata {
	        my($dev,$data) = @_;
    		eval q({  ($dev->{priv}) = $data; });
	    }' unless defined(&video_set_drvdata);
	}
    }
    eval 'sub VIDEO_VC_TUNER () {1;}' unless defined(&VIDEO_VC_TUNER);
    eval 'sub VIDEO_VC_AUDIO () {2;}' unless defined(&VIDEO_VC_AUDIO);
    eval 'sub VIDEO_TYPE_TV () {1;}' unless defined(&VIDEO_TYPE_TV);
    eval 'sub VIDEO_TYPE_CAMERA () {2;}' unless defined(&VIDEO_TYPE_CAMERA);
    eval 'sub VIDEO_TUNER_PAL () {1;}' unless defined(&VIDEO_TUNER_PAL);
    eval 'sub VIDEO_TUNER_NTSC () {2;}' unless defined(&VIDEO_TUNER_NTSC);
    eval 'sub VIDEO_TUNER_SECAM () {4;}' unless defined(&VIDEO_TUNER_SECAM);
    eval 'sub VIDEO_TUNER_LOW () {8;}' unless defined(&VIDEO_TUNER_LOW);
    eval 'sub VIDEO_TUNER_NORM () {16;}' unless defined(&VIDEO_TUNER_NORM);
    eval 'sub VIDEO_TUNER_STEREO_ON () {128;}' unless defined(&VIDEO_TUNER_STEREO_ON);
    eval 'sub VIDEO_TUNER_RDS_ON () {256;}' unless defined(&VIDEO_TUNER_RDS_ON);
    eval 'sub VIDEO_TUNER_MBS_ON () {512;}' unless defined(&VIDEO_TUNER_MBS_ON);
    eval 'sub VIDEO_MODE_PAL () {0;}' unless defined(&VIDEO_MODE_PAL);
    eval 'sub VIDEO_MODE_NTSC () {1;}' unless defined(&VIDEO_MODE_NTSC);
    eval 'sub VIDEO_MODE_SECAM () {2;}' unless defined(&VIDEO_MODE_SECAM);
    eval 'sub VIDEO_MODE_AUTO () {3;}' unless defined(&VIDEO_MODE_AUTO);
    eval 'sub VIDEO_PALETTE_GREY () {1;}' unless defined(&VIDEO_PALETTE_GREY);
    eval 'sub VIDEO_PALETTE_HI240 () {2;}' unless defined(&VIDEO_PALETTE_HI240);
    eval 'sub VIDEO_PALETTE_RGB565 () {3;}' unless defined(&VIDEO_PALETTE_RGB565);
    eval 'sub VIDEO_PALETTE_RGB24 () {4;}' unless defined(&VIDEO_PALETTE_RGB24);
    eval 'sub VIDEO_PALETTE_RGB32 () {5;}' unless defined(&VIDEO_PALETTE_RGB32);
    eval 'sub VIDEO_PALETTE_RGB555 () {6;}' unless defined(&VIDEO_PALETTE_RGB555);
    eval 'sub VIDEO_PALETTE_YUV422 () {7;}' unless defined(&VIDEO_PALETTE_YUV422);
    eval 'sub VIDEO_PALETTE_YUYV () {8;}' unless defined(&VIDEO_PALETTE_YUYV);
    eval 'sub VIDEO_PALETTE_UYVY () {9;}' unless defined(&VIDEO_PALETTE_UYVY);
    eval 'sub VIDEO_PALETTE_YUV420 () {10;}' unless defined(&VIDEO_PALETTE_YUV420);
    eval 'sub VIDEO_PALETTE_YUV411 () {11;}' unless defined(&VIDEO_PALETTE_YUV411);
    eval 'sub VIDEO_PALETTE_RAW () {12;}' unless defined(&VIDEO_PALETTE_RAW);
    eval 'sub VIDEO_PALETTE_YUV422P () {13;}' unless defined(&VIDEO_PALETTE_YUV422P);
    eval 'sub VIDEO_PALETTE_YUV411P () {14;}' unless defined(&VIDEO_PALETTE_YUV411P);
    eval 'sub VIDEO_PALETTE_YUV420P () {15;}' unless defined(&VIDEO_PALETTE_YUV420P);
    eval 'sub VIDEO_PALETTE_YUV410P () {16;}' unless defined(&VIDEO_PALETTE_YUV410P);
    eval 'sub VIDEO_PALETTE_PLANAR () {13;}' unless defined(&VIDEO_PALETTE_PLANAR);
    eval 'sub VIDEO_PALETTE_COMPONENT () {7;}' unless defined(&VIDEO_PALETTE_COMPONENT);
    eval 'sub VIDEO_AUDIO_MUTE () {1;}' unless defined(&VIDEO_AUDIO_MUTE);
    eval 'sub VIDEO_AUDIO_MUTABLE () {2;}' unless defined(&VIDEO_AUDIO_MUTABLE);
    eval 'sub VIDEO_AUDIO_VOLUME () {4;}' unless defined(&VIDEO_AUDIO_VOLUME);
    eval 'sub VIDEO_AUDIO_BASS () {8;}' unless defined(&VIDEO_AUDIO_BASS);
    eval 'sub VIDEO_AUDIO_TREBLE () {16;}' unless defined(&VIDEO_AUDIO_TREBLE);
    eval 'sub VIDEO_AUDIO_BALANCE () {32;}' unless defined(&VIDEO_AUDIO_BALANCE);
    eval 'sub VIDEO_SOUND_MONO () {1;}' unless defined(&VIDEO_SOUND_MONO);
    eval 'sub VIDEO_SOUND_STEREO () {2;}' unless defined(&VIDEO_SOUND_STEREO);
    eval 'sub VIDEO_SOUND_LANG1 () {4;}' unless defined(&VIDEO_SOUND_LANG1);
    eval 'sub VIDEO_SOUND_LANG2 () {8;}' unless defined(&VIDEO_SOUND_LANG2);
    eval 'sub VIDEO_WINDOW_INTERLACE () {1;}' unless defined(&VIDEO_WINDOW_INTERLACE);
    eval 'sub VIDEO_WINDOW_CHROMAKEY () {16;}' unless defined(&VIDEO_WINDOW_CHROMAKEY);
    eval 'sub VIDEO_CLIP_BITMAP () {-1;}' unless defined(&VIDEO_CLIP_BITMAP);
    eval 'sub VIDEO_CLIPMAP_SIZE () {(128* 625);}' unless defined(&VIDEO_CLIPMAP_SIZE);
    eval 'sub VIDEO_CAPTURE_ODD () {0;}' unless defined(&VIDEO_CAPTURE_ODD);
    eval 'sub VIDEO_CAPTURE_EVEN () {1;}' unless defined(&VIDEO_CAPTURE_EVEN);
    eval 'sub VIDEO_NO_UNIT () {(-1);}' unless defined(&VIDEO_NO_UNIT);
    eval 'sub VBI_UNSYNC () {1;}' unless defined(&VBI_UNSYNC);
    eval 'sub VBI_INTERLACED () {2;}' unless defined(&VBI_INTERLACED);
    eval 'sub VIDIOCGCAP () { &_IOR(ord(\'v\'),1,\'struct video_capability\');}' unless defined(&VIDIOCGCAP);
    eval 'sub VIDIOCGCHAN () { &_IOWR(ord(\'v\'),2,\'struct video_channel\');}' unless defined(&VIDIOCGCHAN);
    eval 'sub VIDIOCSCHAN () { &_IOW(ord(\'v\'),3,\'struct video_channel\');}' unless defined(&VIDIOCSCHAN);
    eval 'sub VIDIOCGTUNER () { &_IOWR(ord(\'v\'),4,\'struct video_tuner\');}' unless defined(&VIDIOCGTUNER);
    eval 'sub VIDIOCSTUNER () { &_IOW(ord(\'v\'),5,\'struct video_tuner\');}' unless defined(&VIDIOCSTUNER);
    eval 'sub VIDIOCGPICT () { &_IOR(ord(\'v\'),6,\'struct video_picture\');}' unless defined(&VIDIOCGPICT);
    eval 'sub VIDIOCSPICT () { &_IOW(ord(\'v\'),7,\'struct video_picture\');}' unless defined(&VIDIOCSPICT);
    eval 'sub VIDIOCCAPTURE () { &_IOW(ord(\'v\'),8,\'int\');}' unless defined(&VIDIOCCAPTURE);
    eval 'sub VIDIOCGWIN () { &_IOR(ord(\'v\'),9, \'struct video_window\');}' unless defined(&VIDIOCGWIN);
    eval 'sub VIDIOCSWIN () { &_IOW(ord(\'v\'),10, \'struct video_window\');}' unless defined(&VIDIOCSWIN);
    eval 'sub VIDIOCGFBUF () { &_IOR(ord(\'v\'),11, \'struct video_buffer\');}' unless defined(&VIDIOCGFBUF);
    eval 'sub VIDIOCSFBUF () { &_IOW(ord(\'v\'),12, \'struct video_buffer\');}' unless defined(&VIDIOCSFBUF);
    eval 'sub VIDIOCKEY () { &_IOR(ord(\'v\'),13, \'struct video_key\');}' unless defined(&VIDIOCKEY);
    eval 'sub VIDIOCGFREQ () { &_IOR(ord(\'v\'),14, \'unsigned long\');}' unless defined(&VIDIOCGFREQ);
    eval 'sub VIDIOCSFREQ () { &_IOW(ord(\'v\'),15, \'unsigned long\');}' unless defined(&VIDIOCSFREQ);
    eval 'sub VIDIOCGAUDIO () { &_IOR(ord(\'v\'),16, \'struct video_audio\');}' unless defined(&VIDIOCGAUDIO);
    eval 'sub VIDIOCSAUDIO () { &_IOW(ord(\'v\'),17, \'struct video_audio\');}' unless defined(&VIDIOCSAUDIO);
    eval 'sub VIDIOCSYNC () { &_IOW(ord(\'v\'),18, \'int\');}' unless defined(&VIDIOCSYNC);
    eval 'sub VIDIOCMCAPTURE () { &_IOW(ord(\'v\'),19, \'struct video_mmap\');}' unless defined(&VIDIOCMCAPTURE);
    eval 'sub VIDIOCGMBUF () { &_IOR(ord(\'v\'),20, \'struct video_mbuf\');}' unless defined(&VIDIOCGMBUF);
    eval 'sub VIDIOCGUNIT () { &_IOR(ord(\'v\'),21, \'struct video_unit\');}' unless defined(&VIDIOCGUNIT);
    eval 'sub VIDIOCGCAPTURE () { &_IOR(ord(\'v\'),22, \'struct video_capture\');}' unless defined(&VIDIOCGCAPTURE);
    eval 'sub VIDIOCSCAPTURE () { &_IOW(ord(\'v\'),23, \'struct video_capture\');}' unless defined(&VIDIOCSCAPTURE);
    eval 'sub VIDIOCSPLAYMODE () { &_IOW(ord(\'v\'),24, \'struct video_play_mode\');}' unless defined(&VIDIOCSPLAYMODE);
    eval 'sub VIDIOCSWRITEMODE () { &_IOW(ord(\'v\'),25, \'int\');}' unless defined(&VIDIOCSWRITEMODE);
    eval 'sub VIDIOCGPLAYINFO () { &_IOR(ord(\'v\'),26, \'struct video_info\');}' unless defined(&VIDIOCGPLAYINFO);
    eval 'sub VIDIOCSMICROCODE () { &_IOW(ord(\'v\'),27, \'struct video_code\');}' unless defined(&VIDIOCSMICROCODE);
    eval 'sub VIDIOCGVBIFMT () { &_IOR(ord(\'v\'),28, \'struct vbi_format\');}' unless defined(&VIDIOCGVBIFMT);
    eval 'sub VIDIOCSVBIFMT () { &_IOW(ord(\'v\'),29, \'struct vbi_format\');}' unless defined(&VIDIOCSVBIFMT);
    eval 'sub BASE_VIDIOCPRIVATE () {192;}' unless defined(&BASE_VIDIOCPRIVATE);
    eval 'sub VID_WRITE_MPEG_AUD () {0;}' unless defined(&VID_WRITE_MPEG_AUD);
    eval 'sub VID_WRITE_MPEG_VID () {1;}' unless defined(&VID_WRITE_MPEG_VID);
    eval 'sub VID_WRITE_OSD () {2;}' unless defined(&VID_WRITE_OSD);
    eval 'sub VID_WRITE_TTX () {3;}' unless defined(&VID_WRITE_TTX);
    eval 'sub VID_WRITE_CC () {4;}' unless defined(&VID_WRITE_CC);
    eval 'sub VID_WRITE_MJPEG () {5;}' unless defined(&VID_WRITE_MJPEG);
    eval 'sub VID_PLAY_VID_OUT_MODE () {0;}' unless defined(&VID_PLAY_VID_OUT_MODE);
    eval 'sub VID_PLAY_GENLOCK () {1;}' unless defined(&VID_PLAY_GENLOCK);
    eval 'sub VID_PLAY_NORMAL () {2;}' unless defined(&VID_PLAY_NORMAL);
    eval 'sub VID_PLAY_PAUSE () {3;}' unless defined(&VID_PLAY_PAUSE);
    eval 'sub VID_PLAY_SINGLE_FRAME () {4;}' unless defined(&VID_PLAY_SINGLE_FRAME);
    eval 'sub VID_PLAY_FAST_FORWARD () {5;}' unless defined(&VID_PLAY_FAST_FORWARD);
    eval 'sub VID_PLAY_SLOW_MOTION () {6;}' unless defined(&VID_PLAY_SLOW_MOTION);
    eval 'sub VID_PLAY_IMMEDIATE_NORMAL () {7;}' unless defined(&VID_PLAY_IMMEDIATE_NORMAL);
    eval 'sub VID_PLAY_SWITCH_CHANNELS () {8;}' unless defined(&VID_PLAY_SWITCH_CHANNELS);
    eval 'sub VID_PLAY_FREEZE_FRAME () {9;}' unless defined(&VID_PLAY_FREEZE_FRAME);
    eval 'sub VID_PLAY_STILL_MODE () {10;}' unless defined(&VID_PLAY_STILL_MODE);
    eval 'sub VID_PLAY_MASTER_MODE () {11;}' unless defined(&VID_PLAY_MASTER_MODE);
    eval 'sub VID_PLAY_MASTER_NONE () {1;}' unless defined(&VID_PLAY_MASTER_NONE);
    eval 'sub VID_PLAY_MASTER_VIDEO () {2;}' unless defined(&VID_PLAY_MASTER_VIDEO);
    eval 'sub VID_PLAY_MASTER_AUDIO () {3;}' unless defined(&VID_PLAY_MASTER_AUDIO);
    eval 'sub VID_PLAY_ACTIVE_SCANLINES () {12;}' unless defined(&VID_PLAY_ACTIVE_SCANLINES);
    eval 'sub VID_PLAY_RESET () {13;}' unless defined(&VID_PLAY_RESET);
    eval 'sub VID_PLAY_END_MARK () {14;}' unless defined(&VID_PLAY_END_MARK);
    eval 'sub VID_HARDWARE_BT848 () {1;}' unless defined(&VID_HARDWARE_BT848);
    eval 'sub VID_HARDWARE_QCAM_BW () {2;}' unless defined(&VID_HARDWARE_QCAM_BW);
    eval 'sub VID_HARDWARE_PMS () {3;}' unless defined(&VID_HARDWARE_PMS);
    eval 'sub VID_HARDWARE_QCAM_C () {4;}' unless defined(&VID_HARDWARE_QCAM_C);
    eval 'sub VID_HARDWARE_PSEUDO () {5;}' unless defined(&VID_HARDWARE_PSEUDO);
    eval 'sub VID_HARDWARE_SAA5249 () {6;}' unless defined(&VID_HARDWARE_SAA5249);
    eval 'sub VID_HARDWARE_AZTECH () {7;}' unless defined(&VID_HARDWARE_AZTECH);
    eval 'sub VID_HARDWARE_SF16MI () {8;}' unless defined(&VID_HARDWARE_SF16MI);
    eval 'sub VID_HARDWARE_RTRACK () {9;}' unless defined(&VID_HARDWARE_RTRACK);
    eval 'sub VID_HARDWARE_ZOLTRIX () {10;}' unless defined(&VID_HARDWARE_ZOLTRIX);
    eval 'sub VID_HARDWARE_SAA7146 () {11;}' unless defined(&VID_HARDWARE_SAA7146);
    eval 'sub VID_HARDWARE_VIDEUM () {12;}' unless defined(&VID_HARDWARE_VIDEUM);
    eval 'sub VID_HARDWARE_RTRACK2 () {13;}' unless defined(&VID_HARDWARE_RTRACK2);
    eval 'sub VID_HARDWARE_PERMEDIA2 () {14;}' unless defined(&VID_HARDWARE_PERMEDIA2);
    eval 'sub VID_HARDWARE_RIVA128 () {15;}' unless defined(&VID_HARDWARE_RIVA128);
    eval 'sub VID_HARDWARE_PLANB () {16;}' unless defined(&VID_HARDWARE_PLANB);
    eval 'sub VID_HARDWARE_BROADWAY () {17;}' unless defined(&VID_HARDWARE_BROADWAY);
    eval 'sub VID_HARDWARE_GEMTEK () {18;}' unless defined(&VID_HARDWARE_GEMTEK);
    eval 'sub VID_HARDWARE_TYPHOON () {19;}' unless defined(&VID_HARDWARE_TYPHOON);
    eval 'sub VID_HARDWARE_VINO () {20;}' unless defined(&VID_HARDWARE_VINO);
    eval 'sub VID_HARDWARE_CADET () {21;}' unless defined(&VID_HARDWARE_CADET);
    eval 'sub VID_HARDWARE_TRUST () {22;}' unless defined(&VID_HARDWARE_TRUST);
    eval 'sub VID_HARDWARE_TERRATEC () {23;}' unless defined(&VID_HARDWARE_TERRATEC);
    eval 'sub VID_HARDWARE_CPIA () {24;}' unless defined(&VID_HARDWARE_CPIA);
    eval 'sub VID_HARDWARE_ZR36120 () {25;}' unless defined(&VID_HARDWARE_ZR36120);
    eval 'sub VID_HARDWARE_ZR36067 () {26;}' unless defined(&VID_HARDWARE_ZR36067);
    eval 'sub VID_HARDWARE_OV511 () {27;}' unless defined(&VID_HARDWARE_OV511);
    eval 'sub VID_HARDWARE_ZR356700 () {28;}' unless defined(&VID_HARDWARE_ZR356700);
    eval 'sub VID_HARDWARE_W9966 () {29;}' unless defined(&VID_HARDWARE_W9966);
    eval 'sub VID_HARDWARE_SE401 () {30;}' unless defined(&VID_HARDWARE_SE401);
    eval 'sub VID_HARDWARE_PWC () {31;}' unless defined(&VID_HARDWARE_PWC);
    eval 'sub VID_HARDWARE_MEYE () {32;}' unless defined(&VID_HARDWARE_MEYE);
    eval 'sub VID_HARDWARE_CPIA2 () {33;}' unless defined(&VID_HARDWARE_CPIA2);
    eval 'sub VID_HARDWARE_VICAM () {34;}' unless defined(&VID_HARDWARE_VICAM);
    eval 'sub VID_HARDWARE_SF16FMR2 () {35;}' unless defined(&VID_HARDWARE_SF16FMR2);
    eval 'sub VID_HARDWARE_W9968CF () {36;}' unless defined(&VID_HARDWARE_W9968CF);
    eval 'sub VID_HARDWARE_SAA7114H () {37;}' unless defined(&VID_HARDWARE_SAA7114H);
    eval 'sub VID_HARDWARE_SN9C102 () {38;}' unless defined(&VID_HARDWARE_SN9C102);
    eval 'sub VID_HARDWARE_ARV () {39;}' unless defined(&VID_HARDWARE_ARV);
}
1;
