require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MOUNT_H)) {
    eval 'sub _LINUX_MOUNT_H () {1;}' unless defined(&_LINUX_MOUNT_H);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/list.ph';
	require 'linux/spinlock.ph';
	require 'asm/atomic.ph';
	eval 'sub MNT_NOSUID () {0x1;}' unless defined(&MNT_NOSUID);
	eval 'sub MNT_NODEV () {0x2;}' unless defined(&MNT_NODEV);
	eval 'sub MNT_NOEXEC () {0x4;}' unless defined(&MNT_NOEXEC);
	eval 'sub MNT_NOATIME () {0x8;}' unless defined(&MNT_NOATIME);
	eval 'sub MNT_NODIRATIME () {0x10;}' unless defined(&MNT_NODIRATIME);
	eval 'sub MNT_SHARED () {0x1000;}' unless defined(&MNT_SHARED);
	eval 'sub MNT_UNBINDABLE () {0x2000;}' unless defined(&MNT_UNBINDABLE);
	eval 'sub MNT_PNODE_MASK () {0x3000;}' unless defined(&MNT_PNODE_MASK);
	eval 'sub vfsmount {
	    eval q(* &mntget(\'struct vfsmount\' * &mnt) {  &if ( &mnt)  &atomic_inc( ($mnt->{mnt_count}));  &mnt; });
	}' unless defined(&vfsmount);
	eval 'sub mntput {
	    my($mnt) = @_;
    	    eval q({  &if ($mnt) {  ($mnt->{mnt_expiry_mark}) = 0;  &mntput_no_expire($mnt); } });
	}' unless defined(&mntput);
    }
}
1;
