require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PNP_H)) {
    eval 'sub _LINUX_PNP_H () {1;}' unless defined(&_LINUX_PNP_H);
    if(defined(&__KERNEL__)) {
	require 'linux/device.ph';
	require 'linux/list.ph';
	require 'linux/errno.ph';
	require 'linux/mod_devicetable.ph';
	eval 'sub PNP_MAX_PORT () {8;}' unless defined(&PNP_MAX_PORT);
	eval 'sub PNP_MAX_MEM () {4;}' unless defined(&PNP_MAX_MEM);
	eval 'sub PNP_MAX_IRQ () {2;}' unless defined(&PNP_MAX_IRQ);
	eval 'sub PNP_MAX_DMA () {2;}' unless defined(&PNP_MAX_DMA);
	eval 'sub PNP_NAME_LEN () {50;}' unless defined(&PNP_NAME_LEN);
	eval 'sub pnp_port_start {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{port_resource[&(bar)]}->{start})));
	}' unless defined(&pnp_port_start);
	eval 'sub pnp_port_end {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{port_resource[&(bar)]}->{end})));
	}' unless defined(&pnp_port_end);
	eval 'sub pnp_port_flags {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{port_resource[&(bar)]}->{flags})));
	}' unless defined(&pnp_port_flags);
	eval 'sub pnp_port_valid {
	    my($dev,$bar) = @_;
    	    eval q((( &pnp_port_flags(($dev),($bar)) & ( &IORESOURCE_IO |  &IORESOURCE_UNSET)) ==  &IORESOURCE_IO));
	}' unless defined(&pnp_port_valid);
	eval 'sub pnp_port_len {
	    my($dev,$bar) = @_;
    	    eval q((( &pnp_port_start(($dev),($bar)) == 0 &&  &pnp_port_end(($dev),($bar)) ==  &pnp_port_start(($dev),($bar))) ? 0: ( &pnp_port_end(($dev),($bar)) -  &pnp_port_start(($dev),($bar)) + 1)));
	}' unless defined(&pnp_port_len);
	eval 'sub pnp_mem_start {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{mem_resource[&(bar)]}->{start})));
	}' unless defined(&pnp_mem_start);
	eval 'sub pnp_mem_end {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{mem_resource[&(bar)]}->{end})));
	}' unless defined(&pnp_mem_end);
	eval 'sub pnp_mem_flags {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{mem_resource[&(bar)]}->{flags})));
	}' unless defined(&pnp_mem_flags);
	eval 'sub pnp_mem_valid {
	    my($dev,$bar) = @_;
    	    eval q((( &pnp_mem_flags(($dev),($bar)) & ( &IORESOURCE_MEM |  &IORESOURCE_UNSET)) ==  &IORESOURCE_MEM));
	}' unless defined(&pnp_mem_valid);
	eval 'sub pnp_mem_len {
	    my($dev,$bar) = @_;
    	    eval q((( &pnp_mem_start(($dev),($bar)) == 0 &&  &pnp_mem_end(($dev),($bar)) ==  &pnp_mem_start(($dev),($bar))) ? 0: ( &pnp_mem_end(($dev),($bar)) -  &pnp_mem_start(($dev),($bar)) + 1)));
	}' unless defined(&pnp_mem_len);
	eval 'sub pnp_irq {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{irq_resource[&(bar)]}->{start})));
	}' unless defined(&pnp_irq);
	eval 'sub pnp_irq_flags {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{irq_resource[&(bar)]}->{flags})));
	}' unless defined(&pnp_irq_flags);
	eval 'sub pnp_irq_valid {
	    my($dev,$bar) = @_;
    	    eval q((( &pnp_irq_flags(($dev),($bar)) & ( &IORESOURCE_IRQ |  &IORESOURCE_UNSET)) ==  &IORESOURCE_IRQ));
	}' unless defined(&pnp_irq_valid);
	eval 'sub pnp_dma {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{dma_resource[&(bar)]}->{start})));
	}' unless defined(&pnp_dma);
	eval 'sub pnp_dma_flags {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($res->{dma_resource[&(bar)]}->{flags})));
	}' unless defined(&pnp_dma_flags);
	eval 'sub pnp_dma_valid {
	    my($dev,$bar) = @_;
    	    eval q((( &pnp_dma_flags(($dev),($bar)) & ( &IORESOURCE_DMA |  &IORESOURCE_UNSET)) ==  &IORESOURCE_DMA));
	}' unless defined(&pnp_dma_valid);
	eval 'sub PNP_PORT_FLAG_16BITADDR () {(1<<0);}' unless defined(&PNP_PORT_FLAG_16BITADDR);
	eval 'sub PNP_PORT_FLAG_FIXED () {(1<<1);}' unless defined(&PNP_PORT_FLAG_FIXED);
	eval 'sub PNP_IRQ_NR () {256;}' unless defined(&PNP_IRQ_NR);
	eval 'sub PNP_RES_PRIORITY_PREFERRED () {0;}' unless defined(&PNP_RES_PRIORITY_PREFERRED);
	eval 'sub PNP_RES_PRIORITY_ACCEPTABLE () {1;}' unless defined(&PNP_RES_PRIORITY_ACCEPTABLE);
	eval 'sub PNP_RES_PRIORITY_FUNCTIONAL () {2;}' unless defined(&PNP_RES_PRIORITY_FUNCTIONAL);
	eval 'sub PNP_RES_PRIORITY_INVALID () {65535;}' unless defined(&PNP_RES_PRIORITY_INVALID);
	eval 'sub global_to_pnp_card {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pnp_card\',  &global_list));
	}' unless defined(&global_to_pnp_card);
	eval 'sub protocol_to_pnp_card {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pnp_card\',  &protocol_list));
	}' unless defined(&protocol_to_pnp_card);
	eval 'sub to_pnp_card {
	    my($n) = @_;
    	    eval q( &container_of($n, \'struct pnp_card\',  &dev));
	}' unless defined(&to_pnp_card);
	eval 'sub pnp_for_each_card {
	    my($card) = @_;
    	    eval q( &for(($card) =  &global_to_pnp_card( ($pnp_cards->{next})); ($card) !=  &global_to_pnp_card( &pnp_cards); ($card) =  &global_to_pnp_card(($card)-> ($global_list->{next}))));
	}' unless defined(&pnp_for_each_card);
	eval 'sub void {
	    eval q(* &pnp_get_card_drvdata (\'struct pnp_card_link\' * &pcard) {  ($pcard->{driver_data}); });
	}' unless defined(&void);
	eval 'sub pnp_set_card_drvdata {
	    my($pcard,$data) = @_;
    	    eval q({  ($pcard->{driver_data}) = $data; });
	}' unless defined(&pnp_set_card_drvdata);
	eval 'sub global_to_pnp_dev {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pnp_dev\',  &global_list));
	}' unless defined(&global_to_pnp_dev);
	eval 'sub card_to_pnp_dev {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pnp_dev\',  &card_list));
	}' unless defined(&card_to_pnp_dev);
	eval 'sub protocol_to_pnp_dev {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pnp_dev\',  &protocol_list));
	}' unless defined(&protocol_to_pnp_dev);
	eval 'sub to_pnp_dev {
	    my($n) = @_;
    	    eval q( &container_of($n, \'struct pnp_dev\',  &dev));
	}' unless defined(&to_pnp_dev);
	eval 'sub pnp_for_each_dev {
	    my($dev) = @_;
    	    eval q( &for(($dev) =  &global_to_pnp_dev( ($pnp_global->{next})); ($dev) !=  &global_to_pnp_dev( &pnp_global); ($dev) =  &global_to_pnp_dev(($dev)-> ($global_list->{next}))));
	}' unless defined(&pnp_for_each_dev);
	eval 'sub card_for_each_dev {
	    my($card,$dev) = @_;
    	    eval q( &for(($dev) =  &card_to_pnp_dev(($card)-> ($devices->{next})); ($dev) !=  &card_to_pnp_dev(($card)-> &devices); ($dev) =  &card_to_pnp_dev(($dev)-> ($card_list->{next}))));
	}' unless defined(&card_for_each_dev);
	eval 'sub pnp_dev_name {
	    my($dev) = @_;
    	    eval q(($dev)-> &name);
	}' unless defined(&pnp_dev_name);
	eval 'sub void {
	    eval q(* &pnp_get_drvdata (\'struct pnp_dev\' * &pdev) {  &dev_get_drvdata( ($pdev->{dev})); });
	}' unless defined(&void);
	eval 'sub pnp_set_drvdata {
	    my($pdev,$data) = @_;
    	    eval q({  &dev_set_drvdata( ($pdev->{dev}), $data); });
	}' unless defined(&pnp_set_drvdata);
	eval 'sub PNP_CONFIG_NORMAL () {0x1;}' unless defined(&PNP_CONFIG_NORMAL);
	eval 'sub PNP_CONFIG_FORCE () {0x2;}' unless defined(&PNP_CONFIG_FORCE);
	eval 'sub PNP_READ () {0x1;}' unless defined(&PNP_READ);
	eval 'sub PNP_WRITE () {0x2;}' unless defined(&PNP_WRITE);
	eval 'sub PNP_DISABLE () {0x4;}' unless defined(&PNP_DISABLE);
	eval 'sub PNP_CONFIGURABLE () {0x8;}' unless defined(&PNP_CONFIGURABLE);
	eval 'sub PNP_REMOVABLE () {0x10;}' unless defined(&PNP_REMOVABLE);
	eval 'sub pnp_can_read {
	    my($dev) = @_;
    	    eval q(((($dev)-> &protocol)  && (($dev)-> ($protocol->{get}))  && (($dev)-> &capabilities &  &PNP_READ)));
	}' unless defined(&pnp_can_read);
	eval 'sub pnp_can_write {
	    my($dev) = @_;
    	    eval q(((($dev)-> &protocol)  && (($dev)-> ($protocol->{set}))  && (($dev)-> &capabilities &  &PNP_WRITE)));
	}' unless defined(&pnp_can_write);
	eval 'sub pnp_can_disable {
	    my($dev) = @_;
    	    eval q(((($dev)-> &protocol)  && (($dev)-> ($protocol->{disable}))  && (($dev)-> &capabilities &  &PNP_DISABLE)));
	}' unless defined(&pnp_can_disable);
	eval 'sub pnp_can_configure {
	    my($dev) = @_;
    	    eval q(((!($dev)-> &active)  && (($dev)-> &capabilities &  &PNP_CONFIGURABLE)));
	}' unless defined(&pnp_can_configure);
	if(defined(&CONFIG_ISAPNP)) {
	    eval 'sub pnp_device_is_isapnp {
	        my($dev) = @_;
    		eval q((($dev)-> &protocol == ( &isapnp_protocol)));
	    }' unless defined(&pnp_device_is_isapnp);
	} else {
	    eval 'sub pnp_device_is_isapnp {
	        my($dev) = @_;
    		eval q(0);
	    }' unless defined(&pnp_device_is_isapnp);
	}
	if(defined(&CONFIG_PNPBIOS)) {
	    eval 'sub pnp_device_is_pnpbios {
	        my($dev) = @_;
    		eval q((($dev)-> &protocol == ( &pnpbios_protocol)));
	    }' unless defined(&pnp_device_is_pnpbios);
	} else {
	    eval 'sub pnp_device_is_pnpbios {
	        my($dev) = @_;
    		eval q(0);
	    }' unless defined(&pnp_device_is_pnpbios);
	}
	eval 'sub PNP_READY () {0x;}' unless defined(&PNP_READY);
	eval 'sub PNP_ATTACHED () {0x1;}' unless defined(&PNP_ATTACHED);
	eval 'sub PNP_BUSY () {0x2;}' unless defined(&PNP_BUSY);
	eval 'sub PNP_FAULTY () {0x4;}' unless defined(&PNP_FAULTY);
	eval 'sub isapnp_card_number {
	    my($dev) = @_;
    	    eval q((($dev)-> &card ? ($dev)-> ($card->{number}) : -1));
	}' unless defined(&isapnp_card_number);
	eval 'sub isapnp_csn_number {
	    my($dev) = @_;
    	    eval q((($dev)-> &number));
	}' unless defined(&isapnp_csn_number);
	eval 'sub to_pnp_driver {
	    my($drv) = @_;
    	    eval q( &container_of($drv, \'struct pnp_driver\',  &driver));
	}' unless defined(&to_pnp_driver);
	eval 'sub to_pnp_card_driver {
	    my($drv) = @_;
    	    eval q( &container_of($drv, \'struct pnp_card_driver\',  &link));
	}' unless defined(&to_pnp_card_driver);
	eval 'sub PNP_DRIVER_RES_DO_NOT_CHANGE () {0x1;}' unless defined(&PNP_DRIVER_RES_DO_NOT_CHANGE);
	eval 'sub PNP_DRIVER_RES_DISABLE () {0x3;}' unless defined(&PNP_DRIVER_RES_DISABLE);
	eval 'sub to_pnp_protocol {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pnp_protocol\',  &protocol_list));
	}' unless defined(&to_pnp_protocol);
	eval 'sub protocol_for_each_card {
	    my($protocol,$card) = @_;
    	    eval q( &for(($card) =  &protocol_to_pnp_card(($protocol)-> ($cards->{next})); ($card) !=  &protocol_to_pnp_card(($protocol)-> &cards); ($card) =  &protocol_to_pnp_card(($card)-> ($protocol_list->{next}))));
	}' unless defined(&protocol_for_each_card);
	eval 'sub protocol_for_each_dev {
	    my($protocol,$dev) = @_;
    	    eval q( &for(($dev) =  &protocol_to_pnp_dev(($protocol)-> ($devices->{next})); ($dev) !=  &protocol_to_pnp_dev(($protocol)-> &devices); ($dev) =  &protocol_to_pnp_dev(($dev)-> ($protocol_list->{next}))));
	}' unless defined(&protocol_for_each_dev);
	if(defined( &CONFIG_PNP)) {
	} else {
	}
	eval 'sub pnp_err () {( &format,  &arg...)  &printk( &KERN_ERR "pnp: "  &format "\\n" ,   &arg);}' unless defined(&pnp_err);
	eval 'sub pnp_info () {( &format,  &arg...)  &printk( &KERN_INFO "pnp: "  &format "\\n" ,   &arg);}' unless defined(&pnp_info);
	eval 'sub pnp_warn () {( &format,  &arg...)  &printk( &KERN_WARNING "pnp: "  &format "\\n" ,   &arg);}' unless defined(&pnp_warn);
	if(defined(&CONFIG_PNP_DEBUG)) {
	    eval 'sub pnp_dbg () {( &format,  &arg...)  &printk( &KERN_DEBUG "pnp: "  &format "\\n" ,   &arg);}' unless defined(&pnp_dbg);
	} else {
	    eval 'sub pnp_dbg () {( &format,  &arg...)  &do {}  &while (0);}' unless defined(&pnp_dbg);
	}
    }
}
1;
