require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SKBUFF_H)) {
    eval 'sub _LINUX_SKBUFF_H () {1;}' unless defined(&_LINUX_SKBUFF_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'linux/compiler.ph';
    require 'linux/time.ph';
    require 'linux/cache.ph';
    require 'asm/atomic.ph';
    require 'asm/types.ph';
    require 'linux/spinlock.ph';
    require 'linux/mm.ph';
    require 'linux/highmem.ph';
    require 'linux/poll.ph';
    require 'linux/net.ph';
    require 'linux/textsearch.ph';
    require 'net/checksum.ph';
    eval 'sub HAVE_ALLOC_SKB () {1;}' unless defined(&HAVE_ALLOC_SKB);
    eval 'sub HAVE_ALIGNABLE_SKB () {1;}' unless defined(&HAVE_ALIGNABLE_SKB);
    eval 'sub CHECKSUM_NONE () {0;}' unless defined(&CHECKSUM_NONE);
    eval 'sub CHECKSUM_HW () {1;}' unless defined(&CHECKSUM_HW);
    eval 'sub CHECKSUM_UNNECESSARY () {2;}' unless defined(&CHECKSUM_UNNECESSARY);
    eval 'sub SKB_DATA_ALIGN {
        my($X) = @_;
	    eval q(((($X) + ( &SMP_CACHE_BYTES - 1)) & ~( &SMP_CACHE_BYTES - 1)));
    }' unless defined(&SKB_DATA_ALIGN);
    eval 'sub SKB_MAX_ORDER {
        my($X, $ORDER) = @_;
	    eval q(((( &PAGE_SIZE << ($ORDER)) - ($X) - $sizeof{\'struct skb_shared_info\'}) & ~( &SMP_CACHE_BYTES - 1)));
    }' unless defined(&SKB_MAX_ORDER);
    eval 'sub SKB_MAX_HEAD {
        my($X) = @_;
	    eval q(( &SKB_MAX_ORDER(($X), 0)));
    }' unless defined(&SKB_MAX_HEAD);
    eval 'sub SKB_MAX_ALLOC () {( &SKB_MAX_ORDER(0, 2));}' unless defined(&SKB_MAX_ALLOC);
    if(defined(&CONFIG_NETFILTER)) {
	if(defined(&CONFIG_BRIDGE_NETFILTER)) {
	    if(defined( &CONFIG_VLAN_8021Q) || defined( &CONFIG_VLAN_8021Q_MODULE)) {
	    }
	}
    }
    eval 'sub MAX_SKB_FRAGS () {(65536/ &PAGE_SIZE + 2);}' unless defined(&MAX_SKB_FRAGS);
    eval 'sub SKB_DATAREF_SHIFT () {16;}' unless defined(&SKB_DATAREF_SHIFT);
    eval 'sub SKB_DATAREF_MASK () {((1<<  &SKB_DATAREF_SHIFT) - 1);}' unless defined(&SKB_DATAREF_MASK);
    eval("sub SKB_FCLONE_UNAVAILABLE () { 0; }") unless defined(&SKB_FCLONE_UNAVAILABLE);
    eval("sub SKB_FCLONE_ORIG () { 1; }") unless defined(&SKB_FCLONE_ORIG);
    eval("sub SKB_FCLONE_CLONE () { 2; }") unless defined(&SKB_FCLONE_CLONE);
    if(defined(&CONFIG_NETFILTER)) {
	if(defined( &CONFIG_NF_CONNTRACK) || defined( &CONFIG_NF_CONNTRACK_MODULE)) {
	}
	if(defined(&CONFIG_BRIDGE_NETFILTER)) {
	}
    }
    if(defined(&CONFIG_NET_SCHED)) {
	if(defined(&CONFIG_NET_CLS_ACT)) {
	}
    }
    if(defined(&__KERNEL__)) {
	require 'linux/slab.ph';
	require 'asm/system.ph';
	eval 'sub sk_buff {
	    eval q(* &alloc_skb(my $size,  &gfp_t  &priority) {  &__alloc_skb( $size,  &priority, 0); });
	}' unless defined(&sk_buff);
	eval 'sub sk_buff {
	    eval q(* &alloc_skb_fclone(my $size,  &gfp_t  &priority) {  &__alloc_skb( $size,  &priority, 1); });
	}' unless defined(&sk_buff);
	eval 'sub dev_kfree_skb {
	    my($a) = @_;
    	    eval q( &kfree_skb($a));
	}' unless defined(&dev_kfree_skb);
	eval 'sub skb_truesize_check {
	    my($skb) = @_;
    	    eval q({  &if ( &unlikely( ($skb->{truesize}) < $sizeof{\'struct sk_buff\'} +  ($skb->{len})))  &skb_truesize_bug($skb); });
	}' unless defined(&skb_truesize_check);
	eval 'sub skb_shinfo {
	    my($SKB) = @_;
    	    eval q(((($SKB)-> &end)));
	}' unless defined(&skb_shinfo);
	eval 'sub skb_queue_head_init {
	    my($list) = @_;
    	    eval q({  &spin_lock_init( ($list->{lock}));  ($list->{prev}) =  ($list->{next}) = $list;  ($list->{qlen}) = 0; });
	}' unless defined(&skb_queue_head_init);
	eval 'sub __skb_queue_head {
	    my($list,$newsk) = @_;
    	    eval q({  &__skb_queue_after($list, $list, $newsk); });
	}' unless defined(&__skb_queue_head);
	eval 'sub __skb_queue_tail {
	    my($list,$newsk) = @_;
    	    eval q({ \'struct sk_buff\' * &prev, * &next;  ($list->{qlen})++;  &next = $list;  &prev =  ($next->{prev});  ($newsk->{next}) =  &next;  ($newsk->{prev}) =  &prev;  ($next->{prev})  =  ($prev->{next}) = $newsk; });
	}' unless defined(&__skb_queue_tail);
	eval 'sub sk_buff {
	    eval q(* &__skb_dequeue(\'struct sk_buff_head\' * &list) { \'struct sk_buff\' * &next, * &prev, * &result;  &prev =   &list;  &next =  ($prev->{next});  &result =  &NULL;  &if ( &next !=  &prev) {  &result =  &next;  &next =  ($next->{next});  ($list->{qlen})--;  ($next->{prev})  =  &prev;  ($prev->{next})  =  &next;  ($result->{next}) =  ($result->{prev}) =  &NULL; }  &result; });
	}' unless defined(&sk_buff);
	eval 'sub __skb_insert {
	    my($newsk,$prev,$next,$list) = @_;
    	    eval q({  ($newsk->{next}) = $next;  ($newsk->{prev}) = $prev;  ($next->{prev})  =  ($prev->{next}) = $newsk;  ($list->{qlen})++; });
	}' unless defined(&__skb_insert);
	eval 'sub __skb_append {
	    my($old,$newsk,$list) = @_;
    	    eval q({  &__skb_insert($newsk, $old,  ($old->{next}), $list); });
	}' unless defined(&__skb_append);
	eval 'sub __skb_unlink {
	    my($skb,$list) = @_;
    	    eval q({ \'struct sk_buff\' * &next, * &prev;  ($list->{qlen})--;  &next =  ($skb->{next});  &prev =  ($skb->{prev});  ($skb->{next})  =  ($skb->{prev}) =  &NULL;  ($next->{prev}) =  &prev;  ($prev->{next}) =  &next; });
	}' unless defined(&__skb_unlink);
	eval 'sub sk_buff {
	    eval q(* &__skb_dequeue_tail(\'struct sk_buff_head\' * &list) { \'struct sk_buff\' * &skb =  &skb_peek_tail( &list);  &if ( &skb)  &__skb_unlink( &skb,  &list);  &skb; });
	}' unless defined(&sk_buff);
	eval 'sub skb_is_nonlinear {
	    my($skb) = @_;
    	    eval q({  ($skb->{data_len}); });
	}' unless defined(&skb_is_nonlinear);
	eval 'sub skb_headlen {
	    my($skb) = @_;
    	    eval q({  ($skb->{len}) -  ($skb->{data_len}); });
	}' unless defined(&skb_headlen);
	eval 'sub skb_pagelen {
	    my($skb) = @_;
    	    eval q({ \'int\'  &i,  &len = 0;  &for ( &i =  &skb_shinfo($skb)-> &nr_frags - 1;  &i >= 0;  &i--)  &len +=  &skb_shinfo($skb)-> ($frags[&i]->{size});  &len +  &skb_headlen($skb); });
	}' unless defined(&skb_pagelen);
	eval 'sub skb_fill_page_desc {
	    my($skb,$i,$page,$off,$size) = @_;
    	    eval q({  &skb_frag_t * &frag =  &skb_shinfo($skb)-> $frags[$i];  ($frag->{page})	 = $page;  ($frag->{page_offset})	 = $off;  ($frag->{s$ize})	 = $size;  &skb_shinfo($skb)-> &nr_frags = $i + 1; });
	}' unless defined(&skb_fill_page_desc);
	eval 'sub SKB_PAGE_ASSERT {
	    my($skb) = @_;
    	    eval q( &BUG_ON( &skb_shinfo($skb)-> &nr_frags));
	}' unless defined(&SKB_PAGE_ASSERT);
	eval 'sub SKB_FRAG_ASSERT {
	    my($skb) = @_;
    	    eval q( &BUG_ON( &skb_shinfo($skb)-> &frag_list));
	}' unless defined(&SKB_FRAG_ASSERT);
	eval 'sub SKB_LINEAR_ASSERT {
	    my($skb) = @_;
    	    eval q( &BUG_ON( &skb_is_nonlinear($skb)));
	}' unless defined(&SKB_LINEAR_ASSERT);
	eval 'sub char {
	    eval q(* &__skb_push(\'struct sk_buff\' * &skb, my $len) {  ($skb->{data}) -=  $len;  ($skb->{len})  +=  $len;  ($skb->{data}); });
	}' unless defined(&char);
	eval 'sub char {
	    eval q(* &__skb_pull(\'struct sk_buff\' * &skb, my $len) {  ($skb->{len}) -=  $len;  &BUG_ON( ($skb->{len}) <  ($skb->{data_len}));  ($skb->{data}) +=  $len; });
	}' unless defined(&char);
	eval 'sub char {
	    eval q(* &__pskb_pull(\'struct sk_buff\' * &skb, my $len) {  &if ( $len >  &skb_headlen( &skb)  && ! &__pskb_pull_tail( &skb,  $len- &skb_headlen( &skb)))  &NULL;  ($skb->{len}) -=  $len;  ($skb->{data}) +=  $len; });
	}' unless defined(&char);
	eval 'sub char {
	    eval q(* &pskb_pull(\'struct sk_buff\' * &skb, my $len) {  &unlikely( $len >  ($skb->{len})) ?  &NULL :  &__pskb_pull( &skb,  $len); });
	}' unless defined(&char);
	eval 'sub pskb_may_pull {
	    my($skb,$len) = @_;
    	    eval q({  &if ( &likely($len <=  &skb_headlen($skb))) 1;  &if ( &unlikely($len >  ($skb->{len}))) 0;  &__pskb_pull_tail($skb, $len- &skb_headlen($skb)) !=  &NULL; });
	}' unless defined(&pskb_may_pull);
	unless(defined(&NET_IP_ALIGN)) {
	    eval 'sub NET_IP_ALIGN () {2;}' unless defined(&NET_IP_ALIGN);
	}
	unless(defined(&NET_SKB_PAD)) {
	    eval 'sub NET_SKB_PAD () {16;}' unless defined(&NET_SKB_PAD);
	}
	eval 'sub __skb_trim {
	    my($skb,$len) = @_;
    	    eval q({  &if (! ($skb->{data_len})) {  ($skb->{len})  = $len;  ($skb->{tail}) =  ($skb->{data}) + $len; }  &else  &___pskb_trim($skb, $len, 0); });
	}' unless defined(&__skb_trim);
	eval 'sub __pskb_trim {
	    my($skb,$len) = @_;
    	    eval q({  &if (! ($skb->{data_len})) {  ($skb->{len})  = $len;  ($skb->{tail}) =  ($skb->{data})+$len; 0; }  &___pskb_trim($skb, $len, 1); });
	}' unless defined(&__pskb_trim);
	eval 'sub pskb_trim {
	    my($skb,$len) = @_;
    	    eval q({ ($len <  ($skb->{len})) ?  &__pskb_trim($skb, $len) : 0; });
	}' unless defined(&pskb_trim);
	eval 'sub __skb_queue_purge {
	    my($list) = @_;
    	    eval q({ \'struct sk_buff\' * &skb;  &while (( &skb =  &__skb_dequeue($list)) !=  &NULL)  &kfree_skb( &skb); });
	}' unless defined(&__skb_queue_purge);
	unless(defined(&CONFIG_HAVE_ARCH_DEV_ALLOC_SKB)) {
	} else {
	}
	eval 'sub skb_add_data {
	    my($skb,$from,$copy) = @_;
    	    eval q({  &const \'int\'  &off =  ($skb->{len});  &if ( ($skb->{ip_summed}) ==  &CHECKSUM_NONE) { \'int\'  &err = 0; my $csum =  &csum_and_copy_from_user($from,  &skb_put($skb, $copy), $copy, 0,  &err);  &if (! &err) {  ($skb->{csum}) =  &csum_block_add( ($skb->{csum}),  $csum,  &off); 0; } }  &else  &if (! &copy_from_user( &skb_put($skb, $copy), $from, $copy)) 0;  &__skb_trim($skb,  &off); - &EFAULT; });
	}' unless defined(&skb_add_data);
	eval 'sub skb_can_coalesce {
	    my($skb,$i,$page,$off) = @_;
    	    eval q({  &if ($i) { \'struct skb_frag_struct\' * &frag =  &skb_shinfo($skb)-> $frags[$i - 1]; $page ==  ($frag->{page})  && $off ==  ($frag->{page_offset}) +  ($frag->{s$ize}); } 0; });
	}' unless defined(&skb_can_coalesce);
	eval 'sub skb_linearize {
	    my($skb,$gfp) = @_;
    	    eval q({  &__skb_linearize($skb, $gfp); });
	}' unless defined(&skb_linearize);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub void {
	    eval q(* &kmap_skb_frag( &const  &skb_frag_t * &frag) {  &kmap_atomic( ($frag->{page}),  &KM_SKB_DATA_SOFTIRQ); });
	}' unless defined(&void);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub kunmap_skb_frag {
	    my($vaddr) = @_;
    	    eval q({  &kunmap_atomic($vaddr,  &KM_SKB_DATA_SOFTIRQ); });
	}' unless defined(&kunmap_skb_frag);
	eval 'sub skb_queue_walk {
	    my($queue, $skb) = @_;
    	    eval q( &for ($skb = ($queue)-> &next;  &prefetch( ($skb->{next})), ($skb != ($queue)); $skb =  ($skb->{next})));
	}' unless defined(&skb_queue_walk);
	eval 'sub skb_queue_reverse_walk {
	    my($queue, $skb) = @_;
    	    eval q( &for ($skb = ($queue)-> &prev;  &prefetch( ($skb->{prev})), ($skb != ($queue)); $skb =  ($skb->{prev})));
	}' unless defined(&skb_queue_reverse_walk);
	eval 'sub void {
	    eval q(* &skb_header_pointer( &const \'struct sk_buff\' * &skb, \'int\'  &offset, \'int\'  &len,  &void * &buffer) { \'int\'  &hlen =  &skb_headlen( &skb);  &if ( &hlen -  &offset >=  &len)  ($skb->{data}) +  &offset;  &if ( &skb_copy_bits( &skb,  &offset,  &buffer,  &len) < 0)  &NULL;  &buffer; });
	}' unless defined(&void);
	if(defined(&CONFIG_NETFILTER)) {
	    eval 'sub nf_conntrack_put {
	        my($nfct) = @_;
    		eval q({  &if ($nfct  &&  &atomic_dec_and_test( ($nfct->{use})))  ($nfct->{destroy})($nfct); });
	    }' unless defined(&nf_conntrack_put);
	    eval 'sub nf_conntrack_get {
	        my($nfct) = @_;
    		eval q({  &if ($nfct)  &atomic_inc( ($nfct->{use})); });
	    }' unless defined(&nf_conntrack_get);
	    if(defined( &CONFIG_NF_CONNTRACK) || defined( &CONFIG_NF_CONNTRACK_MODULE)) {
		eval 'sub nf_conntrack_get_reasm {
		    my($skb) = @_;
    		    eval q({  &if ($skb)  &atomic_inc( ($skb->{users})); });
		}' unless defined(&nf_conntrack_get_reasm);
		eval 'sub nf_conntrack_put_reasm {
		    my($skb) = @_;
    		    eval q({  &if ($skb)  &kfree_skb($skb); });
		}' unless defined(&nf_conntrack_put_reasm);
	    }
	    if(defined(&CONFIG_BRIDGE_NETFILTER)) {
		eval 'sub nf_bridge_put {
		    my($nf_bridge) = @_;
    		    eval q({  &if ($nf_bridge  &&  &atomic_dec_and_test( ($nf_bridge->{use})))  &kfree($nf_bridge); });
		}' unless defined(&nf_bridge_put);
		eval 'sub nf_bridge_get {
		    my($nf_bridge) = @_;
    		    eval q({  &if ($nf_bridge)  &atomic_inc( ($nf_bridge->{use})); });
		}' unless defined(&nf_bridge_get);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub nf_reset {
	        my($skb) = @_;
    		eval q({  &nf_conntrack_put( ($skb->{nfct}));  ($skb->{nfct}) =  &NULL; });
	    }' unless defined(&nf_reset);
	} else {
	}
    }
}
1;
