# Copyright 1999-2010 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/games-arcade/jvgs/jvgs-0.5.ebuild,v 1.3 2010/07/07 14:42:48 phajdan.jr Exp $

EAPI=2
CMAKE_IN_SOURCE_BUILD=1
inherit cmake-utils eutils games

DESCRIPTION="An open-source platform game with a sketched and minimalistic look"
HOMEPAGE="http://jvgs.sourceforge.net/"
SRC_URI="mirror://sourceforge/jvgs/${P}-src.tar.gz"

LICENSE="WTFPL-2"
SLOT="0"
KEYWORDS="amd64 x86"
IUSE=""

RDEPEND="virtual/opengl
	dev-lang/lua
	sys-libs/zlib
	media-libs/libsdl[video]
	media-libs/sdl-mixer[vorbis]
	media-libs/freetype:2"
DEPEND="${RDEPEND}
	dev-lang/swig"

S=${WORKDIR}/${P}-src

src_configure() {
	cmake-utils_src_configure
}

src_compile() {
	cmake-utils_src_compile
}

src_install() {
	exeinto "$(games_get_libdir)"
	doexe src/${PN} || die

	insinto "${GAMES_DATADIR}"/${PN}
	doins -r main.lua resources || die

	games_make_wrapper ${PN} "/$(games_get_libdir)/${PN}" \
		"${GAMES_DATADIR}/${PN}"

	newicon resources/drawing.svg ${PN}.svg
	make_desktop_entry ${PN} ${PN}

	dodoc AUTHORS README.markdown

	prepgamesdirs
}
