# Copyright 1999-2010 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-libs/libmatroska/libmatroska-0.9.0.ebuild,v 1.6 2010/10/15 21:41:12 ranger Exp $

EAPI="2"

inherit flag-o-matic eutils toolchain-funcs

DESCRIPTION="Extensible multimedia container format based on EBML"
HOMEPAGE="http://www.matroska.org/"
SRC_URI="http://www.bunkus.org/videotools/mkvtoolnix/sources/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 ~arm ~ia64 ppc ~ppc64 ~sparc x86 ~x86-fbsd"
IUSE=""

DEPEND=">=dev-libs/libebml-0.8.0
	<dev-libs/libebml-1.0.0"

src_prepare() {
	epatch "${FILESDIR}/${P}-respectflags.patch"
}

src_compile() {
	cd "${S}/make/linux"

	#fixes locale for gcc3.4.0 to close bug 52385
	append-flags $(test-flags -finput-charset=ISO8859-15)

	emake PREFIX=/usr \
		LIBEBML_INCLUDE_DIR=/usr/include/ebml \
		LIBEBML_LIB_DIR=/usr/$(get_libdir) \
		CXX="$(tc-getCXX)" || die "make failed"
}

src_install() {
	cd "${S}/make/linux"

	emake prefix="${D}/usr" libdir="${D}/usr/$(get_libdir)" install || die "make install failed"
	dodoc "${S}/ChangeLog"
}
