#include "defs.h"

BOOLEAN convert_command_link(char *link);
BOOLEAN convert_remote_command(int type, char *lname);
/*
 *  command types:
 *    !TELNET@host -user=xxxxxxxx -passwd=xxxxxxxx      : telnet
 *    !RLOGIN@host -user=xxxxxxxx -passwd=xxxxxxxx      : rlogin
 *    ![command]@host -user=xxxxxxxx -passwd=xxxxxxxx   : rexec
 *    ![port]@host -user=xxxxxxxx -passwd=xxxxxxxx      : emulator
 *    !command						: local command
 */

BOOLEAN convert_command_link(char *link)
{
    char Itemp[11];    
    char *tmptr;
    char *tmpfile;

	/* first check if it contains RLOGIN or TELNET or TN3270 */
	if((tmptr = strstr(link, "RLOGIN")) != NULL) {
	    /* add an '@' to make is conform to parsing routine */
	    *(tmptr+6) = '@';
	    convert_remote_command(RLOGIN, link);
	    return(FALSE);  /* no new file */
	} else if((tmptr = strstr(link, "TELNET")) != NULL) {
	    /* add an '@' to make is conform to parsing routine */
	    *(tmptr+6) = '@';
	    convert_remote_command(TELNET, link);
	    return(FALSE);  /* no new file */
	} else if((tmptr = strstr(link, "TN3270")) != NULL) {
	    /* add an '@' to make is conform to parsing routine */
	    *(tmptr+6) = '@';
	    convert_remote_command(TN3270, link);
	    return(FALSE);  /* no new file */
	}

	printf("<A>");  /* not able to handle emulated links */

}

BOOLEAN convert_remote_command(int type, char *lname)
{
	/* parse a line that looks like this 
	 *	!command@host [-user=USER] [-password=PASSWORD]
	 *	!TELNET@host [port] [-user=USER]
	 *	!TN3270@host [port] [-user=USER]
	 *	!RLOGIN@host [-user=USER]
	 * and make it look like a normal rsh or rexec
	 * currently does not support password option on RLOGIN
	 */

	BOOLEAN flag=FALSE;
	int count;
	char *x;
	char *tmptr;
	char *host;
	char *user;
	char *disp;
	char command[MAXCOMMAND];
	char rcommand[MAXCOMMAND];
	char *password;
	char *blank="";
	char port[8];
	char *tmpfile;
	
	/* initialize */
	password = NULL;
	user = NULL;

	/* kill any extra spaces at the end */
	tmptr = &lname[strlen(lname)];
	while(*(tmptr-1)==' ') tmptr--;
	*tmptr = '\0';

	/* strip all the slashes */
	tmptr=lname;
	for(x=lname; *x != '\0' ;x++)
	  if(*x != '\\') {
	   *tmptr = *x;    /* don't print slashes */
	   tmptr++;
	  }
	  else if(*(x+1) == '\\') {
	   *tmptr = *x;  /* print one slash if there are two */
	   tmptr++;
	  }
	*tmptr = '\0';

	/* get host name */
	tmptr = strchr(lname,'@');
	*tmptr = '\0';
	host = tmptr+1;


	if((user = strstr(host,"-user")) != NULL) {
	    *user = '\0';
	    /* get rid of preceding spaces */
	    tmptr = user;
	    while(isspace(*(tmptr-1)))
		tmptr--;
	    *tmptr = '\0';
 
	    user++;
	    if((tmptr = strchr(user,'=')) != NULL &&
		(!strchr(user,' ') || strchr(user,' ') > tmptr)) {
		user = tmptr+1;
		while(isspace(*user))
		    user++;
	    } else {
		user += 4;
		while(isspace(*user))
		    user++;
	    }
	}


	if((password = strstr(host,"-password")) != NULL ||
	   (user != NULL && (password = strstr(user,"-password")) != NULL)) {
	    *password = '\0';  
	    /* get rid of preceding spaces */
	    tmptr = password;
	    while(isspace(*(tmptr-1)))
		tmptr--;
	    *tmptr = '\0';

	    password++;
	    if((tmptr = strchr(password,'=')) != NULL) {
		password = tmptr+1;
		while(isspace(*password))
		    password++;
	    } else {
		password += 8;
		while(isspace(*password))
		    password++;
	    }
	}

	/* get port number if there is one */
	if((tmptr = strchr(host,' ')) != NULL) {
	    *tmptr = '\0';
	    tmptr++;
	    for(count=0;count<8 && isdigit(*tmptr);tmptr++,count++)
		port[count]= *tmptr;
	    port[count] = '\0';
	} else
	    port[0] = '\0';

	switch(type) {
	case REXEC_T:
	    printf("<A>");
	    break;
	case TELNET:
	    if(*port != '\0')
	        printf("<A HREF=\"telnet://%s:%s/\">",host, port);
	    else 
	        printf("<A HREF=\"telnet://%s/\">",host);
	    break;
	case TN3270:
	    if(*port != '\0')
	        printf("<A HREF=\"tn3270://%s:%s/\">",host, port);
	    else 
	        printf("<A HREF=\"tn3270://%s/\">",host);
	    break;
	case RLOGIN:
	    if(user == NULL) {
	        if(*port != '\0')
	            printf("<A HREF=\"rlogin://%s:%s/\">",host, port);
	        else 
	            printf("<A HREF=\"rlogin://%s/\">",host);
	    } else {
	        if(*port != '\0')
	            printf("<A HREF=\"rlogin://%s@%s:%s/\">",user, host, port);
	        else 
	            printf("<A HREF=\"rlogin://%s@%s/\">",user ,host);
	    }
	    break;
	} /* end switch */
	   

}
