#include "defs.h"

void convert_gopher_link(char *link)
{
     char gopher_file_type;
     char tmpport[8];
     char path[MAXFNAME];
     char host[80];
     char gopher_info[83];
     char *cp, *cp2, *buf, *buf2;
     int port;

	/*
	 *  link should look like:
	 *	'filetype' '-' 'gopher_path' '@' 'host' ' ' 'port'
	 *         1-1/path/name@ukanhost.cc.edu 70 
	 *
	 *     or  FORM@form_server
	 */

	/* if it doesn't fit the mold, try adding 0-0/ to the front */
	if(link[1] != '-' && !isdigit(link[0])) {
	    /* use path as temporary string */
	    strcpy(path,link);
	    sprintf(link,"0-0/%s",path);
	}

        gopher_file_type = link[0];

	/* link has structure [type]-[path]@[host]   */
	cp = link+2;
	/* parse path from link */
	for (buf=path; *cp != '@' || *(cp-1) == '\\'; cp++)  {
	    if(*cp != '\\' || (*cp=='\\' && *(cp+1)=='\\')) {
		if(*cp == ' ') {
		    strcpy(buf,"%20");  /* replace spaces with %20 */
		    buf += 2;
		} else
	            *buf = *cp;
	        buf++;
	    }
	}
	*buf = '\0';

	/* parse host from link after @ */
	cp++; /* go past the @ */
	for (buf=host; *cp != '\0' && *cp != ' ' ; cp++) {
	    *buf = *cp;
	    buf++;
	}
	*buf = '\0';
	
	/* parse port from link after @ and host name */
     if(*cp == ' ') { /* if there is the space for the port */
	cp++; /* go past the space */ 
	for (buf=tmpport; *cp != '\0'; cp++) {
	    *buf = *cp;
	    buf++;
        }
	*buf = '\0';
        port = atoi(tmpport);
	if(port == 0) port=70;
     } else
	port = 70;


	printf("<A HREF=\"gopher://%s:%d/%c%s\">",host, port, gopher_file_type,
							path);
			

} /* big end */
