#include "defs.h"

char *mystrstr(char *chptr, char *tarptr);
char *altstrstr(char *chptr, char *tarptr);
/*
 * mystrstr will find the first occurence of the string pointed to by tarptr
 * in the string pointed to by chptr.  It ignores text between link delimiters.
 * It is also a case insensitive search.
 */
char *mystrstr(char *chptr, char *tarptr)
{
    char *tmpchptr, *tmptarptr;
    BOOLEAN flag=FALSE;

    for(; *chptr != '\0'; chptr++) {
	if(*chptr == delimiter.link) {
	    for(tmpchptr = chptr+1; *tmpchptr != delimiter.link &&
	        *tmpchptr != delimiter.end_link && *tmpchptr != '\0';
		tmpchptr++)
		    ; /*null body*/
	    if(*tmpchptr == delimiter.end_link)
		chptr = tmpchptr;
	}

	if(*chptr==delimiter.target[0] && *(chptr+1)==delimiter.target[1]) {
	    for(tmpchptr = chptr+2; *tmpchptr != delimiter.end_target[1] &&
	        *tmpchptr != '\0'; tmpchptr++)
		    ; /*null body*/
	    if(*tmpchptr == delimiter.end_target[1])
		chptr = tmpchptr;
	}

	if(toupper(*chptr) == toupper(*tarptr)) {	
	    /* see if they line up */ 
	    for(tmpchptr = chptr+1, tmptarptr = tarptr+1;
	         toupper(*tmpchptr) == toupper(*tmptarptr)
		 && *tmptarptr != '\0' && *tmpchptr != '\0';
	        *tmpchptr++, *tmptarptr++)
		   ; /* null body */ 
	    if(*tmptarptr == '\0') {
		flag = TRUE;
	  	break;
	    }
	}

    } /* end for */

    if(flag)
	return(chptr);
    /*else*/
	return(NULL);

}	


/*
 * altstrstr will find the first occurence of the string pointed to by tarptr
 * in the string pointed to by chptr.  It only searches hidden targets
 * and is case sensitive
 */
char *altstrstr(char *chptr, char *tarptr)
{
    char *tmpchptr, *tmptarptr;
    BOOLEAN flag=FALSE;

    for(; *chptr != '\0' && flag == FALSE; chptr++) {
	if(*chptr==delimiter.target[0] && *(chptr+1)==delimiter.target[1]) {
	    for(; *chptr != delimiter.end_target[1] &&
	        *chptr != '\0'; chptr++) {

	        if(*chptr == *tarptr) {	
	            /* see if they line up */ 
	            for(tmpchptr = chptr+1, tmptarptr = tarptr+1;
	                 *tmpchptr == *tmptarptr
		         && *tmptarptr != '\0' && *tmpchptr != '\0';
	                *tmpchptr++, *tmptarptr++)
		           ; /* null body */ 
	            if(*tmptarptr == '\0') {
		        flag = TRUE;
	  	        break;
	            }
	        }
	    }
	}

    } /* end for */

    if(flag)
	return(chptr);
    /*else*/
	return(NULL);
}	
