#include <Python.h>
#include <zvt/zvtterm.h>

/* -- stuff imported from other modules -- */
typedef struct {
    PyObject_HEAD
    GtkObject *obj;
} PyGtk_Object;
static PyTypeObject *PyGtk_Type;

typedef struct {
    PyObject_HEAD
    GdkFont *obj;
} PyGdkFont_Object;
static PyTypeObject *PyGdkFont_Type;

#define PyGtk_Check(v) ((v)->ob_type == PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)

static PyObject *(*PyGtk_New)(GtkObject *)=0;
static PyObject *(*PyGdkFont_New)(GdkFont *)=0;

/* -- now on to _zvtmodule stuff -- */
static PyObject *_wrap_zvt_term_feed(PyObject *self, PyObject *args) {
  PyObject *term;
  char *text;
  int len;

  if (!PyArg_ParseTuple(args, "O!s#:zvt_term_feed", PyGtk_Type, &term,
			&text, &len))
    return NULL;
  zvt_term_feed(ZVT_TERM(PyGtk_Get(term)), text, len);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *_wrap_zvt_term_set_color_scheme(PyObject *self, PyObject *args) {
  PyObject *term, *colours, *item;
  gushort red[18], grn[18], blu[18];
  int i;

  if (!PyArg_ParseTuple(args, "O!O!:zvt_term_set_color_scheme", PyGtk_Type,
			&term, &PyList_Type, &colours))
    return NULL;
  if (PyList_Size(colours) < 18) {
    PyErr_SetString(PyExc_TypeError, "list must be 18 elements long");
    return NULL;
  }
  for (i = 0; i < 18; i++) {
    item = PyList_GetItem(colours, i);
    if (!PyArg_ParseTuple(PyList_GetItem(colours, i), "(hhh)",
			  &red[i], &grn[i], &blu[i])) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError,"list items must be like (int,int,int)");
      return NULL;
    }
  }
  zvt_term_set_color_scheme(ZVT_TERM(PyGtk_Get(term)), red, grn, blu);
  Py_INCREF(Py_None);
  return Py_None;
}

#include "zvtmodule_impl.c"

static PyMethodDef zvtMethods[] = {
    { "zvt_term_feed", _wrap_zvt_term_feed, 1 },
    { "zvt_term_set_color_scheme", _wrap_zvt_term_set_color_scheme, 1 },
#include "zvtmodule_defs.c"
    { NULL, NULL, 0 }
};

void init_zvt() {
    PyObject *m, *d;

    m = Py_InitModule("_zvt", zvtMethods);

    m = PyImport_ImportModule("_gtk");
    d = PyModule_GetDict(m);
    Py_DECREF(m);

    PyGtk_Type = (PyTypeObject *)PyDict_GetItemString(d, "GtkObjectType");
    Py_INCREF(PyGtk_Type);
    PyGdkFont_Type = (PyTypeObject *)PyDict_GetItemString(d, "GdkFontType");
    Py_INCREF(PyGdkFont_Type);

    d = PyDict_GetItemString(d, "_private");
    PyGtk_New = PyCObject_AsVoidPtr(PyDict_GetItemString(d, "PyGtk_New"));
    PyGdkFont_New = PyCObject_AsVoidPtr(PyDict_GetItemString(d,
							     "PyGdkFont_New"));

    if (PyErr_Occurred())
        Py_FatalError("can't initialise module _zvt");
}

