%define py_prefix   /usr
%define py_ver      1.5
%define pygtk_ver   0.6.4
%define pygnome_ver 1.0.51

Summary: The sources for the PyGTK and PyGNOME Python extension modules.
Name: gnome-python
Version: %{pygnome_ver}
Release: 1
Source: gnome-python-%{pygnome_ver}.tar.gz
Copyright: LGPL
Group: System Environment/Libraries
BuildRoot: /var/tmp/gnome-python-root
Packager: James Henstridge <james@daa.com.au>

%description
The gnome-python package contains the source packages for the Python
bindings for GTK+ and GNOME (PyGTK and PyGNOME, respectively). 

PyGTK is an extension module for Python that provides access to the
GTK+ widget set. Just about anything (within reason) you can write in
C with GTK+, you can write in Python with PyGTK, but with all of
Python's benefits.

PyGNOME is an extension module for Python that provides access to the
base GNOME libraries, so you have access to more widgets, a simple
configuration interface, and metadata support.

%package -n pygtk
Version: %{pygtk_ver}
Summary: Python bindings for the GTK+ widget set.
Group: Development/Languages
Requires: glib, gtk+, imlib, python >= 1.5.2

%description -n pygtk
PyGTK is an extension module for Python that gives you access to the
GTK+ widget set.  Just about anything you can write in C with GTK+ you
can write in Python with PyGTK (within reason), but with all of
Python's benefits. PyGTK provides an object-oriented interface at a
slightly higher level than the C interface. The PyGTK interface does
all of the type casting and reference counting that you'd have to do
yourself using the C API.

Install pygtk if you need Python bindings for the GTK+ widget set.

%package -n pygtk-libglade
Version: %{pygtk_ver}
Summary: A wrapper for the libglade library for use with PyGTK
Group: Development/Languages

%description -n pygtk-libglade
This module contains a wrapper for the libglade library.  Libglade is a
library similar to the pyglade module, except that it is written in C (so
is faster) and is more complete.

%package -n pygnome-libglade
Version: %{pygtk_ver}
Summary: GNOME support for the libglade python wrapper
Group: Development/Languages
Requires: pygtk-libglade

%description -n pygnome-libglade
This module contains GNOME support to suppliment the libglade python
wrapper.  Libglade is a library similar to the pyglade module, except
that it is written in C (so is faster) and is more complete.

%package -n pygnome
Version: %{pygnome_ver}
Summary: Python bindings for the GNOME libraries.
Group: Development/Languages
Requires: pygtk = %{pygtk_ver}
Requires: gnome-libs

%description -n pygnome
PyGNOME is an extension module for python that gives you access to the
base GNOME libraries.  This means you have access to more widgets, simple
configuration interface, metadata support and many other features.

Install pygnome if you need Python bindings for the GNOME libraries.

%package -n pygnome-applet
Version: %{pygnome_ver}
Summary: Python bindings for GNOME Panel applets.
Group: Development/Languages
Requires: pygnome = %{pygnome_ver}

%description -n pygnome-applet
This module contains a wrapper that allows GNOME Panel applets to be
written in Python.

%package -n pygnome-capplet
Version: %{pygnome_ver}
Summary: Python bindings for GNOME Panel applets.
Group: Development/Languages
Requires: pygnome = %{pygnome_ver}

%description -n pygnome-capplet
This module contains a wrapper that allows GNOME Control Center
capplets to be in Python.

%prep
%setup
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{py_prefix}

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%files -n pygtk
%{py_prefix}/lib/python%{py_ver}/site-packages/gtk.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/Gtkinter.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GtkExtra.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GTK.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GDK.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/GdkImlib.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/pyglade/*.py*

%{py_prefix}/lib/python%{py_ver}/site-packages/_gtkmodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_gdkimlibmodule.so

%{py_prefix}/include/pygtk

%doc pygtk/AUTHORS pygtk/NEWS pygtk/README pygtk/MAPPING pygtk/ChangeLog
%doc pygtk/description.py pygtk/examples

%files -n pygtk-libglade
%{py_prefix}/lib/python%{py_ver}/site-packages/libglade.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/_libglademodule.so

%files -n pygnome-libglade
%{py_prefix}/lib/python%{py_ver}/site-packages/_gladegnomemodule.so

# the following are only included if gnome-core and control-center were
# installed during the build
%files -n pygnome-applet
%{py_prefix}/lib/python%{py_ver}/site-packages/_appletmodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/applet.py*

%files -n pygnome-capplet
%{py_prefix}/lib/python%{py_ver}/site-packages/_cappletmodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/capplet.py*

%files -n pygnome
%{py_prefix}/lib/python%{py_ver}/site-packages/gettext.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/__init__.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/affine.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/config.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/file.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/help.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/history.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/metadata.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/mime.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/score.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/triggers.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/ui.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/uiconsts.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/url.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/xmhtml.py*
%{py_prefix}/lib/python%{py_ver}/site-packages/gnome/zvt.py*

%{py_prefix}/lib/python%{py_ver}/site-packages/_gnomemodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_gnomeuimodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_zvtmodule.so
%{py_prefix}/lib/python%{py_ver}/site-packages/_gtkxmhtmlmodule.so

%doc AUTHORS NEWS README ChangeLog
%doc pygnome/examples

%changelog
* Fri Jan 21 2000 Matt Wilson <msw@redhat.com>
- added pygnome-libglade subpackage

* Wed Jan  5 2000 Matt Wilson <msw@redhat.com>
- split applet and capplet modules into their own package
