/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
*/

package org.gnu.glib;

/**
 * Base class for all classes resulting from a <code>define-boxed</code>
 * in a <code>.defs</code> file.
 */
public class Boxed {
	/** holder for the raw GLib/GTK pointer */
	protected int handle;

	/**
	 * This class is only instantiable via subclasses.
	 */
	protected Boxed() {
		// nothing to do
	}

	/**
	 * Get the raw handle value.
	 * @return the handle value.
	 */
	public final int getHandle() {
		return handle;
	}

	public boolean equals(Boxed other){
		return handle == other.getHandle();
	}
}
