/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:41 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.gdk.Pixbuf;

/**
 * A {@link CellRenderer} for pixbufs.
 */
public class CellRendererPixbuf extends CellRenderer 
{
	/** 
	 * Creates a new CellRendererPixbuf
	 */
	public CellRendererPixbuf(){
		handle = gtk_cell_renderer_pixbuf_new ();
	}

	/**
	 * Attributes for the CellRenderer
	 */
	public static class Attribute extends CellRendererAttribute{
		private Attribute(String attr){
			super(attr);
		}
		public static final Attribute PIXBUF = new Attribute("pixbuf");
		public static final Attribute PIXBUF_EXPANDER_OPEN = new Attribute("pixbuf-expander-open");
		public static final Attribute PIXBUF_EXPANDER_CLOSED = new Attribute("pixbuf-expander-closed");
		
	}

	/**
	 */
	public void setPixbuf(Pixbuf pixbuf){
		gtk_setPixbuf(handle, pixbuf.getHandle());
	}
	native static final protected int gtk_setPixbuf(int cr, int pixbuf);

	/**
	 */
	public void setPixbufExpanderOpen(Pixbuf pixbuf){
		gtk_setPixbufOpen(handle, pixbuf.getHandle());
	}
	native static final protected int gtk_setPixbufOpen(int cr, int pixbuf);
		

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_cell_renderer_pixbuf_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_cell_renderer_pixbuf_get_type ();
    native static final protected int gtk_cell_renderer_pixbuf_new ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

