/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.glib.GObject;

/**
 */
public class EntryCompletion extends GObject {

	public EntryCompletion() {
		if (-1 == handle) {
			handle = gtk_entry_completion_new();
		}
	}
	
	public EntryCompletion(int nativeHandle) {
		handle = nativeHandle;
	}
	
	public Entry getEntry() {
		return new Entry(gtk_entry_completion_get_entry(handle));
	}
	
	public void setModel(TreeModel model) {
		gtk_entry_completion_set_model(handle, model.getHandle());
	}
	
	public TreeModel getModel() {
		return new TreeModel(gtk_entry_completion_get_model(handle));
	}
	
	public void setMinimumKeyLength(int length) {
		gtk_entry_completion_set_minimum_key_length(handle, length);
	}
	
	public int getMinimumKeyLength() {
		return gtk_entry_completion_get_minimum_key_length(handle);
	}
	
	public void complete() {
		gtk_entry_completion_complete(handle);
	}
	
	public void insertActionText(int index, String text) {
		gtk_entry_completion_insert_action_text(handle, index, text);
	}
	
	public void insertActionMarkup(int index, String markup) {
		gtk_entry_completion_insert_action_markup(handle, index, markup);
	}
	
	public void deleteAction(int index) {
		gtk_entry_completion_delete_action(handle, index);
	}
	
	public void setTextColumn(int column) {
		gtk_entry_completion_set_text_column(handle, column);
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_entry_completion_get_type ();
	native static final protected int gtk_entry_completion_new();
	native static final protected int gtk_entry_completion_get_entry(int completion);
	native static final protected void gtk_entry_completion_set_model(int completion, int model);
	native static final protected int gtk_entry_completion_get_model(int completion);
	native static final protected void gtk_entry_completion_set_minimum_key_length(int completion, int length);
	native static final protected int gtk_entry_completion_get_minimum_key_length(int completion);
	native static final protected void gtk_entry_completion_complete(int completion);
	native static final protected void gtk_entry_completion_insert_action_text(int completion, int index, String text);
	native static final protected void gtk_entry_completion_insert_action_markup(int completion, int index, String markup);
	native static final protected void gtk_entry_completion_delete_action(int completion, int index);
	native static final protected void gtk_entry_completion_set_text_column(int completion,  int column);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
