/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:35 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This widget is a horizontal slot containing a slider that can be
 * moved by the mouse.  It is used to allow the user to select a value
 * using the horizontal slide.  
 */
public class HScale extends Scale 
{
	/**
	 * Creates a new HScale widget.
	 * @param adjustment The {@link Adjustment} which sets the range of the 
	 * scale.
	 */
	public HScale(Adjustment adjustment){
		handle = gtk_hscale_new(adjustment.getHandle());
		initializeEventHandlers();
	}

	/**
	 * Creates a new horizontal scale widget that lets the user input a number 
	 * between min and max (including min and max) with the increment step. 
	 * Step must be nonzero; it's the distance the slider moves when using the 
	 * arrow keys to adjust the scale value.
	 * @param min Minimum value
	 * @param max Maximum value
	 * @param step Step increment (tick size) used with keyboard shortcuts
	 */
	public HScale(double min, double max, double step){
		handle = gtk_hscale_new_with_range (min, max, step);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a HScale using a handle to a native resource.
	 */
	public HScale(int handle) {
	    super(handle);
	}

	protected void noopInit() {}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hscale_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_hscale_get_type ();
    native static final protected int gtk_hscale_new (int adjustment);
    native static final protected int gtk_hscale_new_with_range (double min, double max, double 
        step);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

