/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-09-28 10:15:52 BST
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.glib.Value;

/**
 * A generic tree interface for use with {@link TreeView} widgets. Internally,
 * the {@link TreeStore} and {@link ListStore} objects are constructed on top of
 * TreeModels. If you were using the C version of gtk, you would be able to
 * construct other objects like those (although I find no reason for doing so).
 * This object provides a number of useful methods which can be used with either
 * the TreeStore or ListStore. 
 * <p>For a full overview of the tree, list and table widgets, please see the
 * {@link TreeView} description.
 */
public class TreeModel extends GObject {

	/**
	 */
	protected TreeModel(int handle) {
		this.handle = handle;
	}

	protected TreeModel() {
	}

	/*
	 * TODO: Foreach function.
	 */

	/**
	 * Returns the number of data blocks supported by the model
	 */
	public int getDataBlockCount() {
		return gtk_tree_model_get_n_columns(handle);
	}

	/**
	 * Returns the type of the data block.
	 * @param index The index of the data block
	 */
	public org.gnu.glib.Type getType(int index) {
		return new org.gnu.glib.Type(gtk_tree_model_get_column_type(handle, index));
	}

	/**
	 * Returns a valid iterator pointing to <code>path</code>, or
	 * <code>null</code>/
	 */
	public TreeIter getIter(TreePath path) {
		if (gtk_tree_model_get_iterExists(handle, path.getHandle())) {
			return new TreeIter(gtk_tree_model_get_iterObj(handle, path.getHandle()));
		} else {
			return null;
		}
	}
	native static final protected boolean gtk_tree_model_get_iterExists(int treeModel, int path);
	native static final protected int gtk_tree_model_get_iterObj(int treeModel, int path);

	/**
	 * Returns a valid iterator pointing to the path represented by
	 * <code>pathString</code>, or returns <code>null</code> if the path is
	 * invalid.
	 */
	public TreeIter getIter(String pathString) {
		if (gtk_tree_model_get_iter_from_stringExists(handle, pathString)) {
			return new TreeIter(gtk_tree_model_get_iter_from_stringObj(handle, pathString));
		} else {
			return null;
		}
	}
	native static final protected boolean gtk_tree_model_get_iter_from_stringExists(int treeModel, String pathString);
	native static final protected int gtk_tree_model_get_iter_from_stringObj(int treeModel, String pathString);

	/**
	 * Returns the iterator at the start of the model (the one at the path "0"),
	 * or returns <code>null</code> if the tree is empty.
	 */
	public TreeIter getFirstIter() {
		if (gtk_tree_model_get_iter_firstExists(handle)) {
			return new TreeIter(gtk_tree_model_get_iter_firstObj(handle));
		} else {
			return null;
		}
	}
	native static final protected boolean gtk_tree_model_get_iter_firstExists(int treeModel);
	native static final protected int gtk_tree_model_get_iter_firstObj(int treeModel);

	/**
	 * Returns a newly-created {@link TreePath} referenced by <code>iter</code>.
	 */
	public TreePath getPath(TreeIter iter) {
		return new TreePath(gtk_tree_model_get_path(handle, iter.getHandle()));
	}

	/**
	 * Returns the Value at the given iter in the specified data block. 
	 */
	public String getValue(TreeIter iter, DataBlockString dataBlock) {
		int value = gtk_tree_model_get_value(handle, iter.getHandle(), dataBlock.getColumn());
		Value val = new Value(value);
		return val.getString();
	}
	/**
	 * Returns the Value at the given iter in the specified data block.
	 */
	public int getValue(TreeIter iter, DataBlockInt dataBlock) {
		int value = gtk_tree_model_get_value(handle, iter.getHandle(), dataBlock.getColumn());
		Value val = new Value(value);
		return val.getInt();
	}
	/**
	 * Returns the Value at the given iter in the specified data block. 
	 */
	public boolean getValue(TreeIter iter, DataBlockBoolean dataBlock) {
		int value = gtk_tree_model_get_value(handle, iter.getHandle(), dataBlock.getColumn());
		Value val = new Value(value);
		return val.getBoolean();
	}
	/**
	 * Returns the Value at the given iter in the specified data block. 
	 */
	public double getValue(TreeIter iter, DataBlockDouble dataBlock) {
		int value = gtk_tree_model_get_value(handle, iter.getHandle(), dataBlock.getColumn());
		Value val = new Value(value);
		return val.getDouble();
	}
	/**
	 * Returns the Value at the given iter in the specified data block. 
	 */
	public Object getValue(TreeIter iter, DataBlockObject dataBlock) {
		int value = gtk_tree_model_get_value(handle, iter.getHandle(), dataBlock.getColumn());
		Value val = new Value(value);
		return val.getJavaObject();
	}

	/**
	 * Returns the next <code>iter</code> pointing to the node following the TreeIter
	 * provided at the same level. If there is no next iter it will return null.
	 * <p>Use this in combination with {@link #getFirstIter()} to loop through
	 * all values in the model.
	 */
	public TreeIter getNextIter(TreeIter iter) {
		int value = gtk_tree_model_iter_next(handle, iter.getHandle());
		if (-1 == value)
			return null;
		return new TreeIter(value);
	}

	/**
	 * Returns TRUE if iter has children, FALSE otherwise.
	 */
	public boolean iterHasChild(TreeIter iter) {
		return gtk_tree_model_iter_has_child(handle, iter.getHandle());
	}

	/**
	 * Returns an iterator for the first child of the given iterator, or
	 * <code>null</code> if the iter has no children.
	 */
	public TreeIter getFirstChild(TreeIter parent) {
		if (iterHasChild(parent)) {
			return new TreeIter(gtk_tree_model_iter_childrenGet(handle, parent.getHandle()));
		} else {
			return null;
		}
	}
	native static final protected int gtk_tree_model_iter_childrenGet(int model, int parent);

	/**
	 * Returns the number of children that <code>iter</code> has
	 */
	public int getIterChildCount(TreeIter iter) {
		return gtk_tree_model_iter_n_children(handle, iter.getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_tree_model_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_tree_model_get_type();
	native static final protected int gtk_tree_model_get_n_columns(int treeModel);
	native static final protected int gtk_tree_model_get_column_type(int treeModel, int index);
	native static final protected boolean gtk_tree_model_get_iter(int treeModel, int iter, int path);
	native static final protected boolean gtk_tree_model_get_iter_from_string(int treeModel, int iter, String pathString);
	native static final protected boolean gtk_tree_model_get_iter_first(int treeModel, int iter);
	native static final protected int gtk_tree_model_get_path(int treeModel, int iter);
	native static final protected int gtk_tree_model_get_value(int treeModel, int iter, int column);
	native static final protected int gtk_tree_model_iter_next(int treeModel, int iter);
	native static final protected boolean gtk_tree_model_iter_children(int treeModel, int iter, int parent);
	native static final protected boolean gtk_tree_model_iter_has_child(int treeModel, int iter);
	native static final protected int gtk_tree_model_iter_n_children(int treeModel, int iter);
	native static final protected boolean gtk_tree_model_iter_nth_child(int treeModel, int iter, int parent, int n);
	native static final protected boolean gtk_tree_model_iter_parent(int treeModel, int iter, int child);
	native static final protected void gtk_tree_model_ref_node(int treeModel, int iter);
	native static final protected void gtk_tree_model_unref_node(int treeModel, int iter);
	native static final protected void gtk_tree_model_row_changed(int treeModel, int path, int iter);
	native static final protected void gtk_tree_model_row_inserted(int treeModel, int path, int iter);
	native static final protected void gtk_tree_model_row_has_child_toggled(int treeModel, int path, int iter);
	native static final protected void gtk_tree_model_row_deleted(int treeModel, int path);
	native static final protected void gtk_tree_model_rows_reordered(int treeModel, int path, int iter, int newOrder);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
