/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:42:18 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_add_default_file
     * Signature: (java.lan.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1add_1default_1file (JNIEnv *env, jclass 
        cls, jstring filename) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        gtk_rc_add_default_file (filename_g);
        (*env)->ReleaseStringUTFChars(env, filename, filename_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_set_default_files
     * Signature: ([Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1set_1default_1files (JNIEnv *env, jclass 
        cls, jobjectArray filenames) 
    {
        gchar **filenames_g = getStringArray(env, filenames);
        gtk_rc_set_default_files (filenames_g);
        freeStringArray(env, filenames, filenames_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_default_files
     * Signature: ()[Ljava/lang/String;
     */
    JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1default_1files (JNIEnv *env, jclass 
        cls) 
    {
        gchar** result = gtk_rc_get_default_files ();
        int size = sizeof(result) / sizeof(char*);
        jclass strClass = (*env)->FindClass(env, "java/lang/String");
        jobjectArray array = (*env)->NewObjectArray(env, size, strClass, NULL);
        int index;
        if (NULL == array)
        	return NULL;
        for (index = 0; index < size; index++) {
        	jstring str = (*env)->NewStringUTF(env, result[index]);
        	(*env)->SetObjectArrayElement(env, array, index, str);
        }
        return array;
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_style
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1style (JNIEnv *env, jclass cls, jint 
        widget) 
    {
        GtkWidget *widget_g = (GtkWidget *)widget;
        {
            return (jint)gtk_rc_get_style (widget_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_style_by_paths
     * Signature: (Ijava.lang.String;java.lang.String;I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1style_1by_1paths (JNIEnv *env, jclass 
        cls, jint settings, jstring widget_path, jstring class_path, jint type) 
    {
        gchar* widget_path_g = (gchar*)(*env)->GetStringUTFChars(env, widget_path, 0);
        gchar* class_path_g = (gchar*)(*env)->GetStringUTFChars(env, class_path, 0);
        jint result = (jint)gtk_rc_get_style_by_paths ((GtkSettings*)settings, widget_path_g, class_path_g, (GType)type);
        (*env)->ReleaseStringUTFChars(env, widget_path, widget_path_g);
        (*env)->ReleaseStringUTFChars(env, class_path, class_path_g);
        return result;
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_reparse_all_for_settings
     * Signature: (IZ)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1reparse_1all_1for_1settings (JNIEnv 
        *env, jclass cls, jint settings, jboolean forceLoad) 
    {
        GtkSettings *settings_g = (GtkSettings *)settings;
        gboolean forceLoad_g = (gboolean) forceLoad;
        {
            jboolean result_j = (jboolean) (gtk_rc_reparse_all_for_settings (settings_g, 
                    forceLoad_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_parse
     * Signature: (java.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1parse (JNIEnv *env, jclass cls, jstring 
        filename) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        gtk_rc_parse (filename_g);
        (*env)->ReleaseStringUTFChars(env, filename, filename_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_parse_string
     * Signature: (java.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1parse_1string (JNIEnv *env, jclass cls, 
        jstring rcString) 
    {
        gchar* rcString_g = (gchar*)(*env)->GetStringUTFChars(env, rcString, 0);
        gtk_rc_parse_string (rcString_g);
        (*env)->ReleaseStringUTFChars(env, rcString, rcString_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_reparse_all
     * Signature: ()Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1reparse_1all (JNIEnv *env, jclass cls) 
    {
        {
            jboolean result_j = (jboolean) (gtk_rc_reparse_all ());
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_find_module_in_path
     * Signature: (java.lang.String;)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1find_1module_1in_1path (JNIEnv *env, 
        jclass cls, jstring moduleFile) 
    {
        gchar* moduleFile_g = (gchar*)(*env)->GetStringUTFChars(env, moduleFile, 0);
        gchar *result_g = (gchar*)gtk_rc_find_module_in_path (moduleFile_g);
        (*env)->ReleaseStringUTFChars(env, moduleFile, moduleFile_g);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_theme_dir
     * Signature: ()java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1theme_1dir (JNIEnv *env, jclass 
        cls) 
    {
        gchar *result_g = gtk_rc_get_theme_dir ();
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_module_dir
     * Signature: ()java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1module_1dir (JNIEnv *env, jclass 
        cls) 
    {
        gchar *result_g = gtk_rc_get_module_dir ();
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_im_module_path
     * Signature: ()java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1im_1module_1path (JNIEnv *env, 
        jclass cls) 
    {
        gchar *result_g = gtk_rc_get_im_module_path ();
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.Rc
     * Method:    gtk_rc_get_im_module_file
     * Signature: ()java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Rc_gtk_1rc_1get_1im_1module_1file (JNIEnv *env, 
        jclass cls) 
    {
        gchar *result_g = gtk_rc_get_im_module_file ();
        return (*env)->NewStringUTF(env, result_g);
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
