/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Boxed;

/**
 */
public class RadioActionEntry extends Boxed {

	public RadioActionEntry(
			String name,
			String stockId,
			String label,
			String accel,
			String tooltip,
			int value) {

		// create the native object
		handle = allocate();
		// set the values
		setName(handle, name);
		setStockId(handle, stockId);
		setLabel(handle, label);
		setAccelerator(handle, accel);
		setTooltip(handle, tooltip);
		setValue(handle, value);
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		free(handle);
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int allocate();
	native static final protected void free(int entry);
	native static final protected void setName(int entry, String name);
	native static final protected void setStockId(int entry, String stockId);
	native static final protected void setLabel(int entry, String label);
	native static final protected void setAccelerator(int entry, String accel);
	native static final protected void setTooltip(int entry, String tooltip);
	native static final protected void setValue(int entry, int value);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
