/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.RadioMenuItem
 * Method:    gtk_radio_menu_item_new_with_label
 * Signature: ([ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL 
Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1with_1label(JNIEnv *env, 
    jclass cls, jintArray group, jstring label) 
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	jint value;
	const gchar* label_g;
	
	if (group != NULL) {
		len = (*env)->GetArrayLength(env, group);
		array = (*env)->GetIntArrayElements(env, group, NULL);
		list = g_slist_alloc();
		for (index = 0; index < len; index++)
			list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
    label_g = (*env)->GetStringUTFChars(env, label, NULL);
	value = (jint)gtk_radio_menu_item_new_with_label(list, label_g);
	(*env)->ReleaseStringUTFChars(env, label, label_g);
    return value;
}

/*
 * Class:     org.gnu.gtk.RadioMenuItem
 * Method:    gtk_radio_menu_item_new_with_mnemonic
 * Signature: ([ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL 
Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new_1with_1mnemonic(JNIEnv *env, 
    jclass cls, jintArray group, jstring label) 
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	jint value;
	const gchar* label_g;
	
	if (group != NULL) {
		len = (*env)->GetArrayLength(env, group);
		array = (*env)->GetIntArrayElements(env, group, NULL);
		list = g_slist_alloc();
		for (index = 0; index < len; index++)
			list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
    label_g = (*env)->GetStringUTFChars(env, label, NULL);
	value = (jint)gtk_radio_menu_item_new_with_mnemonic(list, label_g);
	(*env)->ReleaseStringUTFChars(env, label, label_g);
    return value;
}

/*
 * Class:     org.gnu.gtk.RadioMenuItem
 * Method:    gtk_radio_menu_item_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1get_1type (JNIEnv 
    *env, jclass cls) 
{
    return (jint)gtk_radio_menu_item_get_type ();
}

/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_new
 * Signature: ({I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1new
  (JNIEnv *env, jclass cls, jintArray group)
{
	GSList* list = NULL;
	jint* array;
	jsize len;
	int index;
	jint value;
	
	if (group != NULL) {
		len = (*env)->GetArrayLength(env, group);
		array = (*env)->GetIntArrayElements(env, group, NULL);
		list = g_slist_alloc();
		for (index = 0; index < len; index++)
			list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
	value = (jint)gtk_radio_menu_item_new(list);
    return value;
}
                                                                                                           
/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_get_group
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1get_1group
  (JNIEnv *env, jclass cls, jint menu)
{
	GSList* list;
	GSList* item;
	jintArray array;
	guint len;
	guint index;
	
	list = gtk_radio_menu_item_get_group((GtkRadioMenuItem*)menu);
	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	array = (*env)->NewIntArray(env, len);
	for (index = 0; index < len; index++) {
		item = g_slist_nth(list, index);
		(*env)->SetIntArrayRegion(env, array, index, len, (jint*)(GtkRadioMenuItem*)item->data);
	}
	return array;
}
                                                                                                           
/*
 * Class:     org_gnu_gtk_RadioMenuItem
 * Method:    gtk_radio_menu_item_set_group
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioMenuItem_gtk_1radio_1menu_1item_1set_1group
  (JNIEnv *env, jclass cls, jint menu, jintArray group)
{
	GSList* list;
	jint* array;
	jsize len;
	int index;
	
	len = (*env)->GetArrayLength(env, group);
	array = (*env)->GetIntArrayElements(env, group, NULL);
	list = g_slist_alloc();
	for (index = 0; index < len; index++)
	{
		list = g_slist_append(list, (GtkRadioMenuItem*)array[index]);
	}
	gtk_radio_menu_item_set_group((GtkRadioMenuItem*)menu, list);
}
                                                                                                           

#ifdef __cplusplus
}

#endif
