/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.GObject;

/**
 */
public class Display extends GObject {

	public Display() {
		if (-1 == getHandle()) 
			setHandle(gdk_display_get_default());
	}
	
	public Display(int hndl) {
		setHandle(hndl);
	}
	
	public static Display open(String name) {
		int hndl = gdk_display_open(name);
		return new Display(hndl);
	}
	
	public String getName() {
		return gdk_display_get_name(getHandle());
	}
	
	public int getNumScreens() {
		return gdk_display_get_n_screens(getHandle());
	}
	
	public Screen getScreen(int screenNumber) {
		int hndl = gdk_display_get_screen(getHandle(), screenNumber);
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Screen)obj;
		return new Screen(hndl);
	}
	
	public Screen getDefaultScreen() {
		int hndl = gdk_display_get_default_screen(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Screen)obj;
		return new Screen(hndl);
	}
	
	public void ungrabPointer() {
		gdk_display_pointer_ungrab(getHandle(), 0);
	}
	
	public void ungrabKeyboard() {
		gdk_display_keyboard_ungrab(getHandle(), 0);
	}
	
	public boolean pointerIsGrabbed() {
		return gdk_display_pointer_is_grabbed(getHandle());
	}
	
	public void beep() {
		gdk_display_beep(getHandle());
	}
	
	public void sync() {
		gdk_display_sync(getHandle());
	}
	
	public void flush() {
		gdk_display_flush(getHandle());
	}
	
	public void close() {
		gdk_display_close(getHandle());
	}
	
	public Device[] listDevice() {
		int[] hndls = gdk_display_list_devices(getHandle());
		if (null == hndls)
			return null;
		Device[] devices = new Device[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			GObject obj = retrieveGObject(hndls[i]);
			if (null != obj)
				devices[i] = (Device)obj;
			else
				devices[i] = new Device(hndls[i]);
		}
		return devices;
	}

	public Device getCorePointer() {
		int hndl = gdk_display_get_core_pointer(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Device)obj;
		return new Device(hndl);
	}
	
	public Window getWindowAtPointer() {
		int hndl = gdk_display_get_window_at_pointer(getHandle(), 0, 0);
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Window)obj;
		return new Window(hndl);
	}

	public boolean supportsCursorAlpha() {
		return gdk_display_supports_cursor_alpha(getHandle());
	}
	
	public boolean supportsCursorColor() {
		return gdk_display_supports_cursor_color(getHandle());
	}

	public int getDefaultCursorSize() {
		return gdk_display_get_default_cursor_size(getHandle());
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gdk_display_get_type();
	native static final protected int gdk_display_open(String displayName);
	native static final protected String gdk_display_get_name(int display);
	native static final protected int gdk_display_get_n_screens(int display);
	native static final protected int gdk_display_get_screen(int display, int screenNum);
	native static final protected int gdk_display_get_default_screen(int display);
	native static final protected void gdk_display_pointer_ungrab(int display, int time);
	native static final protected void gdk_display_keyboard_ungrab(int display, int time);
	native static final protected boolean gdk_display_pointer_is_grabbed(int display);
	native static final protected void gdk_display_beep(int display);
	native static final protected void gdk_display_sync(int display);
	native static final protected void gdk_display_flush(int display);
	native static final protected void gdk_display_close(int display);
	native static final protected int[] gdk_display_list_devices(int display);
	native static final protected int gdk_display_get_event(int display);
	native static final protected int gdk_display_peek_event(int display);
	native static final protected void gdk_display_put_event(int display, int event);
	native static final protected int gdk_display_get_default();
	native static final protected int gdk_display_get_core_pointer(int display);
	native static final protected void gdk_display_get_pointer(int display, int[] screen, int[] x, int[] y, int[] modType);
	native static final protected int gdk_display_get_window_at_pointer(int display, int x, int y);
	native static final protected boolean gdk_display_supports_cursor_alpha(int display);
	native static final protected boolean gdk_display_supports_cursor_color(int display);
	native static final protected int gdk_display_get_default_cursor_size(int display);
	native static final protected void gdk_display_get_maximum_cursor_size(int display, int[] width, int[] height);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
