/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
 
 /*
  * TODO:
  * Everything but the constructor.
  */

package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 * Image represents an area for drawing graphics.
 */
public class Image extends GObject 
{
	
	public Image(int handle){
		setHandle(handle);
	}
	
	/**
	 * Create a new Image.
	 */
	public Image(ImageType type, Visual visual, int width, int height) {
		setHandle(gdk_image_new(type.getValue(), visual.getHandle(), width, height));
	}
	
	/**
	 * Retrieves the colormap for a given image.
	 */
	public Colormap getColormap() {
		int hndl = gdk_image_get_colormap(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Colormap)obj;
		return new Colormap(hndl);
	}
	
	/**
	 * Sets the colormap for the image.
	 */
	public void setColormap(Colormap cmap) {
		gdk_image_set_colormap(getHandle(), cmap.getHandle());
	}
	
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getVisual (int obj);
    native static final protected int getByteOrder (int obj);
    native static final protected int getWidth (int obj);
    native static final protected int getHeight (int obj);
    native static final protected int getDepth (int obj);
    native static final protected int getBpp (int obj);
    native static final protected int getBpl (int obj);
    native static final protected int getBitsPerPixel (int obj);
    native static final protected int gdk_image_get_type ();
    native static final protected int gdk_image_new (int type, int visual, int width, int height);
    native static final protected void gdk_image_put_pixel (int image, int x, int y, int pixel);
    native static final protected int gdk_image_get_pixel (int image, int x, int y);
    native static final protected void gdk_image_set_colormap (int image, int colormap);
    native static final protected int gdk_image_get_colormap (int image);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

