/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.Boxed;
public class Requisition extends Boxed 
{
	
	/**
	 * Construct a new Requisition.
	 */
	public Requisition(int width, int height) {
		handle = Requisition.gtk_requisition_new();
		Requisition.setWidth(handle, width);
		Requisition.setHeight(handle, height);
	}
	
	public int getWidth() {
	    return getWidth(getHandle());
	}
	
	public int getHeight() {
	    return getHeight(getHandle());
	}
	
	
    /****************************************
     * BEGINNING OF JNI CODE
     ****************************************/
    native static final protected int getWidth (int cptr);
    native static final protected void setWidth (int cptr, int width);
    native static final protected int getHeight (int cptr);
    native static final protected void setHeight (int cptr, int height);
    native static final protected int gtk_requisition_copy (int requisition);
    native static final protected void gtk_requisition_free (int requisition);
	native static final protected int gtk_requisition_new();
    /****************************************
     * END OF JNI CODE
     ****************************************/
}

