/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * Represents a horizontal line of pixels starting with the pixel at
 * coordinates x,y and ending before x+width,y. 
 */
public class Span extends Boxed 
{

    Span(Handle handle) {
        super(handle);
    }
    
    /**
     * Retrieve the x coordinate.
     */
    public int getX() {
        return getX(getHandle());
    }
    
    /**
     * Set the x coordinate.
     * @param x
     */
    public void setX(int x) {
        setX(getHandle(), x);
    }
    
    /**
     * Retrieve the y coordinate.
     */
    public int getY() {
        return getY(getHandle());
    }
    
    /**
     * Set the y coordinate.
     * @param y
     */
    public void setY(int y) {
        setY(getHandle(), y);
    }
    
    /**
     * Retrieve the width of the Span.
     */
    public int getWidth() {
        return getWidth(getHandle());
    }
    
    /**
     * Set the width of the Span.
     * @param width
     */
    public void setWidth(int width) {
        setWidth(getHandle(), width);
    }
    
    
    native static final protected int getX (Handle obj);
    native final protected void setX (Handle obj, int x);
    native static final protected int getY (Handle obj);
    native final protected void setY (Handle obj, int y);
    native static final protected int getWidth (Handle obj);
    native final protected void setWidth (Handle obj, int width);

}

