/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 */
public interface FileChooser {

	/*
	 * Configuration
	 */
	void setAction(FileChooserAction action);
	FileChooserAction getAction();
	void setLocalOnly(boolean localOnly);
	boolean getLocalOnly();
	void setSelectMultiple(boolean selectMultiple);
	boolean getSelectMultiple();
	
	/*
	 * Filename manipulation
	 */
	void setCurrentName(String name);
	String getFilename();
	boolean setFilename(String filename);
	boolean selectFilename(String filename);
	void unselectFilename(String filename);
	void selectAll();
	void unselectAll();
	String[] getFilenames();
	boolean setCurrentFolder(String folder);
	String getCurrentFolder();
	
	/*
	 * URI manipulation
	 */
	String getURI();
	boolean setURI(String uri);
	boolean selectURI(String uri);
	void unselectURI(String uri);
	String[] getURIs();
	boolean setCurrentFolderURI(String folder);
	String getCurrentFolderURI();
	
	/*
	 * Preview widget
	 */
	void setPreviewWidget(Widget previewWidget);
	Widget getPreviewWidget();
	void setPreviewWidgetActive(boolean active);
	boolean getPreviewWidgetActive();
	void setUsePreviewLabel(boolean useLabel);
	boolean getUsePreviewLabel();
	String getPreviewFilename();
	String getPreviewURI();
	
	/*
	 * Extra widget
	 */
	void setExtraWidget(Widget extraWidget);
	Widget getExtraWidget();
	
	/*
	 * List of user selectable filters
	 */
	void addFilter(FileFilter filter);
	void removeFilter(FileFilter filter);
	FileFilter[] listFilters();
	
	/*
	 * Current filter
	 */
	void setFilter(FileFilter filter);
	FileFilter getFilter();
	
	/*
	 * Per-application shortcut folders
	 */
	void addShortcutFolder(String folder) throws FileChooserException;
	void removeShortcutFolder(String folder) throws FileChooserException;
	String[] listShortcutFolders();
	void addShortcutURI(String uri) throws FileChooserException;
	void removeShortcutURI(String uri) throws FileChooserException;
	String[] listShortcutURIs();

    /*
     * Hidden.
     */
    void setShowHidden( boolean hidden );
    boolean getShowHidden();
}
