/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

import org.gnu.javagnome.Handle;
import org.gnu.javagnome.Struct;

/**
 * @deprecated This class is deprecated.  Use Java's collection
 * classes or arrays instead.
 *
 * This object represents a doubly-linked list in the GLib system.
 * This should only be used internally.  This type should be converted
 * into one of the Java container types prior to being passed to
 * the application layer.  Objects of this type should be freed by
 * calling thre free() method.  The <strong>data</strong> parameter that
 * is being passed into many of the methods is the handle of a java-gnome
 * object.
 */
public class List extends Struct {
	
	/**
	 * Construct a List object
	 */
	public List() {
		super(List.g_list_alloc());
	}
	
	/**
	*	Contruct a List object using a given handle.
	*	This constructor is used by the libraries internally
	*	to construct the object with the handle returned by a native method.
	*/
	public List(Handle handle){
		super(handle);
	}
	
	/**
	 * Release the resources associated with this object.
	 */
	public void free() {
		List.g_list_free(getHandle());
	}
	
	/**
	 * Append an element to the end of the list.
	 * 
	 * @param data The handle of the object that is being added
	 * to the List.
	 */	
	public void append(int data) {
		setHandle(List.g_list_append(getHandle(), data));
	}
	
	/**
	 * Prepend an element to the end of the list.
	 * 
	 * @param data The handle of the object that is being
	 * added to the List.
	 */
	public void prepend(int data) {
		setHandle(List.g_list_prepend(getHandle(), data));
	}
	
	/**
	 * Insert an element at a specified location in the List.
	 * 
	 * @param data The handle of the object that is being added
	 * to the List.
	 * @param position The position to perform the insertion.
	 */
	public void insert(int data, int position) {
		setHandle(List.g_list_insert(getHandle(), data, position));
	}
	
	/**
	 * Remove the first instance of an element from the List.
	 * 
	 * @param data The item to remove from the list.  If two
	 * items contain the same data only the first will be 
	 * removed.
	 */
	public void remove(int data) {
		setHandle(List.g_list_remove(getHandle(), data));
	}
	
	/**
	 * Remove all instances of an element from the List.
	 * 
	 * @param data The item to remove from the List.  This
	 * method will remove all instances of the object pointed
	 * to by data.
	 */
	public void removeAllInstances(int data) {
		setHandle(List.g_list_remove_all(getHandle(), data));
	}

	/**
	 * Return the number of elements contained in the List.
	 * 
	 * @return The number of elements in the List.
	 */
	public int length() {
		return List.g_list_length(getHandle());
	}
	
	/**
	 * Return the first element from the List.  This method
	 * will also reposition the current list item to the 
	 * beginning of the list.
	 * 
	 * @return The first element from the List.
	 */
	public Handle first() {
		setHandle(List.g_list_first(getHandle()));
		return List.getData(getHandle());
	}
	
	/**
	 * Return the last element from the List.  This method
	 * will also reposition the current list item to the
	 * end of the list.
	 * 
	 * @return The last element from the List.
	 */
	public Handle last() {
		setHandle(List.g_list_last(getHandle()));
		return List.getData(getHandle());
	}
	
	/**
	 * Return the next element in the List.  This method
	 * will also move the current list item forward one
	 * element.
	 * 
	 * @return The next element from the List.
	 */
	public Handle next() {
		setHandle(List.g_list_next(getHandle()));
		return List.getData(getHandle());
	}
	
	/**
	 * Return the previous element in the List.  This method
	 * will also move the current list item backward one
	 * element.
	 * 
	 * @return The previous element from the List.
	 */
	public Handle previous() {
		setHandle(List.g_list_previous(getHandle()));
		return List.getData(getHandle());
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
    native static final protected Handle getData (Handle obj);
	native static final protected Handle g_list_append(Handle list, int data);
	native static final protected Handle g_list_prepend(Handle list, int data);
	native static final protected Handle g_list_insert(Handle list, int data, int position);
	native static final protected Handle g_list_remove(Handle list, int data);
	native static final protected Handle g_list_remove_all(Handle list, int data);
	native static final protected void g_list_free(Handle list);
	native static final protected Handle g_list_alloc();
	native static final protected int g_list_length(Handle list);
	native static final protected Handle g_list_first(Handle list);
	native static final protected Handle g_list_last(Handle list);
	native static final protected Handle g_list_previous(Handle list);
	native static final protected Handle g_list_next(Handle list);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
