/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * This is a base class providing allignment and padding to a number of
 * displayable widgets.
 */
public class Misc extends Widget {

	protected Misc(Handle handle) {
		super(handle);
	}

	/**
	 * Sets the alignment of a widget.
	 * @param xAlign The horizontal alignment from 0 (left) to 1 (right).
	 * @param yAlign The vertical alignment from 0 (top) to 1 (bottom).
	 */
	public void setAlignment(double xAlign, double yAlign) {
		Misc.gtk_misc_set_alignment(getHandle(), xAlign, yAlign);
	}

	/**
	 * Returns the horizontal alignment of the widget.
	 */
	public double getXAlign() {
		double[] xAlign = new double[1];
		double[] yAlign = new double[1];
		Misc.gtk_misc_get_alignment(getHandle(), xAlign, yAlign);
		return xAlign[0];
	}

	/**
	 * Returns the vertical alignment of the widget.
	 */
	public double getYAlign() {
		double[] xAlign = new double[1];
		double[] yAlign = new double[1];
		Misc.gtk_misc_get_alignment(getHandle(), xAlign, yAlign);
		return yAlign[0];
	}

	/**
	 * Sets the amount of space to add around the widget.
	 * @param xPad The amount of space to add to the left and right of the widget.
	 * @param yPad The amount of space to add to the top and bottom of the widget.
	 */
	public void setPadding(int xPad, int yPad) {
		Misc.gtk_misc_set_padding(getHandle(), xPad, yPad);
	}

	/**
	 * Retrieve the amount of space added to the left and right of the widget.
	 */
	public int getXPadding() {
		int[] xPad = new int[1];
		int[] yPad = new int[1];
		Misc.gtk_misc_get_padding(getHandle(), xPad, yPad);
		return xPad[0];
	}

	/**
	 * Retrieve the amount of space added to the top and bottom of the widget.
	 */
	public int getYPadding() {
		int[] xPad = new int[1];
		int[] yPad = new int[1];
		Misc.gtk_misc_get_padding(getHandle(), xPad, yPad);
		return yPad[0];
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_misc_get_type());
	}


	native static final protected int gtk_misc_get_type();
	native static final protected void gtk_misc_set_alignment(Handle misc, double xalign, double yalign);
	native static final protected void gtk_misc_get_alignment(Handle misc, double[] xalign, double[] yalign);
	native static final protected void gtk_misc_set_padding(Handle misc, int xpad, int ypad);
	native static final protected void gtk_misc_get_padding(Handle misc, int[] xpad, int[] ypad);

}
