/****************************************************************************/
/* xmStyles.h - Style constants for Xm++ control classes (03 06 92)         */
/****************************************************************************/
/*                                                                          */
/*   Copyright (c) 1992, 1993, 1994  Bernhard Strassl                       */
/*       Vienna User Interface Group                                        */
/*       Institute for Applied Computer Science and Information Systems     */
/*       University of Vienna, Austria                                      */
/*                                                                          */
/*   See file COPYRIGHT in this directory for details. If this file is      */
/*   missing please mail to xmpp@ani.univie.ac.at                           */
/****************************************************************************/

#ifndef XmStyles_included
#define XmStyles_included 1

typedef unsigned long xmStyle;

/* control styles */

#define XmSleft             (1<<0)
#define XmSright            (1<<1)
#define XmScenter           (1<<2)
#define XmShorizontal       (1<<3)
#define XmSvertical         (1<<4)
#define XmStop              (1<<5)
#define XmSbottom           (1<<6)

#define XmSdefault          (1<<8)
#define XmStabStop          (1<<9)

#define XmSautovscroll      (1<<10)
#define XmSautohscroll      (1<<11)
#define XmSmultiLine        (1<<12)
#define XmSautoCursor       (1<<13)

#define XmSsingleSel        (1<<14)
#define XmSmultipleSel      (1<<15)

#define XmSsimple           (1<<17)
#define XmSdropdown         (1<<18)
#define XmSdropdownlist     (1<<19)

#define XmSblackFrame       (1<<21)
#define XmSgrayFrame        (1<<22)
#define XmSwhiteFrame       (1<<23)
#define XmSblackRectangle   (1<<24)
#define XmSgrayRectangle    (1<<25)
#define XmSwhiteRectangle   (1<<26)

/* window styles */

#define XmSmaximize         (1<<0)
#define XmSminimize         (1<<1)
#define XmSbordered         (1<<2)
#define XmSmoveable         (1<<3)
#define XmSresizeable       (1<<4)
#define XmScloseable        (1<<5)
#define XmStitled           (1<<6)
#define XmSsysMenu          (1<<7)

#define XmSpopup            (1<<9)

/* dialog styles */

#define XmSdlgModeless      (1<<15)
#define XmSdlgWinModal      (1<<16)
#define XmSdlgAppModal      (1<<17)
#define XmSdlgSysModal      (1<<18)

#define XmSmsgMemo          (1<<20)
#define XmSmsgInfo          (1<<21)
#define XmSmsgQuestion      (1<<22)
#define XmSmsgWorking       (1<<23)
#define XmSmsgWarning       (1<<24)
#define XmSmsgError         (1<<25)

/* message box styles */

#define XmSmsgOk            (1<<10)
#define XmSmsgOkCancel      (1<<11)
#define XmSmsgOkCancelHelp  (1<<12)
#define XmSmsgYesNo         (1<<13)
#define XmSmsgYesNoCancel   (1<<14)

#define XmSmboxInfo     XmSdlgAppModal | XmSmsgOk | XmSmsgInfo
#define XmSmboxWarning  XmSdlgAppModal | XmSmsgOk | XmSmsgWarning
#define XmSmboxError    XmSdlgAppModal | XmSmsgOk | XmSmsgError
#define XmSmboxOption   XmSdlgAppModal | XmSmsgOkCancel | XmSmsgInfo
#define XmSmboxQuestion XmSdlgAppModal | XmSmsgYesNo | XmSmsgQuestion
#define XmSmboxOptQuest	XmSdlgAppModal | XmSmsgYesNoCancel | XmSmsgQuestion

#endif
