package App::InteractivePerlTutorial::Chapter::Arrays::Operators;

use v5.14;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Operators';

1;
__DATA__

=encoding utf-8

=head1 Operators

You may come to a point where you don't want to use indices, so you'd like to use those operators:

=head2 pop

Pop gets the last element from an array(the one on the position -1) and returns it as a scalar value:

  my @a = (1..10);
  my $x = pop @a; # now $x=10 and @a=(1..9)
  pop @a;         # like this pop just eliminate the last element(9)

=head2 push

This operator adds a new element to the end of the array like this:

  my @a = (1);
  push @a, (9, 3 ,7); # at this point array @a has (1, 9, 3, 7)

=head2 shift

The shift operator gets the first element(the one with the indices 0) from an array and returns it as a scalar value:

  my @a = (5..17);
  my $s = shift @a;  # the same with C<my $s=5;my @a=(6..17);>
  shift @a;          # like this pop just eliminate the first element of the array at that moment.

=head2 unshift

This operator adds a new element to the end of the array like this:

  my @a = (1);
  unshift @a, (11, 8 ,27); # at this point array @a has (11, 8, 27, 1)

=head2 splice

Operator splice cuts a part(under the form of a list) from an array and returns it and can also replace the extracted part with another array. This operator has 4 arguments,last 2 optional:
The first argument is the array on which we do the splice operation, the second argument is the position from which we start to make the operation, the third is the length(if it's let empty the operation will continue until the last element of the array) and the forth is another array which is put in the first argument array starting from the position given.

  @c = qw( a b c );
  @b = (0..5);
  @a = splice @b, 2, 2 ,(12, 3, @c);

So, after this line, @a=(2, 3) and @b=(0, 1, 12, 3, a, b, c, 4, 5).


=cut
