###################################################################################################
# Copyright 2013/2014 by Marcel Greter
# This file is part of OCBNET-CSS3 (GPL3)
####################################################################################################
package OCBNET::CSS3::DOM::Extended::FontFace;
####################################################################################################
our $VERSION = '0.2.5';
####################################################################################################

use strict;
use warnings;

####################################################################################################
use base 'OCBNET::CSS3::DOM::Extended';
####################################################################################################

# static getter
#**************************************************************************************************
sub type { return 'fontface' }

####################################################################################################

# load regex for vendor prefixes
#**************************************************************************************************
use OCBNET::CSS3::Regex::Base qw($re_vendors);

# add basic extended type with highest priority
#**************************************************************************************************
unshift @OCBNET::CSS3::types, [
	qr/\A\s*\@(?:-$re_vendors-)?font-face/is,
	'OCBNET::CSS3::DOM::Extended::FontFace'
];

####################################################################################################
####################################################################################################
1;
