/*
 * Offensive Fortune Cookie File (ROT13) Decoder
 * Version 5
 * (c) 2009-2011, Robert Fahy
 *
 */

// inclusion of needed header files
#include <fstream>
#include <iostream>
#include <cstdlib>
#include <string>

// needed so we don't need to manually add `std::' for
// access to things in the header files
using namespace std;

// declarations (prototypes) of the functions that will be defined later
const string decode(const string &what);
void print_usage(const string &add_text);
int main(int argc, char **argv);

const string decode(const string &what)
// ABOUT: converts `what' string using ROT13
{
	const string
		plain_ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",
		spicy_ = "nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM";

	string result_="";
	const size_t what_length_ = what.length(); // same as `.size()'

	for (size_t i=0; i < what_length_; ++i)
	{
		size_t offset_ = plain_.find_first_of(what[i]);

		if (offset_ != string::npos) // alphanumeric character, decoding needed
			result_ += spicy_[offset_];
		else // no decoding needed for digits, symbols, and whitespaces
			result_ += what[i];
	}

	return result_;
} // ### const string decode(const string &what)

void print_usage(const string &add_text)
// ABOUT: print usage message to stderr, plus `add_text' if supplied
{
	cerr << "\nDecoff usage:\n\t<decoff> input_filename output_filename\n";

	if (add_text.size())
		cerr << "\t>>> Error is: " << add_text << " <<<\n\n";
} // ### void print_usage(const string &add_text)

// ### MAIN FUNCTION ###
int main(int argc, char **argv)
// ### MAIN FUNCTION ###
{
	if (argc < 3)
	{
		print_usage("Not enough arguments.");
		return EXIT_FAILURE;
	}
	else
		if (argc > 3)
		{
			print_usage("Too many arguments.");
			return EXIT_FAILURE;
		}
		else
		{
			ifstream inputfile_;
			inputfile_.open(argv[1]);

			if (inputfile_.is_open())
			{
				ofstream outputfile_;
				outputfile_.open(argv[2]);

				if (outputfile_.is_open())
				{
					// WARN: within this block the whole input file is read in one go, and
					//  the whole output file is written in one go. this is prone to failure
					//  if you use it on huge (or binary) files, you have been warned!
					while (!inputfile_.eof())
					{
						string temp_;

						getline(inputfile_, temp_, '\0');
						outputfile_ << decode(temp_);
					}

					if (inputfile_.bad())
						cerr
							<< argv[1] << " ))) Warning: possible reading failure of input file `"
							<< argv[1] << "'.\n";

					if (outputfile_.bad())
						cerr
							<< argv[2] << " ))) Warning: possible writing failure for output file `"
							<< argv[2] << "'.\n";

					outputfile_.close();
				}
				else
				{
					cerr << argv[2] << " >>> Error: could not open output file `" << argv[2] << "'.\n";
					return EXIT_FAILURE;
				}

				inputfile_.close();
			}
			else
			{
				cerr << argv[1] << " >>> Error: could not open input file `" << argv[1] << "'.\n";
				return EXIT_FAILURE;
			}
		}

	cout << argv[1] << "\t-->\t" << argv[2] << " ::: Operation successful.\n";

	return EXIT_SUCCESS;
} // ### MAIN FUNCTION ###
