/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */

#include "definitions.h"
#include "utils.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>



void match_string_length (char **dest, int len)
{
	int dlen = strlen(*dest);
	if (dlen < len)
	{
		char  *sfill = g_strnfill(len-dlen, ' ');
		char *new_str = g_strconcat(*dest, sfill, NULL);
		g_free(*dest);
		g_free(sfill);
		*dest = new_str;
	}else if (dlen > len)
	{
		g_strchomp(*dest + len);	
	}
}

char *get_bytes_string_base (unsigned long long nbytes, unsigned long long base,
							 const char *format, const char *formatd)
{
	char *str;
	unsigned long long decimalv; 
	decimalv = (nbytes < base * 10) ? (nbytes % base) * 10 / base : 0;
	if (decimalv == 0)
		str = g_strdup_printf(format, nbytes / base);
	else
		str = g_strdup_printf(formatd, nbytes / base, decimalv);
	return str;
}

char* get_bytes_string (unsigned long long nbytes)
{
	const unsigned long long ctKB = 1024, ctMB = ctKB*1024, 
		ctGB = ctMB*1024, ctTB = ctGB*1024;
	char *str;
	if (nbytes < ctKB)
		str = g_strdup_printf(_("%Lu B"), nbytes);
	else if (nbytes < ctMB)
		str = get_bytes_string_base(nbytes, ctKB, _("%Lu KB"), _("%Lu.%Lu KB"));
	else if (nbytes < ctGB)
		str = get_bytes_string_base(nbytes, ctMB, _("%Lu MB"), _("%Lu.%Lu MB"));
	else if (nbytes < ctTB)
		str = get_bytes_string_base(nbytes, ctGB, _("%Lu GB"), _("%Lu.%Lu GB"));
	else
		str = get_bytes_string_base(nbytes, ctTB, _("%Lu TB"), _("%Lu.%Lu TB"));
	return str;
}


gboolean drop_effective_user_to_sudo()
{
	gboolean dropped = FALSE;
	if (getuid() == 0)
	{
		const char *sudo_uid = g_getenv("SUDO_UID");
		const char *sudo_gid = g_getenv("SUDO_GID");
		
		if (sudo_uid != NULL)
		{
			seteuid(atol(sudo_uid));
			dropped = TRUE;
			if (sudo_gid != NULL)
				setegid(atol(sudo_gid));	
		}
	}
	return dropped;
}

void restore_effective_user()
{
	seteuid(getuid());
	setegid(getgid());
}

const char* get_effective_home_dir()
{
	struct passwd *pw;
	pw = getpwuid(geteuid());
	if (pw != NULL && pw->pw_dir!=NULL)
		return pw->pw_dir;
	
	{
		const char *home_dir = g_getenv("HOME");
		if (home_dir != NULL)
			return home_dir;
	}
	return g_get_home_dir(); /*In the current implementation(2.14) returns home for uid*/
}

void set_clipboard_text (const char *text)
{
	GdkAtom atom;
	GtkClipboard *clipboard;
	
	atom = gdk_atom_intern("CLIPBOARD", FALSE);
	clipboard = gtk_clipboard_get(atom);
	
	gtk_clipboard_set_text(clipboard, text, -1);
}

