/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.builder;

import org.apache.axiom.core.Builder;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.DeferredParsingException;
import org.apache.axiom.core.NodeFactory2;
import org.apache.axiom.core.impl.builder.BuilderHandler;
import org.apache.axiom.core.impl.builder.BuilderListener;
import org.apache.axiom.core.impl.builder.Model;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlInput;
import org.apache.axiom.core.stream.XmlReader;

public final class BuilderImpl
implements Builder {
    private final XmlReader reader;
    private final BuilderHandler builderHandler;
    private Object facade;

    public BuilderImpl(XmlInput input, NodeFactory2 nodeFactory, Model model, CoreNSAwareElement root) {
        this.builderHandler = new BuilderHandler(nodeFactory, model, root, this);
        this.reader = input.createReader(this.builderHandler);
    }

    public void addListener(BuilderListener listener) {
        this.builderHandler.addListener(listener);
    }

    public Object getFacade() {
        return this.facade;
    }

    public void setFacade(Object facade) {
        this.facade = facade;
    }

    @Override
    public void next() throws DeferredParsingException {
        if (this.isCompleted()) {
            throw new IllegalStateException();
        }
        try {
            this.reader.proceed();
        }
        catch (StreamException ex) {
            throw new DeferredParsingException(ex);
        }
        this.builderHandler.executeDeferredActions();
    }

    @Override
    public boolean isCompleted() {
        return this.builderHandler.isCompleted();
    }

    public CoreDocument getDocument() throws DeferredParsingException {
        CoreDocument document;
        while ((document = this.builderHandler.getDocument()) == null) {
            this.next();
        }
        return document;
    }

    @Override
    public void close() {
        this.reader.dispose();
    }
}

