/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.packageadmin.internal;

import jakarta.servlet.Servlet;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.webconsole.plugins.packageadmin.internal.WebConsolePlugin;
import org.apache.felix.webconsole.plugins.packageadmin.internal.WebConsolePrinter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator {
    private ServiceRegistration<Servlet> plugin;
    private ServiceRegistration<InventoryPrinter> printerReg;

    public void start(BundleContext context) throws Exception {
        PackageAdmin pa;
        ServiceReference packageAdmin = context.getServiceReference(PackageAdmin.class);
        if (packageAdmin != null && (pa = (PackageAdmin)context.getService(packageAdmin)) != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("felix.inventory.printer.name", "duplicate_exports");
            ((Dictionary)props).put("felix.inventory.printer.title", "Duplicate Exports");
            ((Dictionary)props).put("felix.inventory.printer.format", new String[]{Format.TEXT.toString()});
            this.printerReg = context.registerService(InventoryPrinter.class, (Object)new WebConsolePrinter(context, pa), props);
            this.plugin = new WebConsolePlugin(context, pa).register();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.printerReg != null) {
            this.printerReg.unregister();
            this.printerReg = null;
        }
        if (this.plugin != null) {
            this.plugin.unregister();
            this.plugin = null;
        }
    }
}

