/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.packageadmin.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.webconsole.plugins.packageadmin.internal.ExportedPackageComparator;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

class WebConsolePlugin
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final String LABEL = "depfinder";
    private static final String TITLE = "%pluginTitle";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/depfinder/res/plugin.css"};
    private static final Comparator<ExportedPackage> EXPORT_PACKAGE_COMPARATOR = new ExportedPackageComparator();
    private final PackageAdmin pa;
    private final BundleContext bc;
    private final String TEMPLATE;

    WebConsolePlugin(BundleContext bc, PackageAdmin pa) {
        this.pa = pa;
        this.bc = bc;
        try {
            this.TEMPLATE = this.readTemplateFile("/res/plugin.html");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load template files", e);
        }
    }

    public ServiceRegistration<Servlet> register() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.webconsole.label", LABEL);
        ((Dictionary)props).put("felix.webconsole.title", TITLE);
        ((Dictionary)props).put("felix.webconsole.category", CATEGORY);
        ((Dictionary)props).put("felix.webconsole.css", CSS);
        return this.bc.registerService(Servlet.class, (Object)this, props);
    }

    public final void renderContent(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().print(this.TEMPLATE);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object json;
        String action = req.getParameter("action");
        if ("deps".equals(action)) {
            json = WebConsolePlugin.doFindDependencies(req, this.pa);
        } else if ("dups".equals(action)) {
            Map<String, Set<ExportedPackage>> packages = WebConsolePlugin.collectExportedPackages(this.pa, this.bc);
            json = WebConsolePlugin.doFindDuplicates(packages);
        } else {
            throw new ServletException("Invalid action: " + action);
        }
        AbstractServlet.setNoCache((HttpServletResponse)resp);
        resp.setContentType("application/json; utf-8");
        JSONWriter writer = new JSONWriter(resp.getWriter());
        writer.value(json);
        writer.flush();
    }

    static final Map<String, Set<ExportedPackage>> collectExportedPackages(PackageAdmin pa, BundleContext bundleContext) {
        TreeMap<String, Set<ExportedPackage>> exports = new TreeMap<String, Set<ExportedPackage>>();
        Bundle[] bundles = bundleContext.getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            ExportedPackage[] bundleExports = pa.getExportedPackages(bundle);
            for (int j = 0; bundleExports != null && j < bundleExports.length; ++j) {
                ExportedPackage exportedPackage = bundleExports[j];
                TreeSet<ExportedPackage> exportSet = (TreeSet<ExportedPackage>)exports.get(exportedPackage.getName());
                if (exportSet == null) {
                    exportSet = new TreeSet<ExportedPackage>(EXPORT_PACKAGE_COMPARATOR);
                    exports.put(exportedPackage.getName(), exportSet);
                }
                exportSet.add(exportedPackage);
            }
        }
        return exports;
    }

    private static final Map<String, Object> doFindDependencies(HttpServletRequest req, PackageAdmin pa) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        String findField = req.getParameter("plugin.find");
        if (findField != null) {
            Set<String> packageNames = WebConsolePlugin.getPackageNames(findField);
            LinkedHashSet<Bundle> exportingBundles = new LinkedHashSet<Bundle>();
            for (String name : packageNames) {
                ArrayList<Map<String, Object>> pl = (ArrayList<Map<String, Object>>)json.get("packages");
                if (pl == null) {
                    pl = new ArrayList<Map<String, Object>>();
                    json.put("packages", pl);
                }
                pl.add(WebConsolePlugin.getPackageInfo(name, pa, exportingBundles));
            }
            HashMap<String, Map<Object, Object>> mavenJson = new HashMap<String, Map<Object, Object>>();
            json.put("maven", mavenJson);
            for (Bundle bundle : exportingBundles) {
                Map<Object, Object> value = WebConsolePlugin.getMavenInfo(bundle);
                if (value == null) continue;
                mavenJson.put(String.valueOf(bundle.getBundleId()), value);
            }
        }
        return json;
    }

    private static final Collection<Object> doFindDuplicates(Map<String, Set<ExportedPackage>> exports) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Map.Entry<String, Set<ExportedPackage>> exportEntry : exports.entrySet()) {
            Set<ExportedPackage> exportSet = exportEntry.getValue();
            if (exportSet.size() <= 1) continue;
            HashMap<String, Object> container = new HashMap<String, Object>();
            ret.add(container);
            for (ExportedPackage exportedPackage : exportSet) {
                Map<String, Object> json = WebConsolePlugin.toJSON(exportedPackage);
                container.put("name", exportedPackage.getName());
                ArrayList<Map<String, Object>> imps = (ArrayList<Map<String, Object>>)container.get("entries");
                if (imps == null) {
                    imps = new ArrayList<Map<String, Object>>();
                    container.put("entries", imps);
                }
                imps.add(json);
            }
        }
        return ret;
    }

    private static final void toJSON(Bundle bundle, Map<String, Object> json) {
        json.put("bid", bundle.getBundleId());
        if (bundle.getSymbolicName() != null) {
            json.put("bsn", bundle.getSymbolicName());
        }
    }

    private static final void toJSON(String pkgName, Bundle[] importers, Map<String, Object> json) {
        for (int i = 0; i < importers.length; ++i) {
            ArrayList<HashMap<String, Object>> imps;
            Bundle bundle = importers[i];
            HashMap<String, Object> usingJson = new HashMap<String, Object>();
            WebConsolePlugin.toJSON(bundle, usingJson);
            String ip = (String)bundle.getHeaders().get("Import-Package");
            Clause[] clauses = Parser.parseHeader(ip);
            for (int j = 0; j < clauses.length; ++j) {
                Clause clause = clauses[j];
                if (!pkgName.equals(clause.getName())) continue;
                usingJson.put("ver", clause.getAttribute("version"));
                break;
            }
            if ((imps = (ArrayList<HashMap<String, Object>>)json.get("importers")) == null) {
                imps = new ArrayList<HashMap<String, Object>>();
                json.put("importers", imps);
            }
            imps.add(usingJson);
        }
    }

    private static final Map<String, Object> toJSON(ExportedPackage pkg) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("version", pkg.getVersion());
        WebConsolePlugin.toJSON(pkg.getExportingBundle(), ret);
        WebConsolePlugin.toJSON(pkg.getName(), pkg.getImportingBundles(), ret);
        return ret;
    }

    private static final Map<String, Object> getPackageInfo(String packageName, PackageAdmin pa, Set<Bundle> exportingBundles) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ExportedPackage[] exports = pa.getExportedPackages(packageName);
        for (int i = 0; exports != null && i < exports.length; ++i) {
            ExportedPackage x = exports[i];
            ArrayList<Map<String, Object>> el = (ArrayList<Map<String, Object>>)ret.get("exporters");
            if (el == null) {
                el = new ArrayList<Map<String, Object>>();
                ret.put("exporters", el);
            }
            el.add(WebConsolePlugin.toJSON(x));
            exportingBundles.add(x.getExportingBundle());
        }
        ret.put("name", packageName);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<Object, Object> getMavenInfo(Bundle bundle) {
        HashMap<Object, Object> ret = null;
        Enumeration entries = bundle.findEntries("META-INF/maven", "pom.properties", true);
        if (entries != null) {
            URL u = (URL)entries.nextElement();
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = u.openStream();
                props.load(u.openStream());
                ret = new HashMap<Object, Object>(props);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return ret;
    }

    static final Set<String> getPackageNames(String findField) {
        StringTokenizer tok = new StringTokenizer(findField, " \t\n\f\r");
        TreeSet<String> result = new TreeSet<String>();
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken().trim();
            if (part.length() <= 0) continue;
            int idx = part.lastIndexOf(46);
            if (idx == part.length() - 1) {
                part = part.substring(0, part.length() - 1);
                idx = part.lastIndexOf(46);
            }
            if (idx != -1) {
                char firstCharAfterLastDot = part.charAt(idx + 1);
                if (Character.isUpperCase(firstCharAfterLastDot)) {
                    result.add(part.substring(0, idx));
                    continue;
                }
                result.add(part);
                continue;
            }
            result.add(part);
        }
        return result;
    }
}

