/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTimeout<T, U, V>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<U> firstTimeoutIndicator;
    final Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator;
    final Publisher<? extends T> other;

    public FlowableTimeout(Flowable<T> source, Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
        super(source);
        this.firstTimeoutIndicator = firstTimeoutIndicator;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.other == null) {
            TimeoutSubscriber<T> parent = new TimeoutSubscriber<T>(s, this.itemTimeoutIndicator);
            s.onSubscribe(parent);
            parent.startFirstTimeout(this.firstTimeoutIndicator);
            this.source.subscribe(parent);
        } else {
            TimeoutFallbackSubscriber<T> parent = new TimeoutFallbackSubscriber<T>(s, this.itemTimeoutIndicator, this.other);
            s.onSubscribe(parent);
            parent.startFirstTimeout(this.firstTimeoutIndicator);
            this.source.subscribe(parent);
        }
    }

    static final class TimeoutConsumer
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<Object>,
    Disposable {
        private static final long serialVersionUID = 8708641127342403073L;
        final TimeoutSelectorSupport parent;
        final long idx;

        TimeoutConsumer(long idx, TimeoutSelectorSupport parent) {
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this, s, Long.MAX_VALUE);
        }

        public void onNext(Object t) {
            Subscription upstream = (Subscription)this.get();
            if (upstream != SubscriptionHelper.CANCELLED) {
                upstream.cancel();
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.onTimeout(this.idx);
            }
        }

        public void onError(Throwable t) {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.onTimeoutError(this.idx, t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.onTimeout(this.idx);
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class TimeoutFallbackSubscriber<T>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T>,
    TimeoutSelectorSupport {
        private static final long serialVersionUID = 3764492702657003550L;
        final Subscriber<? super T> downstream;
        final Function<? super T, ? extends Publisher<?>> itemTimeoutIndicator;
        final SequentialDisposable task;
        final AtomicReference<Subscription> upstream;
        final AtomicLong index;
        Publisher<? extends T> fallback;
        long consumed;

        TimeoutFallbackSubscriber(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<?>> itemTimeoutIndicator, Publisher<? extends T> fallback) {
            super(true);
            this.downstream = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
            this.fallback = fallback;
            this.index = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, s)) {
                this.setSubscription(s);
            }
        }

        public void onNext(T t) {
            Publisher<?> itemTimeoutPublisher;
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            Disposable d = (Disposable)this.task.get();
            if (d != null) {
                d.dispose();
            }
            ++this.consumed;
            this.downstream.onNext(t);
            try {
                itemTimeoutPublisher = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t), "The itemTimeoutIndicator returned a null Publisher.");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.get().cancel();
                this.index.getAndSet(Long.MAX_VALUE);
                this.downstream.onError(ex);
                return;
            }
            TimeoutConsumer consumer = new TimeoutConsumer(idx + 1L, this);
            if (this.task.replace(consumer)) {
                itemTimeoutPublisher.subscribe((Subscriber)consumer);
            }
        }

        void startFirstTimeout(Publisher<?> firstTimeoutIndicator) {
            TimeoutConsumer consumer;
            if (firstTimeoutIndicator != null && this.task.replace(consumer = new TimeoutConsumer(0L, this))) {
                firstTimeoutIndicator.subscribe((Subscriber)consumer);
            }
        }

        public void onError(Throwable t) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t);
                this.task.dispose();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.task.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                Publisher<? extends T> f = this.fallback;
                this.fallback = null;
                long c = this.consumed;
                if (c != 0L) {
                    this.produced(c);
                }
                f.subscribe(new FlowableTimeoutTimed.FallbackSubscriber<T>(this.downstream, this));
            }
        }

        @Override
        public void onTimeoutError(long idx, Throwable ex) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.task.dispose();
        }
    }

    static final class TimeoutSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription,
    TimeoutSelectorSupport {
        private static final long serialVersionUID = 3764492702657003550L;
        final Subscriber<? super T> downstream;
        final Function<? super T, ? extends Publisher<?>> itemTimeoutIndicator;
        final SequentialDisposable task;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;

        TimeoutSubscriber(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<?>> itemTimeoutIndicator) {
            this.downstream = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s);
        }

        public void onNext(T t) {
            Publisher<?> itemTimeoutPublisher;
            long idx = this.get();
            if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
                return;
            }
            Disposable d = (Disposable)this.task.get();
            if (d != null) {
                d.dispose();
            }
            this.downstream.onNext(t);
            try {
                itemTimeoutPublisher = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t), "The itemTimeoutIndicator returned a null Publisher.");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.get().cancel();
                this.getAndSet(Long.MAX_VALUE);
                this.downstream.onError(ex);
                return;
            }
            TimeoutConsumer consumer = new TimeoutConsumer(idx + 1L, this);
            if (this.task.replace(consumer)) {
                itemTimeoutPublisher.subscribe((Subscriber)consumer);
            }
        }

        void startFirstTimeout(Publisher<?> firstTimeoutIndicator) {
            TimeoutConsumer consumer;
            if (firstTimeoutIndicator != null && this.task.replace(consumer = new TimeoutConsumer(0L, this))) {
                firstTimeoutIndicator.subscribe((Subscriber)consumer);
            }
        }

        public void onError(Throwable t) {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError((Throwable)new TimeoutException());
            }
        }

        @Override
        public void onTimeoutError(long idx, Throwable ex) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            this.task.dispose();
        }
    }

    static interface TimeoutSelectorSupport
    extends FlowableTimeoutTimed.TimeoutSupport {
        public void onTimeoutError(long var1, Throwable var3);
    }
}

